// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_VALUE_FACTORY_MANAGER_H
#define OB_VALUE_FACTORY_MANAGER_H

#include <OB/ValueFactoryManager_fwd.h>
#include <OB/ValueFactoryBase_fwd.h>

#include <OB/Hashtable.h>

namespace OB
{

//
// The ValueFactoryManager class
//
class ValueFactoryManager : public RefCount, public JTCMutex
{
    //
    // Hide copy-constructor and assignment operator
    //
    ValueFactoryManager(const ValueFactoryManager&);
    void operator=(const ValueFactoryManager&);

    //
    // The set of registered valuetype factories
    //
    typedef Hashtable<CORBA::String_var, CORBA::ValueFactoryBase_var,
	StringHasher> FactoryTable;
    FactoryTable* factories_;

    bool destroy_; // True if destroy() was called

public:

    ValueFactoryManager();
    virtual ~ValueFactoryManager();

    static inline ValueFactoryManager_ptr _duplicate(ValueFactoryManager_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline ValueFactoryManager_ptr _nil()
    { return 0; }

    //
    // Destroy the ValueFactoryManager
    //
    void destroy();

    CORBA::ValueFactoryBase* registerValueFactory(const char*,
						  CORBA::ValueFactoryBase*);

    void unregisterValueFactory(const char*);
    
    CORBA::ValueFactoryBase* lookupValueFactory(const char*);
};

} // End of namespace OB

namespace CORBA
{

inline void
release(OB::ValueFactoryManager_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(OB::ValueFactoryManager_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
