// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_TIME_HELPER_H
#define OB_TIME_HELPER_H

#ifndef OB_IMPORT
#   ifdef OB_DLL
#      define OB_IMPORT __declspec(dllimport)
#   else
#      define OB_IMPORT /**/
#   endif
#endif

namespace OB
{

//
// This is a simpler set of functions to work with TimeBase::UtcT, and
// TimeBase::TimeT values.
//
// The Time Service uses units of 100 nanoseconds and a base time
// of 15 October 1582 00:00:00.
//
//
class TimeHelper
{
public:

    //
    // Max TimeT value
    //
#if defined(WIN32) || defined(_AIX)
    OB_IMPORT static const CORBA::ULongLong MaxTimeT;
#else
    static const CORBA::ULongLong MaxTimeT = OB_ULONGLONG(0xffffffffffffffff);
#endif

    //
    // Max InaccruacyT value
    //
#if defined(WIN32) || defined(_AIX)
    OB_IMPORT static const CORBA::ULongLong MaxInaccuracyT;
#else
    static const CORBA::ULongLong MaxInaccuracyT = OB_ULONGLONG(0xffffffffffff);
#endif

    //
    // Get current time in unit of 100 ns
    //
    static TimeBase::UtcT
    utcNow(TimeBase::InaccuracyT = 0);

    static TimeBase::UtcT
    utcMin();

    static TimeBase::UtcT
    utcMax();

    static timeval
    toTimeval(const TimeBase::UtcT&);

    static timeval
    toTimeval(TimeBase::TimeT);

    static TimeBase::IntervalT
    toIntervalT(TimeBase::TimeT, TimeBase::InaccuracyT);

    static TimeBase::UtcT
    toUtcT(TimeBase::TimeT, TimeBase::InaccuracyT, TimeBase::TdfT = 0);

    static TimeBase::UtcT
    toUtcT(const TimeBase::IntervalT&);

    static char*
    toString(const TimeBase::UtcT&);

    static char*
    toTimeString(const TimeBase::UtcT&);

    static char*
    toString(TimeBase::TimeT);
};

//
// Global helper functions
//
bool
operator<(const TimeBase::UtcT&, const TimeBase::UtcT&);

bool
operator<=(const TimeBase::UtcT&, const TimeBase::UtcT&);

bool
operator>(const TimeBase::UtcT&, const TimeBase::UtcT&);

bool
operator>=(const TimeBase::UtcT&, const TimeBase::UtcT&);

bool
operator==(const TimeBase::UtcT&, const TimeBase::UtcT&);

bool
operator!=(const TimeBase::UtcT&, const TimeBase::UtcT&);

TimeBase::UtcT
operator+(const TimeBase::UtcT&, TimeBase::TimeT);

TimeBase::UtcT
operator+(TimeBase::TimeT, const TimeBase::UtcT&);

TimeBase::UtcT
operator-(const TimeBase::UtcT&, TimeBase::TimeT);

}; // End of namespace OB

#endif
