// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_REF_COUNTED_H
#define OB_REF_COUNTED_H

#include <OB/Object.h>
#include <OB/Policy_fwd.h>
#include <OB/RefCounted_fwd.h>

#include <OB/Any.h>
#include <OB/TypeCodeConst.h>
#include <OB/OCITypes.h>
#include <OB/TimeBase.h>
#include <OB/OBPolicies.h>

//
// This files contains immutable, reference-counted wrappers for
// several non reference-counted datatypes. (Do not port this to Java
// - it's unnecessary there.)
//

namespace CORBA
{

//
// PolicyList
//
class OBUnique_PolicyList;
typedef OB::ObjSeq< Policy, OBUnique_PolicyList > PolicyList;

} // End of namespace CORBA

namespace OB
{

//
// A reference counted, immutable IOR
//
class RefCountIOR : public RefCount
{
    //
    // Hide copy-constructor and assignment operator
    //
    RefCountIOR(const RefCountIOR&);
    void operator=(const RefCountIOR&);

public:

    const IOP::IOR value; // The immutable IOR

    RefCountIOR(const IOP::IOR& v) : value(v) { }

    static inline RefCountIOR_ptr _duplicate(RefCountIOR_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline RefCountIOR_ptr _nil()
    { return 0; }
};

} // End of namespace OB

namespace CORBA
{

//
// release and is_nil
//
inline void
release(OB::RefCountIOR_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(OB::RefCountIOR_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

namespace OB
{

//
// A reference counted, immutable PolicyList
//
class RefCountPolicyList : public RefCount
{
    //
    // Hide copy-constructor and assignment operator
    //
    RefCountPolicyList(const RefCountPolicyList&);
    void operator=(const RefCountPolicyList&);

    //
    // Get the value of the timeout, retry value, sync scope and
    // location transparency policies from the list
    //
    static OB::RetryAttributes getRetry(const CORBA::PolicyList&);
    static CORBA::Long getConnectTimeout(const CORBA::PolicyList&);
    static CORBA::Long getRequestTimeout(const CORBA::PolicyList&);
    static TimeBase::UtcT getRequestStartTime(const CORBA::PolicyList&);
    static TimeBase::UtcT getRequestEndTime(const CORBA::PolicyList&);
    static TimeBase::UtcT getReplyStartTime(const CORBA::PolicyList&);
    static TimeBase::UtcT getReplyEndTime(const CORBA::PolicyList&);
    static TimeBase::TimeT getRelativeRequestTimeout(const CORBA::PolicyList&);
    static TimeBase::TimeT 
    getRelativeRoundTripTimeout(const CORBA::PolicyList&);
    static CORBA::Short getRebindMode(const CORBA::PolicyList&);
    static CORBA::Short getSyncScope(const CORBA::PolicyList&);
    static CORBA::Short getLocationTransparency(const CORBA::PolicyList&);
    static bool getInterceptor(const CORBA::PolicyList&);
    static bool getLocateRequest(const CORBA::PolicyList&);

public:

    //
    // The immutable PolicyList
    //
    const CORBA::PolicyList value;

    //
    // The immutable value of the retry policy
    //
    const OB::RetryAttributes retry;

    //
    // The immutable value of the connect timeout policy
    //
    const CORBA::Long connectTimeout; 

    //
    // The immutable value of the request timeout policy
    //
    const CORBA::Long requestTimeout; 

    //
    // The immutable value of the request start time policy
    //
    const TimeBase::UtcT requestStartTime;

    //
    // The immutable value of the request end time policy
    //
    const TimeBase::UtcT requestEndTime;

    //
    // The immutable value of the reply start time policy
    //
    const TimeBase::UtcT replyStartTime;

    //
    // The immutable value of the reply end time policy
    //
    const TimeBase::UtcT replyEndTime;

    //
    // The immutable value of the relative request timeout policy
    //
    const TimeBase::TimeT relativeRequestTimeout;

    //
    // The immutable value of the relative round trip timeout policy
    //
    const TimeBase::TimeT relativeRoundTripTimeout;

    //
    // The immutable value of the rebind mode policy
    //
    const CORBA::Short rebindMode;

    //
    // The immutable value of the sync scope policy
    //
    const CORBA::Short syncScope;

    //
    // The immutable value of the location transparency policy
    //
    const CORBA::Short locationTransparency;

    //
    // The immutable value of the InterceptorPolicy, or true if there
    // is no such policy
    //
    const bool interceptor;

    //
    // The immutable value of the LocateRequestPolicy, or false if there
    // is no such policy
    //
    const bool locateRequest;

    RefCountPolicyList(const CORBA::PolicyList&);

    static inline RefCountPolicyList_ptr _duplicate(RefCountPolicyList_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline RefCountPolicyList_ptr _nil()
    { return 0; }
};

} // End of namespace OB

namespace CORBA
{

//
// release and is_nil
//
inline void
release(OB::RefCountPolicyList_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(OB::RefCountPolicyList_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

namespace OB
{

//
// A reference counted, immutable ProfileInfo
//
class RefCountProfileInfo : public RefCount
{
    //
    // Hide copy-constructor and assignment operator
    //
    RefCountProfileInfo(const RefCountProfileInfo&);
    void operator=(const RefCountProfileInfo&);

public:

    const OCI::ProfileInfo value; // The immutable ProfileInfo

    RefCountProfileInfo(const OCI::ProfileInfo& v) : value(v) { }

    static inline RefCountProfileInfo_ptr _duplicate(RefCountProfileInfo_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline RefCountProfileInfo_ptr _nil()
    { return 0; }
};

} // End of namespace OB

namespace CORBA
{

//
// release and is_nil
//
inline void
release(OB::RefCountProfileInfo_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(OB::RefCountProfileInfo_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
