// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef IMR_ORT_IMPL_H
#define IMR_ORT_IMPL_H

#include <OB/ValueBase.h>
#include <OB/ValueFactoryBase.h>
#include <OB/IMRORT.h>

namespace OBPortableInterceptor
{

class IMRORT_impl :
    virtual public OBV_OBPortableInterceptor::IMRORT,
    virtual public CORBA::DefaultValueRefCountBase
{
    //
    // Hide copy-constructor and assignment operator
    //
    IMRORT_impl(const IMRORT_impl&);
    void operator=(const IMRORT_impl&);

public:

    IMRORT_impl();
    IMRORT_impl(const char*,
    	        const PortableInterceptor::AdapterName&,
		PortableInterceptor::ObjectReferenceTemplate*);

    ~IMRORT_impl();

    //
    // Standard IDL to C++ Mapping
    //

    virtual CORBA::ValueBase* _copy_value()
	throw(CORBA::SystemException);

    virtual PortableInterceptor::ServerId server_id()
	throw(CORBA::SystemException);

    virtual PortableInterceptor::ORBId orb_id()
	throw(CORBA::SystemException);

    virtual PortableInterceptor::AdapterName* adapter_name()
	throw(CORBA::SystemException);

    virtual CORBA::Object_ptr make_object(const char*,
                                          const PortableInterceptor::ObjectId&)
	throw(CORBA::SystemException);
};

class IMRORTFactory_impl :
	virtual public CORBA::ValueFactoryBase
{
    virtual CORBA::ValueBase* create_for_unmarshal()
	throw(CORBA::SystemException);

public:

    IMRORTFactory_impl();
    virtual ~IMRORTFactory_impl();
};

} // End namespace OBPortableInterceptor

#endif
