// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_ITERATOR_H
#define OB_ITERATOR_H

#include <OB/STLConfig.h>

namespace OB
{

namespace stl
{

//
// A forward iterator that is used to add items to a container via
// push_back when items are assigned to the iterator.
// The increment operators have no effect.
// This can be used to allow standard algorithms to transparently grow
// containers.
// For example:
//   list<int> target;
//   copy(src.begin(), src.end(), back_inserter(target));
//
template<class ContainerT>
class back_insert_iterator
{
private:
    ContainerT &container_;
    
public:
    explicit back_insert_iterator(ContainerT &container)
        : container_(container)
    {
    }
    
    back_insert_iterator& operator=(
        const typename ContainerT::value_type& value)
    {
        container_.push_back(value);
        return *this;
    }
    
    back_insert_iterator& operator*()
    {
        return *this;
    }
    
    back_insert_iterator& operator++()
    {
        return *this;
    }
    
    back_insert_iterator& operator++(int)
    {
        return *this;
    }
};

//
// Convenience function to create a back_insert_iterator
//
template<class ContainerT>
back_insert_iterator<ContainerT> back_inserter(ContainerT& container)
{
    return back_insert_iterator<ContainerT>(container);
}

} // End of namespace stl

} // End of namespace OB

#endif
