// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// *********************************************************************

#ifndef __OB_LoadUpdaterInit_h__
#define __OB_LoadUpdaterInit_h__

#include <OB/LoadUpdater.h>

//
// IDL:ooc.com/LoadBalancing:1.0
//
namespace LoadBalancing
{

//
// Initialize the load balancing service member
//
// The LoadUpdaterInit() function *must* be called before
// initializing the ORB.  Futhermore, the "LoadBalancer" initial
// reference must be configured and the following following
// configuration properties must be set:
//
//   ooc.balancer.load_updater.group=GROUP_NAME
//   ooc.balancer.load_updater.member=MEMBER_NAME
//   ooc.balancer.load_updater.frequency=LONG
//   ooc.balancer.load_updater.use_interceptor=TRUE|FALSE
//
// An alternative to the above configuration properties is the following
// command-line options:
//
//   -LBgroup GROUP_NAME
//   -LBmember MEMBER_NAME
//   -LBfrequency LONG
//   -LBuse_interceptor
//
// If these properties are not set or have invalid values, then
// initialization of the LoadUpdater will fail.  If the bool parameter
// is set to true, then a warning message will be logged and ORB_init()
// will raise an INITIALIZE exception.  If the bool parameter is set
// to false, then a warning message will be logged, but no exception
// will be thrown (this will allow a member to be used as an active or
// non-active member).
// 
// If the command-line usage is not correct, then LoadUpdaterInit() will
// return EXIT_FAILURE.  Note that a return value of EXIT_SUCCESS does
// not indicate that the LoadUpdater initialization will succeed, but
// only that command-line options were properly set.
//
int LoadUpdaterInit(int&, char**, bool);

} // End of namespace LoadBalancing

#endif
