// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_EVENT_HANDLER_BASE_H
#define OB_EVENT_HANDLER_BASE_H

#include <OB/EventHandlerBase_fwd.h>

#include <OB/Object.h>
#include <OB/NativeTypes.h>
#include <OB/TypeCode.h>
#include <OB/Reactor.h>

namespace OB
{

//
// The EventHandler class
//
class EventHandlerBase : virtual public RefCount
{
    //
    // Hide copy-constructor and assignment operator
    //
    EventHandlerBase(const EventHandlerBase&);
    void operator=(const EventHandlerBase&);

protected:

    EventHandlerBase() { }
    virtual ~EventHandlerBase() { }

public:

    static inline EventHandlerBase_ptr _duplicate(EventHandlerBase_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline EventHandlerBase_ptr _nil()
    { return 0; }

    //
    // Handle events. Returns all event types that have been handled.
    //
    virtual OB::Mask handleEvent(OB::Mask) = 0;
};

} // End namespace OB

namespace CORBA
{

inline void
release(OB::EventHandlerBase_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(OB::EventHandlerBase_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
