// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_ENVIRONMENT_H
#define OB_ENVIRONMENT_H

#include <OB/Environment_fwd.h>

#include <OB/Basic.h>
#include <OB/Except.h>

namespace OBCORBA
{

class ORB_impl; // For the friend declaration

} // End namespace OBCORBA

namespace CORBA
{

//
// The Environment class
//
class Environment : public OB::RefCount
{
    //
    // The exception
    //
    Exception* exception_;

    //
    // Hide copy-constructor and assignment operator
    //
    Environment(const Environment&);
    void operator=(const Environment&);

protected:

    Environment();
    virtual ~Environment();

    friend class ::OBCORBA::ORB_impl; // ORB_impl creates Environment
    friend class Request; // Request creates Enviroment

public:

    //
    // Standard IDL to C++ Mapping
    //
    static inline Environment_ptr _duplicate(Environment_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline Environment_ptr _nil()
    { return 0; }

    void exception(Exception*);
    Exception* exception() const;
    void clear() { exception(0); }
};

inline void
release(Environment_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(Environment_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
