// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_DOWNCALL_FWD_H
#define OB_DOWNCALL_FWD_H

#include <OB/Template.h>

namespace OB
{

class Downcall;
typedef Downcall* Downcall_ptr;

class PIDowncall;
typedef PIDowncall* PIDowncall_ptr;

class PIArgsDowncall;
typedef PIArgsDowncall* PIArgsDowncall_ptr;

class PIDIIDowncall;
typedef PIDIIDowncall* PIDIIDowncall_ptr;

class DowncallEmitter;
typedef DowncallEmitter* DowncallEmitter_ptr;

} // End of namespace OB

void OBDuplicate(OB::Downcall_ptr);
void OBRelease(OB::Downcall_ptr);

/*
void OBDuplicate(OB::PIDowncall_ptr);
void OBRelease(OB::PIDowncall_ptr);

void OBDuplicate(OB::PIArgsDowncall_ptr);
void OBRelease(OB::PIArgsDowncall_ptr);

void OBDuplicate(OB::PIArgsDowncall_ptr);
void OBRelease(OB::PIArgsDowncall_ptr);
*/

void OBDuplicate(OB::DowncallEmitter_ptr);
void OBRelease(OB::DowncallEmitter_ptr);

namespace OB
{

typedef ObjVar< Downcall > Downcall_var;

/*
typedef ObjVar< PIDowncall > PIDowncall_var;

typedef ObjVar< PIArgsDowncall > PIArgsDowncall_var;

typedef ObjVar< PIDIIDowncall > PIDIIDowncall_var;
*/

typedef ObjVar< DowncallEmitter > DowncallEmitter_var;

} // End of namespace OB

#endif
