// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_CORE_TRACE_LEVELS_H
#define OB_CORE_TRACE_LEVELS_H

#include <OB/Basic.h>

#include <OB/TypeCodeConst_fwd.h>
#include <OB/CoreTraceLevels_fwd.h>
#include <OB/Properties_fwd.h>
#include <OB/Logger_fwd.h>

namespace OB
{

class CoreTraceLevels : public RefCount
{

    CORBA::ULong traceConnections_;
    CORBA::ULong traceRetry_;

public:

    CoreTraceLevels(Logger_ptr, Properties_ptr);
    ~CoreTraceLevels();

    static inline CoreTraceLevels_ptr _duplicate(CoreTraceLevels_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline CoreTraceLevels_ptr _nil()
    { return 0; }

    CORBA::ULong traceConnections() const { return traceConnections_; }

    CORBA::ULong traceRetry() const { return traceRetry_; }

};

} // End namespace OB

namespace CORBA
{

inline void
release(OB::CoreTraceLevels_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(OB::CoreTraceLevels_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
