/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosTypedEventChannelAdmin;

import com.ooc.OB.Assert;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.OperationDescriptionHelper;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.TRANSIENT;

class ChannelType {
    private ORB orb_;
    private Vector typeIds_ = new Vector();
    private Vector operations_ = new Vector();
    private String interfaceId_;

    private void typeIds(InterfaceDef iface) {
        this.typeIds_.addElement(iface.id());
        InterfaceDef[] base = iface.base_interfaces();
        for (int i = 0; i < base.length; ++i) {
            String typeId;
            int j;
            String id = base[i].id();
            for (j = 0; j < this.typeIds_.size() && !(typeId = (String)this.typeIds_.elementAt(j)).equals(id); ++j) {
            }
            if (j != this.typeIds_.size()) continue;
            this.typeIds(base[i]);
        }
    }

    public ChannelType(ORB orb) {
        this.orb_ = orb;
    }

    public boolean isCompatible(String id) {
        for (int i = 0; i < this.typeIds_.size(); ++i) {
            String typeId = (String)this.typeIds_.elementAt(i);
            if (!typeId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean assignTypeId(String id) {
        if (this.typeIds_.size() != 0) {
            return this.isCompatible(id);
        }
        Repository ir = null;
        try {
            Object irObj = this.orb_.resolve_initial_references("InterfaceRepository");
            ir = RepositoryHelper.narrow((Object)irObj);
        }
        catch (InvalidName ex) {
        }
        catch (BAD_PARAM ex) {
        }
        catch (COMM_FAILURE ex) {
        }
        catch (TRANSIENT ex) {
            // empty catch block
        }
        if (ir == null) {
            throw new INTF_REPOS();
        }
        Contained contained = ir.lookup_id(id);
        if (contained == null) {
            return false;
        }
        InterfaceDef iface = null;
        try {
            iface = InterfaceDefHelper.narrow((Object)contained);
        }
        catch (BAD_PARAM ex) {
            return false;
        }
        this.typeIds(iface);
        Contained[] ops = iface.contents(DefinitionKind.dk_Operation, false);
        this.operations_.removeAllElements();
        for (int i = 0; i < ops.length; ++i) {
            Description description = ops[i].describe();
            OperationDescription opDesc = null;
            try {
                opDesc = OperationDescriptionHelper.extract((Any)description.value);
            }
            catch (BAD_OPERATION ex) {
                // empty catch block
            }
            Assert._OB_assert((opDesc != null ? 1 : 0) != 0);
            this.operations_.addElement(opDesc);
        }
        this.interfaceId_ = iface.id();
        return true;
    }

    public OperationDescription[] getOperations() {
        OperationDescription[] rc = new OperationDescription[this.operations_.size()];
        for (int i = 0; i < this.operations_.size(); ++i) {
            rc[i] = (OperationDescription)this.operations_.elementAt(i);
        }
        return rc;
    }

    public String[] getTypeIds() {
        String[] rc = new String[this.typeIds_.size()];
        for (int i = 0; i < this.typeIds_.size(); ++i) {
            rc[i] = (String)this.typeIds_.elementAt(i);
        }
        return rc;
    }

    public String getInterfaceId() {
        return this.interfaceId_;
    }
}

