/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.CORBA.ORB;
import com.ooc.CosEvent.EventLogger;
import com.ooc.OB.Assert;
import java.util.Enumeration;
import java.util.Properties;

public final class SetDefaultProperties {
    private static final DefaultProperties[] defaults_ = new DefaultProperties[]{new DefaultProperties("ooc.event.max_retries", "10"), new DefaultProperties("ooc.event.max_events", "10"), new DefaultProperties("ooc.event.retry_timeout", "1000"), new DefaultProperties("ooc.event.retry_multiplier", "2"), new DefaultProperties("ooc.event.pull_interval", "0"), new DefaultProperties("ooc.event.request_timeout", "5000")};

    private static void setDefault(Properties properties, String key) {
        for (int i = 0; i < defaults_.length; ++i) {
            if (!SetDefaultProperties.defaults_[i].key.equals(key)) continue;
            properties.put(SetDefaultProperties.defaults_[i].key, SetDefaultProperties.defaults_[i].value);
            return;
        }
    }

    public static void setDefaults(org.omg.CORBA.ORB orb, EventLogger logger) {
        String progName = "EventService";
        ORB oborb = (ORB)orb;
        Properties properties = oborb.properties();
        for (int i = 0; i < defaults_.length; ++i) {
            if (properties.getProperty(SetDefaultProperties.defaults_[i].key) != null) continue;
            properties.put(SetDefaultProperties.defaults_[i].key, SetDefaultProperties.defaults_[i].value);
        }
        String propRoot = "ooc.event.";
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(propRoot)) continue;
            String value = properties.getProperty(key);
            Assert._OB_assert((value != null ? 1 : 0) != 0);
            if (key.equals("ooc.event.max_retries") || key.equals("ooc.event.pull_interval")) {
                long v;
                try {
                    v = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    v = -1L;
                }
                if (v >= 0L) continue;
                logger.warning(progName + ": " + key + " must be >= 0. Using default value.");
                SetDefaultProperties.setDefault(properties, key);
                continue;
            }
            if (key.equals("ooc.event.max_events")) {
                long v;
                try {
                    v = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    v = -1L;
                }
                if (v > 0L) continue;
                logger.warning(progName + ": " + key + " must be > 0. Using default value");
                SetDefaultProperties.setDefault(properties, key);
                continue;
            }
            if (key.equals("ooc.event.retry_timeout") || key.equals("ooc.event.request_timeout")) {
                long v;
                try {
                    v = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    v = -1L;
                }
                if (v >= 0L && v <= 999999L) continue;
                logger.warning(progName + ": " + key + " must be > 0 and < 999999. " + "Using default value");
                SetDefaultProperties.setDefault(properties, key);
                continue;
            }
            if (key.equals("ooc.event.retry_multiplier")) {
                double v;
                try {
                    v = Double.valueOf(value);
                }
                catch (NumberFormatException e) {
                    v = -1.0;
                }
                if (!(v < 0.0) && !(v > 999999.0)) continue;
                logger.warning(progName + ": " + key + " must be > 0 and < 999999. " + "Using default value");
                SetDefaultProperties.setDefault(properties, key);
                continue;
            }
            if (key.equals("ooc.event.typed_service") || key.equals("ooc.event.endpoint") || key.equals("ooc.event.reap_frequency") || key.equals("ooc.event.inactivity_timeout") || key.equals("ooc.event.trace.events") || key.equals("ooc.event.trace.lifecycle")) continue;
            logger.warning(progName + ": `" + key + "': unknown property");
        }
    }

    private static final class DefaultProperties {
        String key;
        String value;

        DefaultProperties(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }
}

