/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.CORBA.ORB;
import com.ooc.CosEvent.EventLogger;
import com.ooc.CosEvent.EventUtil;
import com.ooc.CosEvent.PipeSegment;
import com.ooc.CosEvent.ProxyBase;
import com.ooc.CosEvent.ProxyConstructorInfo;
import com.ooc.CosEvent.ProxyState;
import com.ooc.CosEvent.QoSParameters;
import com.ooc.OB.Assert;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SetOverrideType;
import org.omg.PortableServer.POA;

public class ProxyBaseImpl {
    private org.omg.CORBA.ORB orb_;
    private POA poa_;
    private EventLogger logger_;
    private PipeSegment parentPipe_;
    private PipeSegment myPipe_;
    private ProxyBase proxy_;
    private long id_;
    private String name_;
    private long lastRequestTime_;
    private ProxyState state_;

    public ProxyBaseImpl(ProxyConstructorInfo info, ProxyBase proxy) {
        this.proxy_ = proxy;
        this.lastRequestTime_ = System.currentTimeMillis();
        this.state_ = ProxyState.Disconnected;
        this.orb_ = info.orb;
        this.poa_ = info.poa;
        this.logger_ = info.logger;
        this.id_ = info.id;
        this.parentPipe_ = info.pipe;
        this.name_ = info.base + "-" + this.id_;
        if (this.logger_.traceLifecycle() >= 2) {
            String desc = null;
            try {
                desc = EventUtil.getConnectionAddrDescription(this.orb_);
            }
            catch (NO_RESOURCES ex) {
                desc = "`connection address unavailable'";
            }
            this.logger_.trace("event", "Create " + this.name_ + " from " + desc);
        }
    }

    protected void finalize() throws Throwable {
        if (this.logger_.traceLifecycle() >= 2) {
            this.logger_.trace("event", "Destroy " + this.name_);
        }
    }

    public void resolveQoSParams(QoSParameters params) {
        try {
            ORB oborb = (ORB)this.orb_;
            Properties properties = oborb.properties();
            params.retryTimeout = Long.parseLong(properties.getProperty("ooc.event.retry_timeout"));
            params.retryMultiplier = Double.valueOf(properties.getProperty("ooc.event.retry_multiplier"));
            params.maxRetries = Long.parseLong(properties.getProperty("ooc.event.max_retries"));
            params.maxEvents = Long.parseLong(properties.getProperty("ooc.event.max_events"));
            params.pullInterval = Long.parseLong(properties.getProperty("ooc.event.pull_interval"));
            params.requestTimeout = Long.parseLong(properties.getProperty("ooc.event.request_timeout"));
        }
        catch (NumberFormatException e) {
            Assert._OB_assert((boolean)false);
        }
    }

    public Object applyRequestTimeout(Object obj, QoSParameters params) {
        Policy[] pl = new Policy[1];
        Any any = this.orb_.create_any();
        any.insert_ulong((int)params.requestTimeout);
        try {
            pl[0] = this.orb_.create_policy(1330577413, any);
            return obj._set_policy_override(pl, SetOverrideType.ADD_OVERRIDE);
        }
        catch (PolicyError e) {
            Assert._OB_assert((boolean)false);
            return obj;
        }
        catch (BAD_OPERATION e) {
            return obj;
        }
    }

    public void disconnect() {
        if (this.state_ == ProxyState.Destroyed) {
            return;
        }
        this.state_ = ProxyState.Destroyed;
        if (this.myPipe_ != null) {
            this.myPipe_.destroy();
        }
        this.proxy_.disconnectPeer();
        this.proxy_.deactivateObject();
    }

    public void discardRequests() {
        if (this.state_ == ProxyState.Destroyed || this.state_ == ProxyState.Discarding) {
            return;
        }
        this.state_ = ProxyState.Discarding;
        if (this.myPipe_ != null) {
            this.myPipe_.destroy();
        }
    }

    public boolean destroyed() {
        return this.state_ == ProxyState.Destroyed;
    }

    public long lastRequestTime() {
        return this.lastRequestTime_;
    }

    public void stampRequest() {
        this.lastRequestTime_ = System.currentTimeMillis();
    }

    public String getName() {
        return this.name_;
    }

    public org.omg.CORBA.ORB getOrb() {
        return this.orb_;
    }

    public POA getPoa() {
        return this.poa_;
    }

    public EventLogger getLogger() {
        return this.logger_;
    }

    public PipeSegment getParentPipe() {
        return this.parentPipe_;
    }

    public PipeSegment getMyPipe() {
        return this.myPipe_;
    }

    public void setMyPipe(PipeSegment pipe) {
        this.myPipe_ = pipe;
    }

    public long getId() {
        return this.id_;
    }

    public ProxyState getState() {
        return this.state_;
    }

    public void setState(ProxyState state) {
        this.state_ = state;
    }
}

