/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.CORBA.ORB;
import com.ooc.OBEventChannelFactory.ChannelAlreadyExists;
import com.ooc.OBEventChannelFactory.ChannelNotAvailable;
import com.ooc.OBEventChannelFactory.EventChannelFactory;
import com.ooc.OBEventChannelFactory.EventChannelFactoryHelper;
import com.ooc.OBTypedEventChannelFactory.TypedEventChannelFactory;
import com.ooc.OBTypedEventChannelFactory.TypedEventChannelFactoryHelper;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringSeqHolder;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.CosEventChannelAdmin.EventChannel;
import org.omg.CosTypedEventChannelAdmin.TypedEventChannel;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

final class EventAdmin {
    static final String progName = "com.ooc.CosEvent.EventAdmin";

    EventAdmin() {
    }

    private static void usage() {
        System.err.println("Usage:\ncom.ooc.CosEvent.EventAdmin [options] command\n\nOptions:\n-h, --help             Show this message.\n-v, --version          Show version number.\n-t, --typed-service    Admin for typed event service.\n-u, --untyped-service  Admin for untyped event service [default].\n\nCommands:\ncreate channel-id      Create a new event channel.\ndestroy channel-id     Destroy an event channel.\nlist                   Show the active event channels.\nshutdown               Terminate the event service.\n");
    }

    static int run(org.omg.CORBA.ORB orb, String[] args) throws UserException {
        int i;
        boolean typedService = false;
        POA rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                EventAdmin.usage();
                return 0;
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                System.err.println("ORBacus Event Service 4.1.3");
                return 0;
            }
            if (args[i].equals("--untyped-service") || args[i].equals("-u")) continue;
            if (args[i].equals("--typed-service") || args[i].equals("-t")) {
                typedService = true;
                continue;
            }
            System.err.println("com.ooc.CosEvent.EventAdmin: unknown option `" + args[i] + "'\n");
            EventAdmin.usage();
            return 1;
        }
        if (i == args.length) {
            EventAdmin.usage();
            return 1;
        }
        String serviceName = typedService ? "TypedEventChannelFactory" : "EventChannelFactory";
        Object obj = null;
        try {
            obj = orb.resolve_initial_references(serviceName);
        }
        catch (InvalidName ex) {
            // empty catch block
        }
        if (obj == null) {
            System.err.println("No `" + serviceName + "' initial reference.");
            return 1;
        }
        if (typedService) {
            TypedEventChannelFactory f = null;
            try {
                f = TypedEventChannelFactoryHelper.narrow(obj);
            }
            catch (BAD_PARAM ex) {
                // empty catch block
            }
            if (f == null) {
                System.err.println("`" + serviceName + "' initial reference is invalid.");
                return 1;
            }
            if (i + 1 < args.length && args[i].equals("create")) {
                try {
                    TypedEventChannel channel = f.create_channel(args[i + 1]);
                }
                catch (ChannelAlreadyExists ex) {
                    System.err.println("Channel `" + args[i + 1] + "' already exists");
                    return 1;
                }
            } else if (i + 1 < args.length && args[i].equals("destroy")) {
                try {
                    TypedEventChannel channel = f.get_channel_by_id(args[i + 1]);
                    channel.destroy();
                }
                catch (ChannelNotAvailable ex) {
                    System.err.println("Channel `" + args[i + 1] + "' not found");
                    return 1;
                }
            } else if (i < args.length && args[i].equals("list")) {
                String[] ids = f.get_channels();
                if (ids.length == 0) {
                    System.err.println("No active channels");
                } else {
                    for (int j = 0; j < ids.length; ++j) {
                        System.out.println(ids[j]);
                    }
                }
            } else if (i < args.length && args[i].equals("shutdown")) {
                try {
                    f.shutdown();
                }
                catch (TRANSIENT ex) {}
            } else {
                EventAdmin.usage();
            }
        } else {
            EventChannelFactory f = null;
            try {
                f = EventChannelFactoryHelper.narrow(obj);
            }
            catch (BAD_PARAM ex) {
                // empty catch block
            }
            if (f == null) {
                System.err.println("`" + serviceName + "' initial reference is invalid.");
                return 1;
            }
            if (i + 1 < args.length && args[i].equals("create")) {
                try {
                    EventChannel channel = f.create_channel(args[i + 1]);
                }
                catch (ChannelAlreadyExists ex) {
                    System.err.println("Channel `" + args[i + 1] + "' already exists");
                    return 1;
                }
            } else if (i + 1 < args.length && args[i].equals("destroy")) {
                try {
                    EventChannel channel = f.get_channel_by_id(args[i + 1]);
                    channel.destroy();
                }
                catch (ChannelNotAvailable ex) {
                    System.err.println("Channel `" + args[i + 1] + "' not found");
                    return 1;
                }
            } else if (i < args.length && args[i].equals("list")) {
                String[] ids = f.get_channels();
                if (ids.length == 0) {
                    System.out.println("No active channels");
                } else {
                    for (int j = 0; j < ids.length; ++j) {
                        System.out.println(ids[j]);
                    }
                }
            } else if (i < args.length && args[i].equals("shutdown")) {
                try {
                    f.shutdown();
                }
                catch (TRANSIENT ex) {}
            } else {
                EventAdmin.usage();
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        int status = 0;
        org.omg.CORBA.ORB orb = null;
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        try {
            StringSeqHolder argsH = new StringSeqHolder(args);
            orb = ORB.init((StringSeqHolder)argsH, (Properties)props, null);
            status = EventAdmin.run(orb, argsH.value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

