/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosNaming;

import com.ooc.CosNaming.BindingIterator_impl;
import com.ooc.CosNaming.BindingListener;
import com.ooc.CosNaming.BindingListenerHelper;
import com.ooc.CosNaming.NamingDatabase;
import com.ooc.CosNaming.OBNamingContext;
import com.ooc.CosNaming.OBNamingContextPOA;
import com.ooc.CosNaming.OBNamingContextPackage.BindingUnion;
import com.ooc.CosNaming.OBNamingContextPackage.ExtendedBinding;
import com.ooc.OB.Assert;
import com.ooc.OB.CORBANameParser;
import com.ooc.OB.Logger;
import com.ooc.OB.ObjectIdHasher;
import com.ooc.OBCORBA.ORB_impl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public final class OBNamingContext_impl
extends OBNamingContextPOA {
    private static int count_;
    private POA userPOA_;
    private POA systemPOA_;
    private POA rootPOA_;
    private ORB orb_;
    private byte[] key_;
    private Policy[] timeoutPolicy_;
    private Hashtable bindings_;
    private Hashtable ncs_;
    private NamingDatabase store_;
    private int maxBindings_;
    private boolean noUpdates_;
    private boolean destroyed_;
    private Vector listeners_ = new Vector();
    private NamingContext myRef_;
    private Logger logger_;
    private int traceLevel_;
    private boolean isRoot_;

    private String bindingHashString(NameComponent[] name) {
        String result = "";
        result = result + this.addEscapes(name[0].id);
        if (name[0].kind.length() > 0) {
            result = result + '.';
            result = result + this.addEscapes(name[0].kind);
        }
        return result;
    }

    private void cleanup() {
        ObjectIdHasher key = new ObjectIdHasher(this.key_);
        if (this.ncs_ != null) {
            this.ncs_.remove(key);
        }
        if (this.store_ != null) {
            this.store_.destroy(this.key_);
        }
        try {
            if (this.isRoot_) {
                this.userPOA_.deactivate_object(this.key_);
            } else {
                this.systemPOA_.deactivate_object(this.key_);
            }
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        catch (ObjectNotActive ex) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBind(NameComponent[] n, BindingUnion bndUnion, boolean rebind, long timestamp) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (n.length == 0) {
            throw new InvalidName();
        }
        if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            java.lang.Object syncStore = this.store_ != null ? this.store_ : this.bindings_;
            java.lang.Object object = syncStore;
            synchronized (object) {
                Hashtable hashtable = this.bindings_;
                synchronized (hashtable) {
                    InternalBinding binding = (InternalBinding)this.bindings_.get(this.bindingHashString(n));
                    if (binding != null) {
                        if (!rebind) {
                            throw new AlreadyBound();
                        }
                        binding.rebind(n, bndUnion, timestamp);
                    } else {
                        this.bindings_.put(this.bindingHashString(n), new InternalBinding(n[0], bndUnion, timestamp));
                    }
                    if (this.store_ != null) {
                        this.store_.bind(this.key_, n, bndUnion, timestamp, rebind);
                    }
                }
            }
            return;
        }
        InternalBinding binding = (InternalBinding)this.bindings_.get(this.bindingHashString(n));
        if (binding == null) {
            throw new NotFound(NotFoundReason.missing_node, n);
        }
        NamingContext context = binding.context(n);
        NameComponent[] rest = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, rest, 0, rest.length);
        if (bndUnion.discriminator() == BindingType.ncontext) {
            if (rebind) {
                context.rebind_context(rest, bndUnion.nc());
            } else {
                context.bind_context(rest, bndUnion.nc());
            }
        } else if (rebind) {
            context.rebind(rest, bndUnion.obj());
        } else {
            context.bind(rest, bndUnion.obj());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindingAdded(BindingUnion bndUnion, NameComponent[] n) {
        if (n.length != 1) {
            return;
        }
        if (!this.noUpdates_) {
            Vector vector = this.listeners_;
            synchronized (vector) {
                boolean isContext;
                boolean bl = isContext = bndUnion.discriminator() == BindingType.ncontext;
                if (this.traceLevel_ >= 3) {
                    this.logger_.trace("naming", isContext ? "context binding added" : "object binding added");
                }
                Enumeration e = this.listeners_.elements();
                while (e.hasMoreElements()) {
                    BindingListener l = (BindingListener)e.nextElement();
                    try {
                        if (isContext) {
                            l.context_added(this.myRef_, bndUnion.nc(), n[0]);
                            continue;
                        }
                        l.object_added(this.myRef_, bndUnion.obj(), n[0]);
                    }
                    catch (SystemException ex) {
                        if (this.traceLevel_ >= 3) {
                            this.logger_.trace("naming", "SystemException: removing listener");
                        }
                        this.listeners_.removeElement(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindingRemoved(NameComponent[] n, boolean isContext) {
        if (n.length != 1) {
            return;
        }
        if (!this.noUpdates_) {
            Vector vector = this.listeners_;
            synchronized (vector) {
                if (this.traceLevel_ >= 3) {
                    this.logger_.trace("naming", isContext ? "context binding removed" : "object binding removed");
                }
                Enumeration e = this.listeners_.elements();
                while (e.hasMoreElements()) {
                    BindingListener l = (BindingListener)e.nextElement();
                    try {
                        if (isContext) {
                            l.context_removed(this.myRef_, n[0]);
                            continue;
                        }
                        l.object_removed(this.myRef_, n[0]);
                    }
                    catch (SystemException ex) {
                        if (this.traceLevel_ >= 2) {
                            this.logger_.trace("naming", "SystemException: removing listener");
                        }
                        this.listeners_.removeElement(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindingChanged(BindingUnion bndUnion, NameComponent[] oldName, NameComponent[] newName) {
        if (oldName.length != 1) {
            return;
        }
        if (!this.noUpdates_) {
            Vector vector = this.listeners_;
            synchronized (vector) {
                boolean isContext;
                boolean bl = isContext = bndUnion.discriminator() == BindingType.ncontext;
                if (this.traceLevel_ >= 3) {
                    this.logger_.trace("naming", isContext ? "context binding changed" : "object binding changed");
                }
                Enumeration e = this.listeners_.elements();
                while (e.hasMoreElements()) {
                    BindingListener l = (BindingListener)e.nextElement();
                    try {
                        if (isContext) {
                            l.context_changed(this.myRef_, bndUnion.nc(), oldName[0], newName[0]);
                            continue;
                        }
                        l.object_changed(this.myRef_, bndUnion.obj(), oldName[0], newName[0]);
                    }
                    catch (SystemException ex) {
                        if (this.traceLevel_ >= 2) {
                            this.logger_.trace("naming", "SystemException: removing listener");
                        }
                        this.listeners_.removeElement(l);
                    }
                }
            }
        }
    }

    private String addEscapes(String str) {
        String result = "";
        int len = str.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '.': {
                    result = result + "\\.";
                    continue block5;
                }
                case '/': {
                    result = result + "\\/";
                    continue block5;
                }
                case '\\': {
                    result = result + "\\\\";
                    continue block5;
                }
                default: {
                    result = result + c;
                }
            }
        }
        return result;
    }

    private static String addURLEscapes(String s) {
        String result = "";
        block3: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch)) {
                result = result + ch;
                continue;
            }
            switch (ch) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '_': 
                case '~': {
                    result = result + ch;
                    continue block3;
                }
                default: {
                    result = result + '%';
                    result = result + Character.toUpperCase(Character.forDigit(ch >> 4 & 0xF, 16));
                    result = result + Character.toUpperCase(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        return result;
    }

    OBNamingContext_impl createNewContext() {
        return new OBNamingContext_impl(this.userPOA_, this.systemPOA_, this.orb_, this.store_, this.ncs_, null, this.timeoutPolicy_, this.noUpdates_, this.maxBindings_, this.traceLevel_);
    }

    OBNamingContext_impl(POA userPOA, POA systemPOA, ORB orb, NamingDatabase store, Hashtable ncs, byte[] key, Policy[] timeoutPolicy, boolean noUpdates, int maxBindings, int traceLevel) {
        byte[] rootKey;
        this.userPOA_ = userPOA;
        this.systemPOA_ = systemPOA;
        this.orb_ = orb;
        this.key_ = key;
        this.bindings_ = new Hashtable(1023);
        this.ncs_ = ncs;
        this.store_ = store;
        this.timeoutPolicy_ = timeoutPolicy;
        this.noUpdates_ = noUpdates;
        this.destroyed_ = false;
        this.maxBindings_ = maxBindings;
        this.traceLevel_ = traceLevel;
        this.isRoot_ = false;
        ORB_impl oborb = (ORB_impl)orb;
        this.logger_ = oborb.logger();
        try {
            this.rootPOA_ = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
            throw new RuntimeException();
        }
        if (key != null && this.key_.length == (rootKey = "NameService".getBytes()).length) {
            int idx;
            for (idx = 0; idx < this.key_.length && this.key_[idx] == rootKey[idx]; ++idx) {
            }
            this.isRoot_ = idx == this.key_.length;
        }
        try {
            if (key == null) {
                this.key_ = this.systemPOA_.activate_object((Servant)this);
            } else {
                this.key_ = key;
                if (this.isRoot_) {
                    this.userPOA_.activate_object_with_id(this.key_, (Servant)this);
                } else {
                    this.systemPOA_.activate_object_with_id(this.key_, (Servant)this);
                }
            }
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        catch (ObjectAlreadyActive ex) {
            throw new RuntimeException();
        }
        catch (ServantAlreadyActive ex) {
            throw new RuntimeException();
        }
        this.myRef_ = this._this();
        ObjectIdHasher oid = new ObjectIdHasher(this.key_);
        this.ncs_.put(oid, this.myRef_);
        if (this.store_ != null) {
            this.store_.create(this.key_, (int)(System.currentTimeMillis() / 1000L));
        }
    }

    protected void finalize() throws Throwable {
        if (this.ncs_ != null) {
            ObjectIdHasher oid = new ObjectIdHasher(this.key_);
            this.ncs_.remove(oid);
        }
        super.finalize();
    }

    public POA _default_POA() {
        if (this.isRoot_) {
            return this.userPOA_;
        }
        return this.systemPOA_;
    }

    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        BindingUnion bndUnion = new BindingUnion();
        bndUnion.obj(obj);
        this.doBind(n, bndUnion, false, System.currentTimeMillis() / 1000L);
        this.bindingAdded(bndUnion, n);
    }

    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        BindingUnion bndUnion = new BindingUnion();
        bndUnion.obj(obj);
        try {
            this.doBind(n, bndUnion, true, System.currentTimeMillis() / 1000L);
        }
        catch (AlreadyBound ex) {
            Assert._OB_assert((boolean)false);
        }
        this.bindingChanged(bndUnion, n, n);
    }

    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (nc == null) {
            throw new BAD_PARAM();
        }
        BindingUnion bndUnion = new BindingUnion();
        bndUnion.nc(nc);
        this.doBind(n, bndUnion, false, System.currentTimeMillis() / 1000L);
        this.bindingAdded(bndUnion, n);
    }

    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (nc == null) {
            throw new BAD_PARAM();
        }
        BindingUnion bndUnion = new BindingUnion();
        bndUnion.nc(nc);
        try {
            this.doBind(n, bndUnion, true, System.currentTimeMillis() / 1000L);
        }
        catch (AlreadyBound ex) {
            Assert._OB_assert((boolean)false);
        }
        this.bindingChanged(bndUnion, n, n);
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (n.length == 0) {
            throw new InvalidName();
        }
        if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
            throw new InvalidName();
        }
        InternalBinding binding = (InternalBinding)this.bindings_.get(this.bindingHashString(n));
        if (binding == null) {
            throw new NotFound(NotFoundReason.missing_node, n);
        }
        if (n.length == 1) {
            return binding.object();
        }
        NamingContext context = binding.context(n);
        NameComponent[] rest = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, rest, 0, rest.length);
        return context.resolve(rest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (n.length == 0) {
            throw new InvalidName();
        }
        if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            boolean isContext = false;
            java.lang.Object syncStore = this.store_ != null ? this.store_ : this.bindings_;
            java.lang.Object object = syncStore;
            synchronized (object) {
                Hashtable hashtable = this.bindings_;
                synchronized (hashtable) {
                    InternalBinding binding = (InternalBinding)this.bindings_.get(this.bindingHashString(n));
                    if (binding == null) {
                        throw new NotFound(NotFoundReason.missing_node, n);
                    }
                    this.bindings_.remove(this.bindingHashString(n));
                    if (this.store_ != null) {
                        this.store_.unbind(this.key_, n);
                    }
                    isContext = binding.isContext();
                }
            }
            this.bindingRemoved(n, isContext);
            return;
        }
        InternalBinding binding = (InternalBinding)this.bindings_.get(this.bindingHashString(n));
        if (binding == null) {
            throw new NotFound(NotFoundReason.missing_node, n);
        }
        NamingContext context = binding.context(n);
        NameComponent[] rest = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, rest, 0, rest.length);
        context.unbind(rest);
    }

    public NamingContext new_context() {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        OBNamingContext_impl nc = this.createNewContext();
        return nc._this();
    }

    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        OBNamingContext_impl newContext = this.createNewContext();
        OBNamingContext nc = newContext._this();
        try {
            this.bind_context(n, nc);
        }
        catch (SystemException ex) {
            if (ex.completed == CompletionStatus.COMPLETED_NO) {
                newContext.cleanup();
                throw ex;
            }
        }
        catch (NotFound ex) {
            newContext.cleanup();
            throw ex;
        }
        catch (CannotProceed ex) {
            newContext.cleanup();
            throw ex;
        }
        catch (InvalidName ex) {
            newContext.cleanup();
            throw ex;
        }
        catch (AlreadyBound ex) {
            newContext.cleanup();
            throw ex;
        }
        return nc;
    }

    public void destroy() throws NotEmpty {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (!this.bindings_.isEmpty()) {
            throw new NotEmpty();
        }
        this.destroyed_ = true;
        this.cleanup();
    }

    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        InternalBinding binding;
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        Enumeration keys = this.bindings_.elements();
        Vector<Binding> blvec = new Vector<Binding>();
        if (how_many > this.maxBindings_) {
            how_many = this.maxBindings_;
        }
        while (keys.hasMoreElements() && blvec.size() < how_many) {
            binding = (InternalBinding)keys.nextElement();
            if (binding == null) continue;
            blvec.addElement(binding.toBinding());
        }
        bl.value = new Binding[blvec.size()];
        blvec.copyInto(bl.value);
        blvec.removeAllElements();
        while (keys.hasMoreElements()) {
            binding = (InternalBinding)keys.nextElement();
            if (binding == null) continue;
            blvec.addElement(binding.toBinding());
        }
        if (blvec.size() > 0) {
            java.lang.Object[] rest = new Binding[blvec.size()];
            blvec.copyInto(rest);
            BindingIterator_impl iteratorImpl = new BindingIterator_impl(this.rootPOA_, (Binding[])rest);
            bi.value = iteratorImpl._this(this.orb_);
        } else {
            bi.value = null;
        }
    }

    public String to_string(NameComponent[] name) {
        String result = "";
        for (int i = 0; i < name.length; ++i) {
            if (i != 0) {
                result = result + '/';
            }
            result = result + this.addEscapes(name[i].id);
            if (name[i].kind.length() <= 0) continue;
            result = result + '.';
            result = result + this.addEscapes(name[i].kind);
        }
        return result;
    }

    public NameComponent[] to_name(String s) throws InvalidName {
        if (s.length() == 0) {
            throw new InvalidName();
        }
        CORBANameParser parser = new CORBANameParser(s);
        if (!parser.isValid()) {
            throw new InvalidName();
        }
        String[] contents = parser.getContents();
        NameComponent[] name = new NameComponent[contents.length / 2];
        int c = 0;
        int i = 0;
        while (i < contents.length) {
            name[c] = new NameComponent(contents[i], contents[i + 1]);
            i += 2;
            ++c;
        }
        return name;
    }

    public String to_url(String addr, String n) {
        String result = "corbaname:";
        result = result + addr;
        result = result + '#';
        result = result + OBNamingContext_impl.addURLEscapes(n);
        return result;
    }

    public Object resolve_str(String n) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(n));
    }

    public ExtendedBinding[] list_extended() {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        Enumeration keys = this.bindings_.elements();
        Vector<ExtendedBinding> ebvec = new Vector<ExtendedBinding>();
        while (keys.hasMoreElements()) {
            InternalBinding binding = (InternalBinding)keys.nextElement();
            if (binding == null) continue;
            ebvec.addElement(binding.toExtBinding());
        }
        java.lang.Object[] eb = new ExtendedBinding[ebvec.size()];
        ebvec.copyInto(eb);
        return eb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(NameComponent[] oldName, NameComponent[] newName) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        BindingUnion bndUnion;
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (oldName.length != 1 || newName.length != 1) {
            throw new InvalidName();
        }
        if (newName[0].id.length() == 0 && newName[0].kind.length() == 0) {
            throw new InvalidName();
        }
        if (oldName[0].id.equals(newName[0].id) && oldName[0].kind.equals(newName[0].kind)) {
            return;
        }
        java.lang.Object syncStore = this.store_ != null ? this.store_ : this.bindings_;
        java.lang.Object object = syncStore;
        synchronized (object) {
            Hashtable hashtable = this.bindings_;
            synchronized (hashtable) {
                InternalBinding binding = (InternalBinding)this.bindings_.get(this.bindingHashString(oldName));
                if (binding == null) {
                    throw new NotFound(NotFoundReason.missing_node, oldName);
                }
                if (this.bindings_.containsKey(this.bindingHashString(newName))) {
                    throw new AlreadyBound();
                }
                this.bindings_.remove(this.bindingHashString(oldName));
                binding.rename(newName[0]);
                this.bindings_.put(this.bindingHashString(newName), binding);
                bndUnion = binding.bindingUnion();
                if (this.store_ != null) {
                    this.store_.unbind(this.key_, oldName);
                    this.store_.bind(this.key_, newName, bndUnion, System.currentTimeMillis() / 1000L, false);
                }
            }
        }
        this.bindingChanged(bndUnion, oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add_listener(BindingListener listener) {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (!this.noUpdates_) {
            Vector vector = this.listeners_;
            synchronized (vector) {
                Object obj = listener._set_policy_override(this.timeoutPolicy_, SetOverrideType.ADD_OVERRIDE);
                listener = BindingListenerHelper.narrow(obj);
                Enumeration e = this.listeners_.elements();
                while (e.hasMoreElements()) {
                    BindingListener l = (BindingListener)e.nextElement();
                    if (!listener._is_equivalent(l)) continue;
                    return true;
                }
                if (this.traceLevel_ >= 2) {
                    this.logger_.trace("naming", "adding listener");
                }
                this.listeners_.addElement(listener);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove_listener(BindingListener listener) {
        if (this.destroyed_) {
            throw new OBJECT_NOT_EXIST();
        }
        if (!this.noUpdates_) {
            Vector vector = this.listeners_;
            synchronized (vector) {
                Object obj = listener._set_policy_override(this.timeoutPolicy_, SetOverrideType.ADD_OVERRIDE);
                listener = BindingListenerHelper.narrow(obj);
                Enumeration e = this.listeners_.elements();
                while (e.hasMoreElements()) {
                    BindingListener l = (BindingListener)e.nextElement();
                    if (!listener._is_equivalent(l)) continue;
                    if (this.traceLevel_ >= 2) {
                        this.logger_.trace("naming", "removing listener");
                    }
                    this.listeners_.removeElement(l);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean callbacks_active() {
        return !this.noUpdates_;
    }

    byte[] _OB_getKey() {
        return this.key_;
    }

    void _OB_bindWithTimestamp(NameComponent[] n, BindingUnion bndUnion, long timestamp) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        this.doBind(n, bndUnion, false, timestamp);
    }

    private static class InternalBinding {
        private BindingUnion bndUnion_;
        private NameComponent comp_;
        private long timestamp_;

        InternalBinding(NameComponent nc, BindingUnion bndUnion, long timestamp) {
            this.bndUnion_ = bndUnion;
            this.comp_ = nc;
            this.timestamp_ = timestamp;
        }

        synchronized Binding toBinding() {
            Binding b = new Binding();
            b.binding_name = new NameComponent[1];
            b.binding_name[0] = new NameComponent(this.comp_.id, this.comp_.kind);
            b.binding_type = this.bndUnion_.discriminator();
            return b;
        }

        synchronized ExtendedBinding toExtBinding() {
            ExtendedBinding b = new ExtendedBinding();
            b.binding_name = new NameComponent[1];
            b.binding_name[0] = new NameComponent(this.comp_.id, this.comp_.kind);
            b.bound_obj = this.bndUnion_;
            b.timestamp = (int)this.timestamp_;
            return b;
        }

        synchronized void rename(NameComponent nc) {
            this.comp_.id = nc.id;
            this.comp_.kind = nc.kind;
            this.timestamp_ = System.currentTimeMillis() / 1000L;
        }

        synchronized BindingUnion bindingUnion() {
            return this.bndUnion_;
        }

        synchronized void rebind(NameComponent[] n, BindingUnion bndUnion, long timestamp) throws NotFound {
            if (bndUnion.discriminator() != this.bndUnion_.discriminator()) {
                if (this.bndUnion_.discriminator() == BindingType.ncontext) {
                    throw new NotFound(NotFoundReason.not_object, n);
                }
                throw new NotFound(NotFoundReason.not_context, n);
            }
            this.comp_ = n[0];
            this.bndUnion_ = bndUnion;
            this.timestamp_ = timestamp;
        }

        synchronized boolean isContext() {
            return this.bndUnion_.discriminator() == BindingType.ncontext;
        }

        synchronized Object object() {
            if (this.bndUnion_.discriminator() == BindingType.ncontext) {
                return this.bndUnion_.nc();
            }
            return this.bndUnion_.obj();
        }

        synchronized NamingContext context(NameComponent[] n) throws NotFound {
            if (this.bndUnion_.discriminator() != BindingType.ncontext) {
                throw new NotFound(NotFoundReason.not_context, n);
            }
            return this.bndUnion_.nc();
        }
    }
}

