/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosNaming;

import com.ooc.CosNaming.Compactor;
import com.ooc.CosNaming.Database.Bind;
import com.ooc.CosNaming.Database.BindHelper;
import com.ooc.CosNaming.Database.Create;
import com.ooc.CosNaming.Database.CreateHelper;
import com.ooc.CosNaming.Database.Destroy;
import com.ooc.CosNaming.Database.DestroyHelper;
import com.ooc.CosNaming.Database.Info;
import com.ooc.CosNaming.Database.InfoHelper;
import com.ooc.CosNaming.Database.Unbind;
import com.ooc.CosNaming.Database.UnbindHelper;
import com.ooc.CosNaming.Database.Version;
import com.ooc.CosNaming.Database.VersionHelper;
import com.ooc.CosNaming.OBNamingContext;
import com.ooc.CosNaming.OBNamingContextPackage.BindingUnion;
import com.ooc.CosNaming.OBNamingContextPackage.ExtendedBinding;
import com.ooc.CosNaming.OBNamingContext_impl;
import com.ooc.OB.Assert;
import com.ooc.OB.HexConverter;
import com.ooc.OB.Logger;
import com.ooc.OB.ObjectIdHasher;
import com.ooc.OBCORBA.ORB_impl;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POAManagerHelper;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.IIOP.AcceptorInfo;
import com.ooc.OCI.IIOP.AcceptorInfoHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.PERSIST_STORE;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

final class NamingDatabase {
    private POA userPOA_;
    private POA systemPOA_;
    private ORB orb_;
    private String host_;
    private short port_;
    private String logFile_;
    private String logFileNew_;
    private String logFileBack_;
    private Hashtable ncs_;
    private FileOutputStream os_;
    private Compactor compactor_;
    Policy[] timeoutPolicy_;
    private boolean noUpdates_;
    private boolean initializing_;
    private boolean update_;
    private boolean noflush_;
    private boolean usingIMR_;
    private Codec cdrCodec_;
    private Logger logger_;
    private int maxBindings_;
    private int traceLevel_;

    private void dumpContext(byte[] key, NamingContext nc) throws UserException {
        ExtendedBinding[] b = ((OBNamingContext)nc).list_extended();
        for (int i = 0; i < b.length; ++i) {
            this.bind(key, b[i].binding_name, b[i].bound_obj, b[i].timestamp, false);
        }
    }

    private void writeAny(Any any) {
        byte[] data = null;
        try {
            data = this.cdrCodec_.encode(any);
        }
        catch (InvalidTypeForEncoding ex) {
            throw new RuntimeException();
        }
        Assert._OB_assert((this.os_ != null ? 1 : 0) != 0);
        try {
            byte[] ascii = HexConverter.octetsToAsciiBytes((byte[])data, (int)data.length);
            this.os_.write(ascii);
            this.os_.write(10);
            if (!this.noflush_) {
                this.os_.flush();
            }
        }
        catch (IOException ex) {
            this.logger_.error("Write failed!");
            throw new PERSIST_STORE();
        }
    }

    private boolean doRename(String from, String to) {
        boolean result = new File(from).renameTo(new File(to));
        if (!result) {
            this.logger_.error("Rename " + from + " to " + to + " failed.");
            return false;
        }
        return true;
    }

    private boolean exists(String file) {
        return new File(file).exists();
    }

    private void openLog() {
        try {
            this.os_ = new FileOutputStream(this.logFile_, true);
        }
        catch (IOException ex) {
            this.logger_.error("Cannot open `" + this.logFile_ + "': " + ex.toString());
            throw new PERSIST_STORE();
        }
    }

    private Servant key_to_servant(byte[] key) {
        int idx;
        byte[] rootKey = "NameService".getBytes();
        if (key.length == rootKey.length) {
            for (idx = 0; idx < key.length && key[idx] == rootKey[idx]; ++idx) {
            }
        }
        boolean isRoot = idx == key.length;
        try {
            if (isRoot) {
                return this.userPOA_.id_to_servant(key);
            }
            return this.systemPOA_.id_to_servant(key);
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        catch (ObjectNotActive ex) {
            throw new RuntimeException();
        }
    }

    NamingDatabase(POA userPOA, POA systemPOA, ORB orb, String log, Hashtable ncs, Policy[] timeoutPolicy, boolean noUpdates, boolean start, int timeout, int maxBindings, int traceLevel) {
        this.userPOA_ = userPOA;
        this.systemPOA_ = systemPOA;
        this.orb_ = orb;
        this.ncs_ = ncs;
        this.timeoutPolicy_ = timeoutPolicy;
        this.noUpdates_ = noUpdates;
        this.initializing_ = false;
        this.update_ = false;
        this.noflush_ = false;
        this.maxBindings_ = maxBindings;
        this.traceLevel_ = traceLevel;
        ORB_impl oborb = (ORB_impl)orb;
        this.logger_ = oborb.logger();
        Properties properties = oborb.properties();
        String value = properties.getProperty("ooc.orb.server_name");
        this.usingIMR_ = value != null;
        CodecFactory factory = null;
        try {
            factory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
            throw new RuntimeException();
        }
        Encoding how = new Encoding(0, 1, 2);
        try {
            this.cdrCodec_ = factory.create_codec(how);
        }
        catch (UnknownEncoding ex) {
            throw new RuntimeException();
        }
        org.omg.PortableServer.POAManager manager = this.userPOA_.the_POAManager();
        POAManager obManager = POAManagerHelper.narrow((Object)manager);
        Acceptor[] acceptors = null;
        try {
            acceptors = obManager.get_acceptors();
        }
        catch (AdapterInactive ex) {
            throw new RuntimeException();
        }
        for (int i = 0; i < acceptors.length; ++i) {
            com.ooc.OCI.AcceptorInfo accInfo = acceptors[i].get_info();
            AcceptorInfo iiopInfo = AcceptorInfoHelper.narrow((Object)accInfo);
            if (iiopInfo == null) continue;
            String[] hosts = iiopInfo.hosts();
            this.host_ = hosts[0];
            this.port_ = iiopInfo.port();
            break;
        }
        this.compactor_ = new Compactor(this.orb_, this, timeout, this.traceLevel_);
        this.logFile_ = log;
        this.logFileNew_ = log + ".new";
        this.logFileBack_ = log + ".bak";
        if (start) {
            if (this.exists(this.logFile_)) {
                this.logger_.error("Cannot specify --start option. There is an existing log file: `" + this.logFile_ + "'.");
                throw new PERSIST_STORE();
            }
            this.openLog();
            this.compactor_.start();
            return;
        }
        if (!this.exists(this.logFile_) && this.exists(this.logFileBack_)) {
            this.logger_.warning("NamingDatabase file is not present: " + this.logFile_ + ". Using backup file: " + this.logFileBack_);
            if (!this.doRename(this.logFileBack_, this.logFile_)) {
                this.logger_.warning("Rename of backup file failed.");
                throw new PERSIST_STORE();
            }
        }
        if (!this.exists(this.logFile_)) {
            this.logger_.error("NamingDatabase file is not present: `" + this.logFile_ + "'. Run with --start option if " + "running for the first time.");
            throw new PERSIST_STORE();
        }
        FileInputStream is = null;
        BufferedReader reader = null;
        try {
            is = new FileInputStream(this.logFile_);
            reader = new BufferedReader(new InputStreamReader(is));
        }
        catch (IOException ex) {
            this.logger_.error("Cannot open store file: " + this.logFile_);
            throw new PERSIST_STORE();
        }
        this.initializing_ = true;
        int rec = 0;
        try {
            try {
                try {
                    String cmd;
                    while ((cmd = reader.readLine()) != null) {
                        byte[] data = HexConverter.asciiToOctets((String)cmd);
                        Any any = null;
                        try {
                            any = this.cdrCodec_.decode(data);
                        }
                        catch (FormatMismatch ex) {
                            throw new RuntimeException();
                        }
                        TypeCode tc = any.type();
                        if (!tc.equal(VersionHelper.type())) {
                            OBNamingContext_impl nc;
                            Servant servant;
                            if (tc.equal(CreateHelper.type())) {
                                Create create = CreateHelper.extract(any);
                                new OBNamingContext_impl(this.userPOA_, this.systemPOA_, this.orb_, this, this.ncs_, create.key, this.timeoutPolicy_, this.noUpdates_, this.maxBindings_, this.traceLevel_);
                            } else if (tc.equal(BindHelper.type())) {
                                BindingUnion boundObj;
                                Bind bind = BindHelper.extract(any);
                                servant = this.key_to_servant(bind.key);
                                nc = (OBNamingContext_impl)servant;
                                if (bind.type.discriminator() == BindingType.ncontext) {
                                    if (bind.rebind) {
                                        nc.rebind_context(bind.name, bind.type.nc());
                                    } else {
                                        boundObj = new BindingUnion();
                                        boundObj.nc(bind.type.nc());
                                        nc._OB_bindWithTimestamp(bind.name, boundObj, bind.timestamp);
                                    }
                                } else if (bind.rebind) {
                                    nc.rebind(bind.name, bind.type.obj());
                                } else {
                                    boundObj = new BindingUnion();
                                    boundObj.obj(bind.type.obj());
                                    nc._OB_bindWithTimestamp(bind.name, boundObj, bind.timestamp);
                                }
                            } else if (tc.equal(DestroyHelper.type())) {
                                Destroy destroy = DestroyHelper.extract(any);
                                servant = this.key_to_servant(destroy.key);
                                nc = (OBNamingContext_impl)servant;
                                nc.destroy();
                            } else if (tc.equal(UnbindHelper.type())) {
                                Unbind unbind = UnbindHelper.extract(any);
                                servant = this.key_to_servant(unbind.key);
                                nc = (OBNamingContext_impl)servant;
                                nc.unbind(unbind.name);
                            } else if (tc.equal(InfoHelper.type())) {
                                Info inf = InfoHelper.extract(any);
                                if (inf.imr && !this.usingIMR_) {
                                    this.logger_.error("Current database must be used with the Implementation Repository");
                                    throw new PERSIST_STORE();
                                }
                                if (!inf.imr) {
                                    if (this.usingIMR_) {
                                        this.logger_.error("Current database cannot be used with the Implementation Repository");
                                        throw new PERSIST_STORE();
                                    }
                                    if (!this.host_.equals(inf.host) || this.port_ != inf.port) {
                                        this.logger_.error("Wrong host or port: " + this.host_ + ":" + this.port_ + ". Expected host and port " + inf.host + ":" + inf.port);
                                        throw new PERSIST_STORE();
                                    }
                                }
                            } else {
                                this.logger_.error("Unknown any in database.");
                                throw new PERSIST_STORE();
                            }
                        }
                        ++rec;
                    }
                }
                catch (NotFound ex) {
                    String msg = "Restore failed: NotFound: ";
                    msg = msg + "Reason: ";
                    msg = ex.why == NotFoundReason.missing_node ? msg + "missing_node" : (ex.why == NotFoundReason.not_context ? msg + "not_context" : msg + "not_object");
                    msg = msg + ". Rest of name: ";
                    for (int i = 0; i < ex.rest_of_name.length; ++i) {
                        msg = msg + "(" + ex.rest_of_name[i].id + "." + ex.rest_of_name[i].kind + ") ";
                    }
                    this.logger_.error(msg);
                    throw new PERSIST_STORE();
                }
                catch (CannotProceed ex) {
                    String msg = "Restore failed: CannotProceed";
                    msg = msg + ". Rest of name: ";
                    for (int i = 0; i < ex.rest_of_name.length; ++i) {
                        msg = msg + "(" + ex.rest_of_name[i].id + "." + ex.rest_of_name[i].kind + ") ";
                    }
                    this.logger_.error(msg);
                    throw new PERSIST_STORE();
                }
                catch (InvalidName ex) {
                    this.logger_.error("Restore failed: InvalidName");
                    throw new PERSIST_STORE();
                }
                catch (AlreadyBound ex) {
                    this.logger_.error("Restore failed: AlreadyBound");
                    throw new PERSIST_STORE();
                }
                catch (NotEmpty ex) {
                    this.logger_.error("Restore failed: NotEmpty");
                    throw new PERSIST_STORE();
                }
            }
            catch (PERSIST_STORE ex) {
                this.logger_.error("Error processing record: " + rec);
                is.close();
                throw ex;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            is.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.initializing_ = false;
        this.openLog();
        this.update_ = true;
        this.compactor_.start();
    }

    protected void finalize() throws Throwable {
        this.compactor_.halt();
        try {
            this.os_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateJournal() {
        if (!this.update_) {
            return;
        }
        try {
            this.os_.close();
            this.os_ = new FileOutputStream(this.logFileNew_);
        }
        catch (IOException ex) {
            this.logger_.error("Cannot open `" + this.logFileNew_ + "': " + ex.toString());
            throw new PERSIST_STORE();
        }
        this.noflush_ = true;
        this.info();
        try {
            try {
                Hashtable ex = this.ncs_;
                synchronized (ex) {
                    Enumeration keys = this.ncs_.keys();
                    while (keys.hasMoreElements()) {
                        ObjectIdHasher key = (ObjectIdHasher)keys.nextElement();
                        this.create(key.getObjectId(), 0L);
                    }
                    keys = this.ncs_.keys();
                    Enumeration values = this.ncs_.elements();
                    while (keys.hasMoreElements()) {
                        ObjectIdHasher key = (ObjectIdHasher)keys.nextElement();
                        NamingContext nc = (NamingContext)values.nextElement();
                        try {
                            this.dumpContext(key.getObjectId(), nc);
                        }
                        catch (UserException ex2) {
                        }
                        catch (OBJECT_NOT_EXIST ex3) {}
                    }
                }
            }
            catch (SystemException ex) {
                this.logger_.error("Compact failed: SystemException");
                ex.printStackTrace();
                throw new PERSIST_STORE();
            }
        }
        catch (PERSIST_STORE ex) {
            this.noflush_ = false;
            try {
                this.os_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.openLog();
            throw ex;
        }
        try {
            this.os_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.noflush_ = false;
        this.doRename(this.logFile_, this.logFileBack_);
        if (!this.doRename(this.logFileNew_, this.logFile_)) {
            throw new PERSIST_STORE();
        }
        new File(this.logFileBack_).delete();
        this.openLog();
        this.update_ = false;
    }

    public synchronized void create(byte[] oid, long timestamp) {
        if (this.initializing_) {
            return;
        }
        Create create = new Create(oid, (int)timestamp);
        Any any = this.orb_.create_any();
        CreateHelper.insert(any, create);
        this.writeAny(any);
        this.update_ = true;
    }

    public synchronized void destroy(byte[] oid) {
        if (this.initializing_) {
            return;
        }
        Destroy destroy = new Destroy(oid);
        Any any = this.orb_.create_any();
        DestroyHelper.insert(any, destroy);
        this.writeAny(any);
        this.update_ = true;
    }

    public synchronized void bind(byte[] oid, NameComponent[] name, BindingUnion boundObj, long timestamp, boolean rebind) {
        if (this.initializing_) {
            return;
        }
        Bind bind = new Bind(rebind, oid, name, boundObj, (int)timestamp);
        Any any = this.orb_.create_any();
        BindHelper.insert(any, bind);
        this.writeAny(any);
        this.update_ = true;
    }

    public synchronized void unbind(byte[] oid, NameComponent[] name) {
        if (this.initializing_) {
            return;
        }
        Unbind unbind = new Unbind(oid, name);
        Any any = this.orb_.create_any();
        UnbindHelper.insert(any, unbind);
        this.writeAny(any);
        this.update_ = true;
    }

    public synchronized void info() {
        if (this.initializing_) {
            return;
        }
        Any any = this.orb_.create_any();
        Version version = new Version("4.1.3");
        VersionHelper.insert(any, version);
        this.writeAny(any);
        Info inf = new Info(this.host_, this.port_, this.usingIMR_);
        InfoHelper.insert(any, inf);
        this.writeAny(any);
        this.update_ = true;
    }
}

