/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosNaming;

import com.ooc.CORBA.ORB;
import com.ooc.OB.Assert;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

final class NSAdmin {
    static final String progName = "com.ooc.CosNaming.NSAdmin";

    NSAdmin() {
    }

    private static void usage() {
        System.err.println("Usage:\ncom.ooc.CosNaming.NSAdmin options\n\nOptions:\n-h, --help                     Display this information.\n-b, --bind NAME IOR            Create a new object binding.\n-C, --bind_context NAME IOR    Create a new context binding.\n-c, --bind_new_context NAME    Create a new context and bind it.\n-d, --destroy NAME             Destroy an empty context.\n-l, --list [NAME]              Display the bindings in a context,\n                               or root context if no name given.\n-B, --rebind NAME IOR          Modify an object binding.\n-R, --rebind_context NAME IOR  Modify a context binding.\n-r, --resolve NAME             Display the IOR of a binding.\n-u, --unbind NAME              Remove a binding.\n");
    }

    private static void printException(UserException uex, NamingContextExt root, String name) {
        try {
            NotFound notFound = (NotFound)uex;
            NameComponent[] n = new NameComponent[]{notFound.rest_of_name[0]};
            String str = null;
            try {
                str = root.to_string(n);
            }
            catch (InvalidName ex) {
                throw new RuntimeException();
            }
            if (notFound.why == NotFoundReason.missing_node) {
                System.err.println("`" + str + "' was not found");
            } else if (notFound.why == NotFoundReason.not_context) {
                System.err.println("`" + str + "' is not a context");
            } else if (notFound.why == NotFoundReason.not_object) {
                System.err.println("`" + str + "' is not an object");
            }
            System.exit(1);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        try {
            CannotProceed cannotProceed = (CannotProceed)uex;
            String rest = null;
            try {
                rest = root.to_string(cannotProceed.rest_of_name);
            }
            catch (InvalidName ex) {
                throw new RuntimeException();
            }
            System.err.println("Cannot proceed, rest of name = `" + rest + "'");
            System.exit(1);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        try {
            InvalidName invalidName = (InvalidName)uex;
            Assert._OB_assert((name != null ? 1 : 0) != 0);
            System.err.println("`" + name + "' is an invalid name");
            System.exit(1);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        try {
            AlreadyBound alreadyBound = (AlreadyBound)uex;
            Assert._OB_assert((name != null ? 1 : 0) != 0);
            System.err.println("`" + name + "' already exists");
            System.exit(1);
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        try {
            NotEmpty notEmpty = (NotEmpty)uex;
            Assert._OB_assert((name != null ? 1 : 0) != 0);
            System.err.println("`" + name + "' is not empty");
            System.exit(1);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static Object stringToObject(org.omg.CORBA.ORB orb, String str) {
        Object obj = null;
        try {
            obj = orb.string_to_object(str);
        }
        catch (BAD_PARAM ex) {
            System.err.println("Invalid object reference");
            System.exit(1);
        }
        return obj;
    }

    private static NamingContext stringToNC(org.omg.CORBA.ORB orb, String str) {
        Object obj = NSAdmin.stringToObject(orb, str);
        NamingContext nc = null;
        try {
            nc = NamingContextHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            System.err.println("IOR does not denote a CosNaming::NamingContext");
            System.exit(1);
        }
        catch (SystemException ex) {
            System.err.println("A system exception occurred while narrowing the given object reference\nto CosNaming::NamingContext:");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        return nc;
    }

    private static void bind(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 3) {
            NSAdmin.usage();
            System.exit(1);
        }
        String name = args[1];
        String ior = args[2];
        try {
            NameComponent[] n = root.to_name(name);
            Object obj = NSAdmin.stringToObject(orb, ior);
            root.bind(n, obj);
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    private static void bindContext(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 3) {
            NSAdmin.usage();
            return;
        }
        String name = args[1];
        String ior = args[2];
        try {
            NameComponent[] n = root.to_name(name);
            NamingContext nc = NSAdmin.stringToNC(orb, ior);
            root.bind_context(n, nc);
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    private static void bindNewContext(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 2) {
            NSAdmin.usage();
            return;
        }
        String name = args[1];
        try {
            NameComponent[] n = root.to_name(name);
            NamingContext nc = root.bind_new_context(n);
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    private static void destroy(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 2) {
            NSAdmin.usage();
            return;
        }
        String name = args[1];
        try {
            Object obj = root.resolve_str(name);
            NamingContext nc = NamingContextHelper.narrow(obj);
            nc.destroy();
        }
        catch (BAD_PARAM ex) {
            System.err.println("`" + name + "' is not a context");
            System.exit(1);
        }
        catch (OBJECT_NOT_EXIST ex) {
            System.err.println("Object reference for `" + name + "' does not exist");
            System.exit(1);
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    private static void list(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length > 2) {
            NSAdmin.usage();
            return;
        }
        NamingContext nc = null;
        if (args.length == 2) {
            String name = args[1];
            try {
                Object obj = root.resolve_str(name);
                try {
                    nc = NamingContextHelper.narrow(obj);
                }
                catch (BAD_PARAM ex) {
                    System.err.println("`" + name + "' is not a context");
                    System.exit(1);
                }
                catch (OBJECT_NOT_EXIST ex) {
                    System.err.println("Object reference for `" + name + "' does not exist");
                    System.exit(1);
                }
            }
            catch (UserException ex) {
                NSAdmin.printException(ex, root, name);
            }
        } else {
            nc = root;
        }
        BindingListHolder blH = new BindingListHolder();
        BindingIteratorHolder biH = new BindingIteratorHolder();
        nc.list(100, blH, biH);
        Binding[] bl = blH.value;
        BindingIterator bi = biH.value;
        if (bi != null) {
            boolean b;
            do {
                BindingListHolder lH = new BindingListHolder();
                b = bi.next_n(100, lH);
                Binding[] l = lH.value;
                Binding[] blNew = new Binding[bl.length + l.length];
                System.arraycopy(bl, 0, blNew, 0, bl.length);
                System.arraycopy(l, 0, blNew, bl.length, l.length);
                bl = blNew;
            } while (b);
            bi.destroy();
        }
        if (bl.length == 0) {
            System.out.println("No bindings found");
        } else {
            System.out.println("Found " + bl.length + " binding" + (bl.length != 1 ? "s" : "") + ":");
            for (int i = 0; i < bl.length; ++i) {
                String name = null;
                try {
                    name = root.to_string(bl[i].binding_name);
                }
                catch (InvalidName ex) {
                    throw new RuntimeException();
                }
                System.out.println(name + " " + (bl[i].binding_type == BindingType.nobject ? "[object]" : "[context]"));
            }
        }
    }

    private static void rebind(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 3) {
            NSAdmin.usage();
            return;
        }
        String name = args[1];
        String ior = args[2];
        try {
            NameComponent[] n = root.to_name(name);
            Object obj = NSAdmin.stringToObject(orb, ior);
            root.rebind(n, obj);
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    private static void rebindContext(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 3) {
            NSAdmin.usage();
            return;
        }
        String name = args[1];
        String ior = args[2];
        try {
            NameComponent[] n = root.to_name(name);
            NamingContext nc = NSAdmin.stringToNC(orb, ior);
            root.rebind_context(n, nc);
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    private static void resolve(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 2) {
            NSAdmin.usage();
            return;
        }
        String name = args[1];
        try {
            Object obj = root.resolve_str(name);
            if (obj == null) {
                System.out.println("Binding has a nil object reference");
            } else {
                String ref = orb.object_to_string(obj);
                System.out.println(ref);
            }
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    private static void unbind(org.omg.CORBA.ORB orb, NamingContextExt root, String[] args) {
        if (args.length != 2) {
            NSAdmin.usage();
            return;
        }
        String name = args[1];
        try {
            NameComponent[] n = root.to_name(name);
            root.unbind(n);
        }
        catch (UserException ex) {
            NSAdmin.printException(ex, root, name);
        }
    }

    static int run(org.omg.CORBA.ORB orb, String[] args) {
        if (args.length == 0) {
            NSAdmin.usage();
            return 1;
        }
        boolean BIND = false;
        boolean BIND_CONTEXT = true;
        int BIND_NEW_CONTEXT = 2;
        int DESTROY = 3;
        int LIST = 4;
        int REBIND = 5;
        int REBIND_CONTEXT = 6;
        int RESOLVE = 7;
        int UNBIND = 8;
        int command = -1;
        if (args[0].equals("-b") || args[0].equals("--bind")) {
            command = 0;
        } else if (args[0].equals("-C") || args[0].equals("--bind_context")) {
            command = 1;
        } else if (args[0].equals("-c") || args[0].equals("--bind_new_context")) {
            command = 2;
        } else if (args[0].equals("-d") || args[0].equals("--destroy")) {
            command = 3;
        } else if (args[0].equals("-l") || args[0].equals("--list")) {
            command = 4;
        } else if (args[0].equals("-B") || args[0].equals("--rebind")) {
            command = 5;
        } else if (args[0].equals("-R") || args[0].equals("--rebind_context")) {
            command = 6;
        } else if (args[0].equals("-r") || args[0].equals("--resolve")) {
            command = 7;
        } else if (args[0].equals("-u") || args[0].equals("--unbind")) {
            command = 8;
        } else {
            NSAdmin.usage();
            return 1;
        }
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NameService");
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
            System.err.println("Unable to resolve `NameService' initial reference");
            return 1;
        }
        NamingContextExt root = null;
        try {
            root = NamingContextExtHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            System.err.println("`NameService' initial reference is not a CosNaming::NamingContextExt object.");
            return 1;
        }
        switch (command) {
            case 0: {
                NSAdmin.bind(orb, root, args);
                break;
            }
            case 1: {
                NSAdmin.bindContext(orb, root, args);
                break;
            }
            case 2: {
                NSAdmin.bindNewContext(orb, root, args);
                break;
            }
            case 3: {
                NSAdmin.destroy(orb, root, args);
                break;
            }
            case 4: {
                NSAdmin.list(orb, root, args);
                break;
            }
            case 5: {
                NSAdmin.rebind(orb, root, args);
                break;
            }
            case 6: {
                NSAdmin.rebindContext(orb, root, args);
                break;
            }
            case 7: {
                NSAdmin.resolve(orb, root, args);
                break;
            }
            case 8: {
                NSAdmin.unbind(orb, root, args);
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        int status = 0;
        org.omg.CORBA.ORB orb = null;
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        try {
            StringSeqHolder argsH = new StringSeqHolder(args);
            orb = ORB.init((StringSeqHolder)argsH, (Properties)props, null);
            status = NSAdmin.run(orb, argsH.value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

