/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.PortableInterceptor;

import com.ooc.IMR.ActiveState;
import com.ooc.IMR.POAStatus;
import com.ooc.IMR.ServerStatus;
import com.ooc.IMR._NoSuchPOA;
import com.ooc.OB.Logger;
import com.ooc.OBPortableInterceptor.PersistentORT_impl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor_3_0;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyHelper;
import org.omg.PortableServer.LifespanPolicyValue;

public final class IMRIORInterceptor_impl
extends LocalObject
implements IORInterceptor_3_0 {
    private Hashtable poas_;
    private Logger logger_;
    private ActiveState as_;
    private String serverInstance_;
    private boolean running_;

    private POAStatus convertState(short state) {
        POAStatus status = POAStatus.NON_EXISTENT;
        switch (state) {
            case 3: {
                status = POAStatus.INACTIVE;
                break;
            }
            case 1: {
                status = POAStatus.ACTIVE;
                break;
            }
            case 0: {
                status = POAStatus.HOLDING;
                break;
            }
            case 2: {
                status = POAStatus.DISCARDING;
            }
        }
        return status;
    }

    public IMRIORInterceptor_impl(Logger logger, ActiveState as, String serverInstance) {
        this.logger_ = logger;
        this.as_ = as;
        this.serverInstance_ = serverInstance;
        this.running_ = false;
        this.poas_ = new Hashtable();
    }

    public String name() {
        return new String("IMRInterceptor");
    }

    public void destroy() {
    }

    public void establish_components(IORInfo info) {
    }

    public void components_established(IORInfo info) {
        try {
            Policy p = info.get_effective_policy(17);
            LifespanPolicy policy = LifespanPolicyHelper.narrow(p);
            if (policy.value() != LifespanPolicyValue.PERSISTENT) {
                return;
            }
        }
        catch (INV_POLICY primary) {
            return;
        }
        ObjectReferenceTemplate primary = info.adapter_template();
        try {
            short state = info.state();
            POAStatus status = this.convertState(state);
            ObjectReferenceTemplate secondary = this.as_.poa_create(status, primary);
            info.current_factory(secondary);
        }
        catch (_NoSuchPOA e) {
            String msg = "IMR: POA not registered: ";
            for (int i = 0; i < e.poa.length; ++i) {
                msg = msg + e.poa[i];
                if (i == e.poa.length - 1) continue;
                msg = msg + "/";
            }
            this.logger_.error(msg);
            throw new INITIALIZE();
        }
        catch (SystemException ex) {
            String msg = "IMR: Cannot contact: " + ex.getMessage();
            this.logger_.error(msg);
            throw new INITIALIZE();
        }
        int id = info.manager_id();
        String[] name = primary.adapter_name();
        Vector<String[]> poas = (Vector<String[]>)this.poas_.get(new Integer(id));
        if (poas != null) {
            poas.addElement(name);
        } else {
            poas = new Vector<String[]>();
            poas.addElement(name);
            this.poas_.put(new Integer(id), poas);
        }
    }

    public void adapter_state_change(ObjectReferenceTemplate[] templates, short state) {
        if (state != 4) {
            return;
        }
        Vector<String[]> poanames = new Vector<String[]>();
        block4: for (int i = 0; i < templates.length; ++i) {
            try {
                PersistentORT_impl persistentORT = (PersistentORT_impl)templates[i];
            }
            catch (ClassCastException ex) {
                continue;
            }
            String[] adpaterName = templates[i].adapter_name();
            poanames.addElement(adpaterName);
            Enumeration e = this.poas_.elements();
            while (e.hasMoreElements()) {
                int j;
                Vector poas = (Vector)e.nextElement();
                for (j = 0; j < poas.size(); ++j) {
                    String[] current = (String[])poas.elementAt(j);
                    if (current.length != adpaterName.length) continue;
                    boolean found = true;
                    for (int k = 0; k < adpaterName.length; ++k) {
                        if (current[k].equals(adpaterName[k])) continue;
                        found = false;
                        break;
                    }
                    if (found) break;
                }
                if (j == poas.size()) continue;
                poas.removeElementAt(j);
                continue block4;
            }
        }
        if (poanames.size() != 0) {
            try {
                String[][] poaArray = new String[poanames.size()][];
                poanames.copyInto((Object[])poaArray);
                this.as_.poa_status_update(poaArray, POAStatus.NON_EXISTENT);
            }
            catch (SystemException ex) {
                String msg = "IMR: poa_destroy: " + ex.getMessage();
                this.logger_.warning(msg);
            }
        }
    }

    public void adapter_manager_state_change(int id, short state) {
        Vector poas;
        if (!this.running_) {
            try {
                this.as_.set_status(this.serverInstance_, ServerStatus.RUNNING);
            }
            catch (OBJECT_NOT_EXIST ex) {
                this.logger_.error("IMR: Not registered");
                throw new INITIALIZE();
            }
            catch (SystemException ex) {
                this.logger_.error("IMR: Cannot contact");
                throw new INITIALIZE();
            }
            this.running_ = true;
        }
        if ((poas = (Vector)this.poas_.get(new Integer(id))) != null && poas.size() != 0) {
            try {
                String[][] poaArray = new String[poas.size()][];
                poas.copyInto((Object[])poaArray);
                POAStatus status = this.convertState(state);
                this.as_.poa_status_update(poaArray, status);
            }
            catch (SystemException ex) {
                // empty catch block
            }
        }
    }
}

