/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.CORBA.Delegate;
import com.ooc.OB.Assert;
import com.ooc.OB.BootManager_impl;
import com.ooc.OB.CollocatedServer;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.LocationForward;
import com.ooc.OB.Logger;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ObjectKey;
import com.ooc.OB.ObjectKeyData;
import com.ooc.OB.PIManager;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OB.ServerManager;
import com.ooc.OBPortableServer.DirectServant;
import com.ooc.OBPortableServer.POALocator;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POANameHasher;
import com.ooc.OBPortableServer.POAOAInterface_impl;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OCI.Acceptor;
import com.ooc.PortableServer.Current_impl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManager_impl
extends LocalObject
implements POAManager {
    private ORBInstance orbInstance_;
    private Hashtable poas_;
    private State state_;
    private Acceptor[] acceptors_;
    private ServerManager serverManager_;
    private String name_;
    int id_;
    private OAInterface oaInterface_;
    private Version version_ = new Version();
    private BootManager_impl bootManagerImpl_;
    private POALocator poaLocator_;
    private String serverId_;

    private boolean isInORBUpcall() {
        boolean inInvocation = false;
        try {
            InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
            Object o = initialServiceManager.resolveInitialReferences("POACurrent");
            Current_impl current = (Current_impl)o;
            inInvocation = current._OB_inUpcall();
            if (inInvocation) {
                try {
                    POA_impl p = (POA_impl)current.get_POA();
                    inInvocation = p._OB_ORBInstance() == this.orbInstance_;
                }
                catch (NoContext ex) {}
            }
        }
        catch (InvalidName ex) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return inInvocation;
    }

    private void waitPendingRequests() {
        Enumeration keys = this.poas_.keys();
        while (keys.hasMoreElements()) {
            POA_impl poaImpl = (POA_impl)this.poas_.get(keys.nextElement());
            poaImpl._OB_waitPendingRequests();
        }
    }

    private void etherealizePOAs() {
        try {
            InitialServiceManager initialServiceManager = this.orbInstance_.getInitialServiceManager();
            Object o = initialServiceManager.resolveInitialReferences("RootPOA");
            POA_impl rootPOA = (POA_impl)o;
            rootPOA._OB_etherealize(this);
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
    }

    public synchronized void activate() throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ == State.ACTIVE) {
            return;
        }
        this.state_ = State.ACTIVE;
        this.notifyAll();
        this.serverManager_.activate();
        this.oaInterface_.activate();
        PIManager piManager = this.orbInstance_.getPIManager();
        piManager.adapterManagerStateChange(this.id_, this._OB_getAdapterState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold_requests(boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state_ == State.INACTIVE) {
                throw new AdapterInactive();
            }
            if (this.state_ == State.HOLDING) {
                return;
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.state_ = State.HOLDING;
            this.notifyAll();
            this.serverManager_.hold();
            this.oaInterface_.activate();
            PIManager piManager = this.orbInstance_.getPIManager();
            piManager.adapterManagerStateChange(this.id_, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard_requests(boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state_ == State.INACTIVE) {
                throw new AdapterInactive();
            }
            if (this.state_ == State.DISCARDING) {
                return;
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.state_ = State.DISCARDING;
            this.notifyAll();
            this.oaInterface_.discard();
            this.serverManager_.activate();
            PIManager piManager = this.orbInstance_.getPIManager();
            piManager.adapterManagerStateChange(this.id_, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean etherealize, boolean waitCompletion) throws AdapterInactive {
        POAManager_impl pOAManager_impl = this;
        synchronized (pOAManager_impl) {
            if (this.state_ == State.INACTIVE) {
                return;
            }
            if (waitCompletion && this.isInORBUpcall()) {
                throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
            }
            this.serverManager_.destroy();
            this.acceptors_ = null;
            this.state_ = State.INACTIVE;
            this.notifyAll();
            PIManager piManager = this.orbInstance_.getPIManager();
            piManager.adapterManagerStateChange(this.id_, this._OB_getAdapterState());
        }
        if (waitCompletion) {
            this.waitPendingRequests();
        }
        if (etherealize) {
            this.etherealizePOAs();
        }
    }

    public State get_state() {
        return this.state_;
    }

    public String name() {
        return this.name_;
    }

    public synchronized Acceptor[] get_acceptors() throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        Acceptor[] result = new Acceptor[this.acceptors_.length];
        System.arraycopy(this.acceptors_, 0, result, 0, this.acceptors_.length);
        return result;
    }

    POAManager_impl(ORBInstance orbInstance, POALocator poaLocator, String name, int id, Acceptor[] acceptors) {
        this.orbInstance_ = orbInstance;
        this.poas_ = new Hashtable(63);
        this.state_ = State.HOLDING;
        this.acceptors_ = acceptors;
        this.name_ = name;
        this.id_ = id;
        this.poaLocator_ = poaLocator;
        this.serverId_ = this.orbInstance_.getServerId();
        if (this.serverId_.length() == 0) {
            this.serverId_ = "_RootPOA";
        }
        this.oaInterface_ = new POAOAInterface_impl(this, this.orbInstance_);
        String rootKey = "ooc.orb.poamanager." + this.name_ + ".";
        int rootKeyLen = rootKey.length();
        Logger logger = this.orbInstance_.getLogger();
        Properties properties = orbInstance.getProperties();
        String[] props = new String[]{"conc_model", "endpoint", "version"};
        int numProps = props.length;
        Enumeration<java.lang.Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            int i;
            String prop;
            String key = (String)keys.nextElement();
            if (key.equals("ooc.orb.oa.thread_pool")) continue;
            if (key.startsWith(rootKey)) {
                prop = key.substring(rootKeyLen);
            } else {
                if (!key.startsWith("ooc.orb.oa.")) continue;
                prop = key.substring(11);
            }
            for (i = 0; i < numProps && !prop.equals(props[i]); ++i) {
            }
            if (i < numProps) continue;
            String err = key + ": unknown property";
            logger.warning(err);
        }
        this.version_.major = 1;
        this.version_.minor = (byte)2;
        int concModel = 2;
        for (int i = 0; i < numProps; ++i) {
            String err;
            String key = props[i];
            String fullkey = rootKey + key;
            String value = properties.getProperty(fullkey);
            if (value == null) {
                fullkey = "ooc.orb.oa." + key;
                value = properties.getProperty(fullkey);
            }
            if (value == null) continue;
            if (key.equals("conc_model")) {
                if (value.equals("threaded")) {
                    concModel = 2;
                    continue;
                }
                if (value.equals("thread_per_client")) {
                    concModel = 2;
                    continue;
                }
                if (value.equals("thread_per_request")) {
                    concModel = 2;
                    continue;
                }
                if (value.equals("thread_pool")) {
                    concModel = 2;
                    continue;
                }
                err = fullkey + ": unknown value";
                logger.warning(err);
                continue;
            }
            if (!key.equals("version")) continue;
            if (value.equals("1.0")) {
                this.version_.major = 1;
                this.version_.minor = 0;
                continue;
            }
            if (value.equals("1.1")) {
                this.version_.major = 1;
                this.version_.minor = 1;
                continue;
            }
            if (value.equals("1.2")) {
                this.version_.major = 1;
                this.version_.minor = (byte)2;
                continue;
            }
            err = fullkey + ": expected `1.0', `1.1' or `1.2'";
            logger.error(err);
            throw new INITIALIZE(err);
        }
        this.serverManager_ = new ServerManager(this.orbInstance_, this.acceptors_, this.oaInterface_, concModel);
        this.bootManagerImpl_ = (BootManager_impl)orbInstance.getBootManager();
    }

    synchronized void _OB_addPOA(POA poa, String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        Assert._OB_assert(!this.poas_.containsKey(idkey));
        this.poas_.put(idkey, poa);
        this.poaLocator_.add(poa, id);
    }

    synchronized void _OB_removePOA(String[] id) {
        POANameHasher idkey = new POANameHasher(id);
        Assert._OB_assert(this.poas_.containsKey(idkey));
        this.poas_.remove(idkey);
        this.poaLocator_.remove(id);
    }

    synchronized DirectServant _OB_getDirectServant(byte[] key, RefCountPolicyList policies) throws LocationForward, AdapterInactive {
        POA poa;
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        ObjectKeyData data = new ObjectKeyData();
        if (ObjectKey.ParseObjectKey(key, data) && (poa = this._OB_locatePOA(data)) != null) {
            POA_impl poaImpl = (POA_impl)poa;
            return poaImpl._OB_getDirectServant(data.oid, policies);
        }
        IOR ior = this.bootManagerImpl_._OB_locate(key);
        if (ior != null) {
            throw new LocationForward(ior, false);
        }
        throw new OBJECT_NOT_EXIST("No POA for local servant");
    }

    POA _OB_locatePOA(ObjectKeyData data) throws LocationForward {
        POA_impl poaImpl;
        org.omg.PortableServer.POAManager manager;
        Assert._OB_assert(this.get_state() != State.INACTIVE);
        POA poa = null;
        if (data.serverId.equals(this.serverId_) && (poa = (POA)this.poas_.get(new POANameHasher(data.poaId))) == null && (poa = this.poaLocator_.locate(data)) != null && (manager = poa.the_POAManager()) != this) {
            Object obj = poa.create_reference_with_id(data.oid, "");
            Delegate p = (Delegate)((ObjectImpl)obj)._get_delegate();
            IOR ior = p._OB_IOR();
            throw new LocationForward(ior, false);
        }
        if (poa != null && !(poaImpl = (POA_impl)poa)._OB_poaMatches(data, false)) {
            poa = null;
        }
        return poa;
    }

    public CollocatedServer _OB_getCollocatedServer() {
        return this.serverManager_.getCollocatedServer();
    }

    public synchronized void _OB_validateState() {
        while (this.state_ != State.ACTIVE) {
            if (this.state_ == State.INACTIVE || this.state_ == State.DISCARDING) {
                throw new TRANSIENT("POAManager is inactive or discarding requests", 0, CompletionStatus.COMPLETED_NO);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Version _OB_getGIOPVersion() {
        return new Version(this.version_.major, this.version_.minor);
    }

    public int _OB_getAdapterManagerId() {
        return this.id_;
    }

    public short _OB_getAdapterState() {
        switch (this.state_.value()) {
            case 3: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        Assert._OB_assert(false);
        return 4;
    }

    public Acceptor[] _OB_getAcceptors() {
        Acceptor[] result = new Acceptor[this.acceptors_.length];
        System.arraycopy(this.acceptors_, 0, result, 0, this.acceptors_.length);
        return result;
    }
}

