/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.IMR.ActiveState;
import com.ooc.IMR.Domain;
import com.ooc.IMR.DomainHelper;
import com.ooc.IMR.NoSuchOAD;
import com.ooc.IMR.NoSuchServer;
import com.ooc.IMR.OADNotRunning;
import com.ooc.IMR.ServerStatus;
import com.ooc.OAD.AlreadyLinked;
import com.ooc.OAD.ProcessEndpoint;
import com.ooc.OAD.ProcessEndpointManagerHolder;
import com.ooc.OAD.ProcessEndpoint_impl;
import com.ooc.OB.Assert;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.LocationForward;
import com.ooc.OB.Logger;
import com.ooc.OB.ORBControl;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.PIManager;
import com.ooc.OB.ParseParams;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OBPortableServer.DirectServant;
import com.ooc.OBPortableServer.POALocator;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POAManagerFactory;
import com.ooc.OBPortableServer.POAManagerFactoryPackage.AcceptorConfig;
import com.ooc.OBPortableServer.POAManagerFactoryPackage.POAManagerAlreadyExists;
import com.ooc.OBPortableServer.POAManager_impl;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OCI.AccFactory;
import com.ooc.OCI.AccFactoryRegistry;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.InvalidParam;
import com.ooc.OCI.NoSuchFactory;
import com.ooc.OCI.ProfileInfo;
import com.ooc.PortableInterceptor.IMRIORInterceptor_impl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManagerFactory_impl
extends LocalObject
implements POAManagerFactory {
    private ORBInstance orbInstance_;
    private Hashtable managers_ = new Hashtable(7);
    private int count_ = 0;
    private ActiveState activeState_;
    private POALocator poaLocator_ = new POALocator();
    private ProcessEndpoint_impl processEndpoint_;
    private Object endpointManager_;

    private String getUniqueName() {
        long now = System.currentTimeMillis();
        String name = "POAManager-" + now;
        Assert._OB_assert(!this.managers_.containsKey(name = name + this.count_++));
        return name;
    }

    private void validateName(String name) throws POAManagerAlreadyExists {
        POAManager manager = (POAManager)this.managers_.get(name);
        if (manager != null) {
            if (manager.get_state() == State.INACTIVE) {
                this.managers_.remove(name);
            } else {
                throw new POAManagerAlreadyExists();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POAManager create_poa_manager(String name) throws POAManagerAlreadyExists, InvalidParam {
        Hashtable hashtable = this.managers_;
        synchronized (hashtable) {
            String propName;
            if (name.length() == 0) {
                name = this.getUniqueName();
            } else {
                this.validateName(name);
                ++this.count_;
            }
            Properties props = this.orbInstance_.getProperties();
            Logger logger = this.orbInstance_.getLogger();
            String rootStr = null;
            String paramStr = null;
            if (name.equals("RootPOAManager")) {
                rootStr = props.getProperty("ooc.orb.oa.endpoint");
            }
            if ((paramStr = props.getProperty(propName = "ooc.orb.poamanager." + name + ".endpoint")) == null && rootStr == null) {
                paramStr = "iiop";
            } else if (paramStr == null) {
                paramStr = rootStr;
            }
            AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
            AccFactory[] factories = registry.get_factories();
            Vector<Acceptor> acceptors = new Vector<Acceptor>();
            int pos = 0;
            while (pos != -1) {
                int i;
                Vector params = new Vector();
                pos = ParseParams.parse(paramStr, pos, params);
                if (params.isEmpty()) continue;
                String prot = (String)params.firstElement();
                params.removeElementAt(0);
                for (i = 0; i < factories.length; ++i) {
                    if (!prot.equals(factories[i].id())) continue;
                    try {
                        java.lang.Object[] paramSeq = new String[params.size()];
                        params.copyInto(paramSeq);
                        Acceptor acceptor = factories[i].create_acceptor((String[])paramSeq);
                        acceptors.addElement(acceptor);
                        break;
                    }
                    catch (InvalidParam ex) {
                        String err = "unable to create acceptor: " + ex.reason;
                        logger.error(err);
                        throw new INITIALIZE(err);
                    }
                }
                if (i < factories.length) continue;
                String err = "unknown endpoint protocol `" + prot + "'";
                logger.error(err);
                throw new INITIALIZE(err);
            }
            if (acceptors.size() == 0) {
                String err = "no endpoints defined";
                logger.error(err);
                throw new INITIALIZE(err);
            }
            java.lang.Object[] arr = new Acceptor[acceptors.size()];
            acceptors.copyInto(arr);
            POAManager_impl manager = new POAManager_impl(this.orbInstance_, this.poaLocator_, name, this.count_, (Acceptor[])arr);
            this.managers_.put(name, manager);
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POAManager create_poa_manager_with_config(String name, AcceptorConfig[] config) throws POAManagerAlreadyExists, NoSuchFactory, InvalidParam {
        Hashtable hashtable = this.managers_;
        synchronized (hashtable) {
            if (name.length() == 0) {
                name = this.getUniqueName();
            } else {
                this.validateName(name);
                ++this.count_;
            }
            AccFactoryRegistry registry = this.orbInstance_.getAccFactoryRegistry();
            Acceptor[] acceptors = new Acceptor[config.length];
            for (int i = 0; i < config.length; ++i) {
                AccFactory factory = registry.get_factory(config[i].id);
                acceptors[i] = factory.create_acceptor(config[i].params);
            }
            POAManager_impl manager = new POAManager_impl(this.orbInstance_, this.poaLocator_, name, this.count_, acceptors);
            this.managers_.put(name, manager);
            return manager;
        }
    }

    public POAManager[] get_poa_managers() {
        Enumeration e = this.managers_.keys();
        Vector<POAManager> result = new Vector<POAManager>();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            POAManager manager = (POAManager)this.managers_.get(name);
            if (manager == null) continue;
            result.addElement(manager);
        }
        java.lang.Object[] r = new POAManager[result.size()];
        result.copyInto(r);
        return r;
    }

    public void destroy() {
        this.orbInstance_ = null;
        if (!this.managers_.isEmpty()) {
            this._OB_deactivate();
        }
    }

    public void _OB_deactivate() {
        Enumeration e = this.managers_.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            POAManager manager = (POAManager)this.managers_.get(name);
            if (manager == null) continue;
            try {
                manager.deactivate(true, true);
            }
            catch (AdapterInactive ex) {}
        }
        this.managers_.clear();
        if (this.activeState_ != null) {
            Logger logger = this.orbInstance_.getLogger();
            String serverInstance = this.orbInstance_.getServerInstance();
            try {
                this.activeState_.set_status(serverInstance, ServerStatus.STOPPING);
            }
            catch (SystemException ex) {
                String msg = this.orbInstance_.getServerId() + ": Cannot contact IMR on shutdown";
                logger.warning(msg);
            }
            this.activeState_ = null;
        }
    }

    public DirectServant _OB_getDirectServant(IOR ior, RefCountPolicyList policies) throws LocationForward {
        if (this.managers_.isEmpty()) {
            return null;
        }
        Enumeration e = this.managers_.keys();
        while (e.hasMoreElements()) {
            try {
                String name = (String)e.nextElement();
                POAManager_impl manager = (POAManager_impl)this.managers_.get(name);
                if (manager == null) continue;
                Acceptor[] acceptors = manager.get_acceptors();
                for (int i = 0; i < acceptors.length; ++i) {
                    ProfileInfo[] profileInfos = acceptors[i].get_local_profiles(ior);
                    if (profileInfos.length <= 0) continue;
                    return manager._OB_getDirectServant(profileInfos[0].key, policies);
                }
            }
            catch (AdapterInactive ex) {
            }
        }
        return null;
    }

    public void _OB_setORBInstance(ORBInstance instance) {
        this.orbInstance_ = instance;
    }

    public void _OB_initializeIMR(POA_impl root, ORBControl orbControl) {
        String serverId = this.orbInstance_.getServerId();
        String serverInstance = this.orbInstance_.getServerInstance();
        Properties properties = this.orbInstance_.getProperties();
        String noIMR = properties.getProperty("ooc.orb.noIMR");
        if (serverId.length() == 0 || noIMR != null) {
            return;
        }
        this.processEndpoint_ = new ProcessEndpoint_impl(serverId, serverInstance, root, orbControl);
        Domain imrDomain = null;
        try {
            InitialServiceManager initServiceManager = this.orbInstance_.getInitialServiceManager();
            Object imrObj = initServiceManager.resolveInitialReferences("IMR");
            imrDomain = DomainHelper.narrow(imrObj);
        }
        catch (InvalidName ex) {
        }
        catch (BAD_PARAM ex) {
            // empty catch block
        }
        Logger logger = this.orbInstance_.getLogger();
        if (imrDomain == null) {
            String msg = serverId + ": IMRDomain not reachable";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        String exec = properties.getProperty("ooc.orb.imr.register");
        if (exec != null) {
            String msg = serverId + ": Self registration not implemented" + " for java servers";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        try {
            ProcessEndpointManagerHolder endpoint = new ProcessEndpointManagerHolder();
            ObjectReferenceTemplate primary = root.adapter_template();
            this.activeState_ = imrDomain.startup(serverId, serverInstance, primary, endpoint);
            ProcessEndpoint ref = this.processEndpoint_._this(this.orbInstance_.getORB());
            endpoint.value.establish_link(serverId, serverInstance, -1, ref);
            this.endpointManager_ = endpoint.value;
            IMRIORInterceptor_impl i = new IMRIORInterceptor_impl(logger, this.activeState_, serverInstance);
            PIManager piManager = this.orbInstance_.getPIManager();
            try {
                piManager.addIORInterceptor(i, true);
            }
            catch (DuplicateName ex) {
                Assert._OB_assert(false);
            }
        }
        catch (BAD_PARAM ex) {
            String msg = serverId + ": (IMR) Server already running";
            logger.error(msg);
            throw new INITIALIZE(msg);
        }
        catch (NoSuchServer ex) {
            String msg = serverId + ": (IMR) Not registered with IMR";
            logger.error(msg);
            throw new INITIALIZE();
        }
        catch (NoSuchOAD ex) {
            String msg = serverId + ": (IMR) No OAD for host";
            logger.error(msg);
            throw new INITIALIZE();
        }
        catch (OADNotRunning ex) {
            String msg = serverId + ": (IMR) OAD not running";
            logger.error(msg);
            throw new INITIALIZE();
        }
        catch (AlreadyLinked ex) {
            String msg = serverId + ": (IMR) Process registered with OAD";
            logger.error(msg);
            throw new INITIALIZE();
        }
    }
}

