/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.OB.Assert;
import com.ooc.OB.LocationForward;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ObjectIdHasher;
import com.ooc.OB.PIManager;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OBPortableServer.DefaultServantHolder;
import com.ooc.OBPortableServer.DirectSeqEntry;
import com.ooc.OBPortableServer.DirectServant;
import com.ooc.OBPortableServer.POAPolicies;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OBPortableServer.ServantLocationStrategy;
import com.ooc.OBPortableServer.ServantManagerStrategy;
import com.ooc.OBPortableServer.TableEntry;
import com.ooc.PortableServer.Current_impl;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManagerOperations;

class ActiveObjectOnlyStrategy
implements ServantLocationStrategy {
    protected Hashtable activeObjectTable_ = new Hashtable(1023);
    protected Hashtable servantIdTable_;
    private Hashtable directSeqTable_ = new Hashtable(1023);
    private ORBInstance orbInstance_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeActivation(ObjectIdHasher oid, Servant servant, TableEntry entry) {
        Hashtable hashtable = this.directSeqTable_;
        synchronized (hashtable) {
            DirectSeqEntry table = (DirectSeqEntry)this.directSeqTable_.get(oid);
            if (table != null) {
                table.deactivate();
                this.directSeqTable_.remove(oid);
            }
        }
        if (this.servantIdTable_ != null) {
            Assert._OB_assert(!this.servantIdTable_.containsKey(servant));
            this.servantIdTable_.put(servant, oid.getObjectId());
        }
        ((ORB)this.orbInstance_.getORB()).set_delegate(servant);
        entry.setServant(servant);
        entry.setActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeDeactivate(POA poa, ObjectIdHasher oid, TableEntry entry) {
        Object object = this.directSeqTable_;
        synchronized (object) {
            DirectSeqEntry table = (DirectSeqEntry)this.directSeqTable_.get(oid);
            if (table != null) {
                table.deactivate();
                this.directSeqTable_.remove(oid);
            }
        }
        if (this.servantIdTable_ != null) {
            Servant servant = entry.getServant();
            Assert._OB_assert(this.servantIdTable_.containsKey(servant));
            this.servantIdTable_.remove(servant);
        }
        object = entry;
        synchronized (object) {
            entry.setDeactivated();
            entry.clearServant();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectServant completeDirectStubImpl(POA poa, byte[] rawoid, Servant servant, RefCountPolicyList policies) {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        if (servant instanceof DynamicImplementation) {
            return null;
        }
        boolean haveNativeTypes = servant instanceof ServantManagerOperations;
        PIManager piManager = this.orbInstance_.getPIManager();
        if (!haveNativeTypes && (policies.locationTransparency == 0 || piManager.haveClientInterceptors() || piManager.haveServerInterceptors())) {
            return null;
        }
        DirectServant directServant = new DirectServant((POA_impl)poa, oid.getObjectId(), servant);
        Hashtable hashtable = this.directSeqTable_;
        synchronized (hashtable) {
            DirectSeqEntry table = (DirectSeqEntry)this.directSeqTable_.get(oid);
            if (table == null) {
                table = new DirectSeqEntry(oid.getObjectId());
                this.directSeqTable_.put(oid, table);
            }
            table.add(directServant);
        }
        return directServant;
    }

    ActiveObjectOnlyStrategy(POAPolicies policies, ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
        this.servantIdTable_ = policies.idUniquenessPolicy() == IdUniquenessPolicyValue.UNIQUE_ID ? new Hashtable(1023) : null;
    }

    public void destroy(POA poa, boolean etherealize) {
        this.activeObjectTable_.clear();
        this.directSeqTable_.clear();
        if (this.servantIdTable_ != null) {
            this.servantIdTable_.clear();
        }
    }

    public void etherealize(POA poa) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(byte[] rawoid, Servant servant) throws ServantAlreadyActive, WrongPolicy, ObjectAlreadyActive {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        block11: while (true) {
            TableEntry entry;
            boolean incarnate = false;
            Object object = this.activeObjectTable_;
            synchronized (object) {
                entry = (TableEntry)this.activeObjectTable_.get(oid);
                if (entry == null) {
                    if (this.servantIdTable_ != null && this.servantIdTable_.containsKey(servant)) {
                        throw new ServantAlreadyActive();
                    }
                    entry = new TableEntry();
                    this.activeObjectTable_.put(oid, entry);
                }
            }
            object = entry;
            synchronized (object) {
                switch (entry.state()) {
                    case 2: {
                        entry.waitForStateChange();
                        continue block11;
                    }
                    case 0: {
                        incarnate = true;
                        break;
                    }
                    case 1: {
                        throw new ObjectAlreadyActive();
                    }
                }
                if (incarnate) {
                    this.completeActivation(oid, servant, entry);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(POA poa, byte[] rawoid) throws ObjectNotActive, WrongPolicy {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        TableEntry entry = (TableEntry)this.activeObjectTable_.get(oid);
        if (entry == null) {
            throw new ObjectNotActive();
        }
        boolean deactivate = false;
        TableEntry tableEntry = entry;
        synchronized (tableEntry) {
            switch (entry.state()) {
                case 1: {
                    entry.setDeactivatePending();
                    deactivate = entry.getOutstandingRequests() == 0;
                    break;
                }
                case 2: {
                    return;
                }
                case 0: 
                case 3: {
                    throw new ObjectNotActive();
                }
            }
        }
        if (deactivate) {
            this.completeDeactivate(poa, oid, entry);
            this.activeObjectTable_.remove(oid);
        }
    }

    public byte[] servantToId(Servant servant, Current_impl poaCurrent) {
        byte[] id = null;
        if (this.servantIdTable_ != null) {
            id = (byte[])this.servantIdTable_.get(servant);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant idToServant(byte[] rawoid, boolean useDefaultServant) {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        TableEntry entry;
        block8: while ((entry = (TableEntry)this.activeObjectTable_.get(oid)) != null) {
            TableEntry tableEntry = entry;
            synchronized (tableEntry) {
                switch (entry.state()) {
                    case 0: 
                    case 2: {
                        entry.waitForStateChange();
                        continue block8;
                    }
                    case 1: {
                        return entry.getServant();
                    }
                    case 3: {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public Servant locate(byte[] rawoid, POA poa, String op, CookieHolder cookie) throws LocationForward {
        Servant servant = this.idToServant(rawoid, false);
        if (servant == null) {
            throw new OBJECT_NOT_EXIST(MinorCodes.describeObjectNotExist(1330446338), 1330446338, CompletionStatus.COMPLETED_NO);
        }
        return servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preinvoke(byte[] rawoid) {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        TableEntry entry = (TableEntry)this.activeObjectTable_.get(oid);
        if (entry == null) {
            return;
        }
        TableEntry tableEntry = entry;
        synchronized (tableEntry) {
            entry.incOutstandingRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postinvoke(byte[] rawoid, POA poa, String op, Object cookie, Servant servant) {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        TableEntry entry = (TableEntry)this.activeObjectTable_.get(oid);
        if (entry == null) {
            return;
        }
        boolean deactivate = false;
        TableEntry tableEntry = entry;
        synchronized (tableEntry) {
            if (entry.decOutstandingRequest() == 0) {
                deactivate = entry.state() == 2;
            }
        }
        if (deactivate) {
            this.completeDeactivate(poa, oid, entry);
            this.activeObjectTable_.remove(oid);
        }
    }

    public DirectServant createDirectStubImpl(POA poa, byte[] oid, RefCountPolicyList policies) throws LocationForward {
        try {
            CookieHolder cookie = null;
            Servant servant = this.locate(oid, poa, "", cookie);
            return this.completeDirectStubImpl(poa, oid, servant, policies);
        }
        catch (SystemException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectStubImpl(byte[] rawoid, DirectServant directStubImpl) {
        ObjectIdHasher oid = new ObjectIdHasher(rawoid);
        Hashtable hashtable = this.directSeqTable_;
        synchronized (hashtable) {
            DirectSeqEntry table = (DirectSeqEntry)this.directSeqTable_.get(oid);
            if (table != null && table.remove(directStubImpl)) {
                this.directSeqTable_.remove(oid);
            }
        }
    }

    public ServantManagerStrategy getServantManagerStrategy() {
        return null;
    }

    public DefaultServantHolder getDefaultServantHolder() {
        return null;
    }
}

