/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

public class ObjectIdHasher {
    private byte[] oid_;
    private int hashCode_;

    public ObjectIdHasher(byte[] oid) {
        this.oid_ = oid;
        this.hashCode_ = 0;
        int offset = 0;
        int len = oid.length;
        if (len < 16) {
            for (int i = len; i > 0; --i) {
                this.hashCode_ = this.hashCode_ * 37 + oid[offset++];
            }
        } else {
            int skip = len / 8;
            int i = len;
            while (i > 0) {
                this.hashCode_ = this.hashCode_ * 39 + oid[offset];
                i -= skip;
                offset += skip;
            }
        }
    }

    public byte[] getObjectId() {
        return this.oid_;
    }

    public int hashCode() {
        return this.hashCode_;
    }

    public boolean equals(Object o) {
        ObjectIdHasher h = (ObjectIdHasher)o;
        return ObjectIdHasher.comp(this.oid_, h.oid_);
    }

    public static boolean comp(byte[] id1, byte[] id2) {
        if (id1.length != id2.length) {
            return false;
        }
        for (int i = 0; i < id1.length; ++i) {
            if (id1[i] == id2[i]) continue;
            return false;
        }
        return true;
    }
}

