/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.GIOPServerWorker;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Upcall;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.SendReceiveMode;
import com.ooc.OCI.Transport;
import java.util.Properties;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.SystemException;
import org.omg.GIOP.MsgType_1_1;

final class GIOPServerWorkerThreaded
extends GIOPServerWorker {
    protected int connectionTimeout_;
    protected long timestamp_;
    protected Thread shutdownThread_;
    protected Thread receiverThread_;

    protected boolean setStateNoSync(int state) {
        if (!super.setStateNoSync(state)) {
            return false;
        }
        this.notify();
        return true;
    }

    protected void gracefulShutdown() {
        if (this.upcallCount_ > 0) {
            return;
        }
        try {
            ThreadGroup group = this.orbInstance_.getServerWorkerGroup();
            this.shutdownThread_ = new ShutdownThread(group, this);
            this.shutdownThread_.start();
        }
        catch (OutOfMemoryError ex) {
            this.exception(4, new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO));
        }
    }

    protected void abortiveShutdown() {
        if (this.transport_.mode() == SendReceiveMode.SendReceive) {
            try {
                Buffer buf = new Buffer(12);
                OutputStream out = new OutputStream(buf);
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.major = 1;
                profileInfo.minor = this.minor_;
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
                out._OB_pos(0);
                if (!this.transport_.send_detect(out._OB_buffer(), true)) {
                    this.setStateNoSync(4);
                    return;
                }
                Assert._OB_assert(out._OB_buffer().is_full());
            }
            catch (SystemException ex) {
                this.exception(4, ex);
                return;
            }
        }
        this.setStateNoSync(4);
    }

    protected void updateTimestamp() {
        if (this.connectionTimeout_ > 0) {
            this.timestamp_ = System.currentTimeMillis() / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upcallReturn(Buffer buf) {
        GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this;
        synchronized (gIOPServerWorkerThreaded) {
            buf.pos(0);
            try {
                if (!this.transport_.send_detect(buf, true)) {
                    this.setState(4);
                    return;
                }
                Assert._OB_assert(buf.is_full());
            }
            catch (SystemException ex) {
                this.exception(4, ex);
                return;
            }
            Assert._OB_assert(this.upcallCount_ > 0);
            --this.upcallCount_;
            if (this.upcallCount_ == 0 && this.state_ == 2) {
                this.gracefulShutdown();
            }
        }
    }

    GIOPServerWorkerThreaded(ORBInstance orbInstance, Transport transport, OAInterface oaInterface) {
        super(orbInstance, transport, oaInterface);
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.server_timeout");
        if (value != null) {
            this.connectionTimeout_ = Integer.parseInt(value);
            this.updateTimestamp();
        } else {
            this.connectionTimeout_ = 0;
            this.timestamp_ = 0L;
        }
        try {
            ThreadGroup group = this.orbInstance_.getServerWorkerGroup();
            this.receiverThread_ = new ReceiverThread(group, this);
            this.receiverThread_.start();
        }
        catch (OutOfMemoryError ex) {
            this.transport_.close();
            this.state_ = 4;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized boolean setState(int state) {
        return this.setStateNoSync(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiverRun() {
        while (true) {
            Upcall upcall;
            GIOPServerWorkerThreaded gIOPServerWorkerThreaded;
            Assert._OB_assert(this.buf_ == null);
            this.buf_ = new Buffer(12);
            try {
                while (!this.buf_.is_full()) {
                    if (this.connectionTimeout_ > 0) {
                        int oldPos = this.buf_.pos();
                        if (!this.transport_.receive_timeout_detect(this.buf_, this.connectionTimeout_ * 1000)) {
                            gIOPServerWorkerThreaded = this;
                            synchronized (gIOPServerWorkerThreaded) {
                                this.setStateNoSync(4);
                                return;
                            }
                        }
                        if (this.buf_.pos() != oldPos) continue;
                        gIOPServerWorkerThreaded = this;
                        synchronized (gIOPServerWorkerThreaded) {
                            long current;
                            if (this.upcallCount_ == 0 && (current = System.currentTimeMillis() / 1000L) >= this.timestamp_ + (long)this.connectionTimeout_) {
                                this.connectionTimeout_ = 0;
                                this.setStateNoSync(2);
                            }
                            continue;
                        }
                    }
                    if (!this.transport_.receive_detect(this.buf_, true)) {
                        GIOPServerWorkerThreaded oldPos = this;
                        synchronized (oldPos) {
                            this.setStateNoSync(4);
                            return;
                        }
                    }
                    Assert._OB_assert(this.buf_.is_full());
                }
            }
            catch (SystemException ex) {
                gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(4, ex);
                    return;
                }
            }
            try {
                this.incoming_.extractHeader(this.buf_);
                this.buf_.realloc(12 + this.incoming_.size());
            }
            catch (SystemException ex) {
                gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(3, ex);
                    return;
                }
            }
            try {
                while (!this.buf_.is_full()) {
                    if (this.connectionTimeout_ > 0) {
                        long oldPos = this.buf_.pos();
                        if (!this.transport_.receive_timeout_detect(this.buf_, this.connectionTimeout_ * 1000)) {
                            GIOPServerWorkerThreaded current = this;
                            synchronized (current) {
                                this.setStateNoSync(4);
                                return;
                            }
                        }
                        if ((long)this.buf_.pos() != oldPos) continue;
                        GIOPServerWorkerThreaded current = this;
                        synchronized (current) {
                            long current2;
                            if (this.upcallCount_ == 0 && (current2 = System.currentTimeMillis() / 1000L) >= this.timestamp_ + (long)this.connectionTimeout_) {
                                this.connectionTimeout_ = 0;
                                this.setStateNoSync(2);
                            }
                            continue;
                        }
                    }
                    if (!this.transport_.receive_detect(this.buf_, true)) {
                        GIOPServerWorkerThreaded oldPos = this;
                        synchronized (oldPos) {
                            this.setStateNoSync(4);
                            return;
                        }
                    }
                    Assert._OB_assert(this.buf_.is_full());
                }
            }
            catch (SystemException ex) {
                gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(4, ex);
                    return;
                }
            }
            gIOPServerWorkerThreaded = this;
            synchronized (gIOPServerWorkerThreaded) {
                while (this.state_ == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.state_ != 0 && this.state_ != 2) {
                    return;
                }
                this.updateTimestamp();
                upcall = this.execute();
                if (upcall == null) continue;
            }
            upcall.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRun() {
        this.closeConnection_ = true;
        if (this.transport_.mode() == SendReceiveMode.SendReceive) {
            try {
                Buffer buf = new Buffer(12);
                OutputStream out = new OutputStream(buf);
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.major = 1;
                profileInfo.minor = this.minor_;
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
                out._OB_pos(0);
                if (!this.transport_.send_detect(out._OB_buffer(), true)) {
                    GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this;
                    synchronized (gIOPServerWorkerThreaded) {
                        this.setStateNoSync(4);
                        return;
                    }
                }
                Assert._OB_assert(out._OB_buffer().is_full());
            }
            catch (SystemException ex) {
                GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(4, ex);
                    return;
                }
            }
        }
        GIOPServerWorkerThreaded ex = this;
        synchronized (ex) {
            if (this.state_ == 2) {
                this.logCloseConnection();
                this.transport_.shutdown();
            }
        }
        if (this.transport_.mode() == SendReceiveMode.SendReceive) {
            while (true) {
                try {
                    if (this.shutdownTimeout_ > 0) {
                        this.receiverThread_.join(this.shutdownTimeout_ * 1000);
                        break;
                    }
                    this.receiverThread_.join();
                }
                catch (InterruptedException ex2) {
                    continue;
                }
                break;
            }
        }
        GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this;
        synchronized (gIOPServerWorkerThreaded) {
            this.setStateNoSync(4);
        }
    }

    protected static final class ReceiverThread
    extends Thread {
        private GIOPServerWorkerThreaded worker_;

        ReceiverThread(ThreadGroup group, GIOPServerWorkerThreaded worker) {
            super(group, "ORBacus:Server:ReceiverThread");
            this.worker_ = worker;
        }

        public void run() {
            try {
                this.worker_.receiverRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert._OB_assert(false);
            }
            this.worker_ = null;
        }
    }

    protected static final class ShutdownThread
    extends Thread {
        private GIOPServerWorkerThreaded worker_;

        ShutdownThread(ThreadGroup group, GIOPServerWorkerThreaded worker) {
            super(group, "ORBacus:Server:ShutdownThread");
            this.worker_ = worker;
        }

        public void run() {
            try {
                this.worker_.shutdownRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert._OB_assert(false);
            }
            this.worker_ = null;
        }
    }
}

