/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.CodeSetDatabase;
import com.ooc.OB.CodeSetInfo;
import com.ooc.OB.CodeSetUtil;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.GIOPIncomingMessage;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.Logger;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Upcall;
import com.ooc.OB.UpcallReturn;
import com.ooc.OB.Util;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.SendReceiveMode;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.util.Properties;
import java.util.Vector;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHolder;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.TargetAddressHolder;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.IORHolder;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHolder;

abstract class GIOPServerWorker
implements UpcallReturn {
    protected ORBInstance orbInstance_;
    protected Transport transport_;
    protected OAInterface oaInterface_;
    protected Buffer buf_;
    protected GIOPIncomingMessage incoming_;
    protected CodeConverters codeConverters_;
    protected Vector unsent_ = new Vector();
    protected int upcallCount_;
    protected byte minor_;
    protected boolean closeLogged_;
    protected boolean closeConnection_;
    protected int shutdownTimeout_;
    public static final int StateActive = 0;
    public static final int StateHolding = 1;
    public static final int StateClosing = 2;
    public static final int StateError = 3;
    public static final int StateClosed = 4;
    protected int state_;
    private boolean destroyed_ = false;

    protected void logCloseConnection() {
        if (!this.closeLogged_) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                TransportInfo info = this.transport_.get_info();
                String msg = "closing connection\n";
                msg = msg + info.describe();
                if (this.minor_ >= 2 && !this.closeConnection_) {
                    msg = msg + "\nclient disconnected without sending a `CloseConnection' message";
                }
                this.orbInstance_.getLogger().trace("incoming", msg);
            }
            this.closeLogged_ = true;
        }
    }

    protected void getCodeConverters(ServiceContext[] scl) {
        if (this.codeConverters_ == null) {
            for (int i = 0; i < scl.length; ++i) {
                CodeSetInfo info;
                if (scl[i].context_id != 1) continue;
                CodeSetContextHolder codeSetContextH = new CodeSetContextHolder();
                CodeSetUtil.extractCodeSetContext(scl[i], codeSetContextH);
                CodeSetContext codeSetContext = codeSetContextH.value;
                CodeSetDatabase db = CodeSetDatabase.instance();
                this.codeConverters_ = new CodeConverters();
                this.codeConverters_.inputCharConverter = db.getConverter(this.orbInstance_.getNativeCs(), codeSetContext.char_data);
                this.codeConverters_.outputCharConverter = db.getConverter(codeSetContext.char_data, this.orbInstance_.getNativeCs());
                this.codeConverters_.inputWcharConverter = db.getConverter(this.orbInstance_.getNativeWcs(), codeSetContext.wchar_data);
                this.codeConverters_.outputWcharConverter = db.getConverter(codeSetContext.wchar_data, this.orbInstance_.getNativeWcs());
                CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
                if (coreTraceLevels.traceConnections() < 2) break;
                String msg = "receiving transmission code sets";
                msg = msg + "\nchar code set: ";
                if (this.codeConverters_.inputCharConverter != null) {
                    msg = msg + this.codeConverters_.inputCharConverter.getFrom().description;
                } else if (codeSetContext.char_data == 0) {
                    msg = msg + "none";
                } else {
                    info = db.getCodeSetInfo(this.orbInstance_.getNativeCs());
                    msg = msg + info.description;
                }
                msg = msg + "\nwchar code set: ";
                if (this.codeConverters_.inputWcharConverter != null) {
                    msg = msg + this.codeConverters_.inputWcharConverter.getFrom().description;
                } else if (codeSetContext.wchar_data == 0) {
                    msg = msg + "none";
                } else {
                    info = db.getCodeSetInfo(this.orbInstance_.getNativeWcs());
                    msg = msg + info.description;
                }
                this.orbInstance_.getLogger().trace("incoming", msg);
                break;
            }
        }
    }

    protected void exception(int state, SystemException ex) {
        String msg = "communications error with client\n";
        msg = msg + ex.getMessage();
        this.orbInstance_.getLogger().warning(msg);
        byte minor = this.minor_;
        if (ex.minor == 1330577433) {
            this.minor_ = (byte)2;
        }
        this.setStateNoSync(state);
        this.minor_ = minor;
    }

    protected abstract void gracefulShutdown();

    protected abstract void abortiveShutdown();

    protected abstract void upcallReturn(Buffer var1);

    protected boolean setStateNoSync(int state) {
        if (this.state_ == state) {
            return false;
        }
        if (this.state_ != 1 && state < this.state_) {
            return false;
        }
        this.state_ = state;
        switch (state) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.gracefulShutdown();
                this.destroyed_ = true;
                break;
            }
            case 3: {
                this.abortiveShutdown();
                this.destroyed_ = true;
                break;
            }
            case 4: {
                this.logCloseConnection();
                this.transport_.close();
                this.destroyed_ = true;
            }
        }
        return true;
    }

    protected Upcall execute() {
        boolean complete;
        Assert._OB_assert(this.state_ == 0 || this.state_ == 2);
        try {
            Buffer buf = this.buf_;
            this.buf_ = null;
            complete = this.incoming_.consumeBuffer(buf);
        }
        catch (SystemException ex) {
            this.exception(3, ex);
            return null;
        }
        byte minor = this.incoming_.version().minor;
        if (minor > this.minor_) {
            this.minor_ = minor;
        }
        if (!complete) {
            return null;
        }
        Upcall upcall = null;
        switch (this.incoming_.type().value()) {
            case 0: {
                if (this.state_ != 0) break;
                upcall = this.executeRequest();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.state_ != 0) break;
                this.executeLocate();
                break;
            }
            case 1: 
            case 4: {
                this.exception(3, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 5: {
                if (this.incoming_.version().minor < 2) {
                    this.exception(4, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427) + ": invalid version for CloseConnection", 1330577427, CompletionStatus.COMPLETED_MAYBE));
                    break;
                }
                this.closeConnection_ = true;
                this.setStateNoSync(4);
                break;
            }
            case 6: {
                this.exception(3, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577429), 1330577429, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 7: {
                Assert._OB_assert(false);
            }
        }
        return upcall;
    }

    protected Upcall executeRequest() {
        int reqId;
        Assert._OB_assert(this.state_ == 0);
        BooleanHolder response = new BooleanHolder();
        StringHolder op = new StringHolder();
        ServiceContextListHolder scl = new ServiceContextListHolder();
        TargetAddressHolder target = new TargetAddressHolder();
        try {
            reqId = this.incoming_.readRequestHeader(response, target, op, scl);
            if (target.value.discriminator() != 0) {
                this.exception(3, new NO_IMPLEMENT(MinorCodes.describeNoImplement(1330446339), 1330446339, CompletionStatus.COMPLETED_NO));
                return null;
            }
        }
        catch (SystemException ex) {
            this.exception(3, ex);
            return null;
        }
        Version version = this.incoming_.version();
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.major = version.major;
        profileInfo.minor = version.minor;
        profileInfo.key = target.value.object_key();
        InputStream in = this.incoming_.input();
        this.getCodeConverters(scl.value);
        if (this.codeConverters_ != null) {
            in._OB_codeConverters(this.codeConverters_, version.major << 8 | version.minor);
        }
        if (response.value) {
            ++this.upcallCount_;
        }
        return this.oaInterface_.createUpcall(response.value ? this : null, profileInfo, this.transport_.get_info(), reqId, op.value, in, scl.value);
    }

    protected void executeLocate() {
        Assert._OB_assert(this.state_ == 0);
        if (this.transport_.mode() == SendReceiveMode.ReceiveOnly) {
            String msg = "Discarding locate request - transport does not support twoway invocations";
            TransportInfo transportInfo = this.transport_.get_info();
            if (transportInfo != null) {
                String desc = transportInfo.describe();
                msg = msg + '\n';
                msg = msg + desc;
            } else {
                msg = msg + "\nCollocated method call";
            }
            Logger logger = this.orbInstance_.getLogger();
            logger.warning(msg);
            return;
        }
        try {
            TargetAddressHolder target = new TargetAddressHolder();
            int reqId = this.incoming_.readLocateRequestHeader(target);
            if (target.value.discriminator() != 0) {
                this.exception(3, new NO_IMPLEMENT(MinorCodes.describeNoImplement(1330446339), 1330446339, CompletionStatus.COMPLETED_NO));
                return;
            }
            byte[] key = target.value.object_key();
            IORHolder ior = new IORHolder();
            int val = this.oaInterface_.findByKey(key, ior);
            LocateStatusType_1_2 status = LocateStatusType_1_2.from_int(val);
            Buffer buf = new Buffer(12);
            buf.pos(12);
            OutputStream out = new OutputStream(buf);
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.major = this.incoming_.version().major;
            profileInfo.minor = this.incoming_.version().minor;
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
            outgoing.writeLocateReplyHeader(reqId, status);
            if (status == LocateStatusType_1_2.OBJECT_FORWARD || status == LocateStatusType_1_2.OBJECT_FORWARD_PERM) {
                IORHelper.write(out, ior.value);
            }
            int pos = out._OB_pos();
            out._OB_pos(0);
            outgoing.writeMessageHeader(MsgType_1_1.LocateReply, false, pos - 12);
            out._OB_pos(pos);
            ++this.upcallCount_;
            this.upcallReturn(out._OB_buffer());
        }
        catch (SystemException ex) {
            this.exception(3, ex);
        }
    }

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.state_ == 4);
        super.finalize();
    }

    GIOPServerWorker(ORBInstance orbInstance, Transport transport, OAInterface oaInterface) {
        this.orbInstance_ = orbInstance;
        this.transport_ = transport;
        this.oaInterface_ = oaInterface;
        this.incoming_ = new GIOPIncomingMessage(this.orbInstance_);
        this.codeConverters_ = null;
        this.upcallCount_ = 0;
        this.minor_ = 0;
        this.closeLogged_ = false;
        this.closeConnection_ = false;
        this.state_ = 1;
        this.destroyed_ = false;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.server_shutdown_timeout");
        this.shutdownTimeout_ = value != null ? Integer.parseInt(value) : 2;
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            TransportInfo info = this.transport_.get_info();
            String msg = "new connection\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("incoming", msg);
        }
    }

    public abstract boolean setState(int var1);

    public boolean destroyed() {
        return this.destroyed_;
    }

    public void upcallBeginReply(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.NO_EXCEPTION, replySCL);
        }
        catch (SystemException ex) {
            Assert._OB_assert(false);
        }
    }

    public void upcallEndReply(Upcall upcall) {
        if (this.transport_.mode() == SendReceiveMode.ReceiveOnly) {
            String msg = "Discarding reply - transport does not support twoway invocations";
            msg = msg + "\noperation name: \"";
            msg = msg + upcall.operation();
            msg = msg + '\"';
            TransportInfo transportInfo = this.transport_.get_info();
            if (transportInfo != null) {
                String desc = transportInfo.describe();
                msg = msg + '\n';
                msg = msg + desc;
            } else {
                msg = msg + "\nCollocated method call";
            }
            Logger logger = this.orbInstance_.getLogger();
            logger.warning(msg);
            return;
        }
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int pos = out._OB_pos();
        out._OB_pos(0);
        try {
            outgoing.writeMessageHeader(MsgType_1_1.Reply, false, pos - 12);
        }
        catch (SystemException ex) {
            Assert._OB_assert(false);
        }
        this.upcallReturn(out._OB_buffer());
    }

    public void upcallBeginUserException(Upcall upcall, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.USER_EXCEPTION, replySCL);
        }
        catch (SystemException ex) {
            Assert._OB_assert(false);
        }
    }

    public void upcallEndUserException(Upcall upcall) {
        this.upcallEndReply(upcall);
    }

    public void upcallUserException(Upcall upcall, UserException ex, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.USER_EXCEPTION, replySCL);
            Assert._OB_assert(false);
        }
        catch (SystemException e) {
            Assert._OB_assert(false);
        }
        this.upcallEndReply(upcall);
    }

    public void upcallSystemException(Upcall upcall, SystemException ex, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        try {
            outgoing.writeReplyHeader(reqId, ReplyStatusType_1_2.SYSTEM_EXCEPTION, replySCL);
            Util.marshalSystemException(out, ex);
        }
        catch (SystemException e) {
            Assert._OB_assert(false);
        }
        this.upcallEndReply(upcall);
    }

    public void upcallForward(Upcall upcall, IOR ior, boolean perm, ServiceContext[] replySCL) {
        upcall.createOutputStream(12);
        OutputStream out = upcall.output();
        ProfileInfo profileInfo = upcall.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        int reqId = upcall.requestId();
        ReplyStatusType_1_2 status = perm ? ReplyStatusType_1_2.LOCATION_FORWARD_PERM : ReplyStatusType_1_2.LOCATION_FORWARD;
        try {
            outgoing.writeReplyHeader(reqId, status, replySCL);
            IORHelper.write(out, ior);
        }
        catch (SystemException ex) {
            Assert._OB_assert(false);
        }
        this.upcallEndReply(upcall);
    }
}

