/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.GIOPServerStarter;
import com.ooc.OB.GIOPServerWorker;
import com.ooc.OB.GIOPServerWorkerThreaded;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.Transport;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;

final class GIOPServerStarterThreaded
extends GIOPServerStarter {
    protected Thread starterThread_;

    GIOPServerStarterThreaded(ORBInstance orbInstance, Acceptor acceptor, OAInterface oaInterface) {
        super(orbInstance, acceptor, oaInterface);
        try {
            ThreadGroup group = this.orbInstance_.getServerWorkerGroup();
            this.starterThread_ = new StarterThread(group, this);
            this.starterThread_.start();
        }
        catch (OutOfMemoryError ex) {
            this.acceptor_.close();
            this.state_ = 2;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized void setState(int state) {
        if (this.state_ == state) {
            return;
        }
        if (this.state_ != 1 && state < this.state_) {
            return;
        }
        switch (state) {
            case 0: {
                for (int i = 0; i < this.workers_.size(); ++i) {
                    GIOPServerWorker w = (GIOPServerWorker)this.workers_.elementAt(i);
                    w.setState(0);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.workers_.size(); ++i) {
                    GIOPServerWorker w = (GIOPServerWorker)this.workers_.elementAt(i);
                    w.setState(1);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.workers_.size(); ++i) {
                    GIOPServerWorker w = (GIOPServerWorker)this.workers_.elementAt(i);
                    w.setState(2);
                }
                this.workers_.removeAllElements();
                try {
                    Transport tr = this.acceptor_.connect_self();
                    tr.close();
                    break;
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
            }
        }
        this.state_ = state;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void starterRun() {
        while (true) {
            Transport transport = null;
            try {
                transport = this.acceptor_.accept(true);
                Assert._OB_assert(transport != null);
            }
            catch (NO_PERMISSION ex) {
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            GIOPServerStarterThreaded gIOPServerStarterThreaded = this;
            synchronized (gIOPServerStarterThreaded) {
                this.reapWorkers();
                while (this.state_ == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                if (transport != null) {
                    try {
                        GIOPServerWorkerThreaded worker;
                        if (this.state_ == 0) {
                            worker = new GIOPServerWorkerThreaded(this.orbInstance_, transport, this.oaInterface_);
                            this.workers_.addElement(worker);
                            ((GIOPServerWorker)worker).setState(0);
                        } else {
                            Assert._OB_assert(this.state_ == 2);
                            worker = new GIOPServerWorkerThreaded(this.orbInstance_, transport, this.oaInterface_);
                            ((GIOPServerWorker)worker).setState(2);
                        }
                    }
                    catch (SystemException ex) {
                        String msg = "can't accept connection\n" + ex.getMessage();
                        this.orbInstance_.getLogger().warning(msg);
                    }
                }
                if (this.state_ == 2) {
                    break;
                }
            }
        }
    }

    protected final class StarterThread
    extends Thread {
        private GIOPServerStarterThreaded starter_;

        StarterThread(ThreadGroup group, GIOPServerStarterThreaded starter) {
            super(group, "ORBacus:Server:StarterThread");
            this.starter_ = starter;
        }

        public void run() {
            try {
                this.starter_.starterRun();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                Assert._OB_assert(false);
            }
            this.starter_.logCloseAcceptor();
            this.starter_.acceptor_.shutdown();
            while (true) {
                Transport transport = null;
                try {
                    transport = this.starter_.acceptor_.accept(false);
                }
                catch (SystemException ex) {
                    // empty catch block
                }
                if (transport == null) break;
                try {
                    GIOPServerWorkerThreaded worker = new GIOPServerWorkerThreaded(this.starter_.orbInstance_, transport, this.starter_.oaInterface_);
                    ((GIOPServerWorker)worker).setState(2);
                }
                catch (SystemException systemException) {}
            }
            this.starter_.acceptor_.close();
            this.starter_ = null;
        }
    }
}

