/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Buffer;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StringHolder;
import org.omg.GIOP.IORAddressingInfoHelper;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.LocateStatusType_1_2Holder;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.GIOP.TargetAddress;
import org.omg.GIOP.TargetAddressHolder;
import org.omg.GIOP.Version;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHolder;
import org.omg.IOP.TaggedProfileHelper;

public final class GIOPIncomingMessage {
    private ORBInstance orbInstance_;
    private InputStream in_;
    private static int maxMessageSize_;
    private Version version_ = new Version();
    private boolean byteOrder_;
    private boolean fragment_;
    private MsgType_1_1 type_;
    private int size_;
    private Fragment fragmentHead_;
    private Fragment lastFragment_;

    private int readFragmentHeader(InputStream in) {
        int id = 0;
        switch (this.version_.minor) {
            case 0: {
                Assert._OB_assert(false);
            }
            case 1: {
                Assert._OB_assert(false);
            }
            case 2: {
                id = in.read_ulong();
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
        return id;
    }

    private void skipServiceContextList(InputStream in) {
        int len = in.read_ulong();
        for (int i = 0; i < len; ++i) {
            in._OB_skipAlign(4);
            in._OB_skip(4);
            int datalen = in.read_ulong();
            in._OB_skip(datalen);
        }
    }

    private void readServiceContextList(ServiceContextListHolder scl) {
        int len = this.in_.read_ulong();
        scl.value = new ServiceContext[len];
        if (len != 0) {
            for (int i = 0; i < len; ++i) {
                scl.value[i] = new ServiceContext();
                ServiceContext sc = scl.value[i];
                sc.context_id = this.in_.read_ulong();
                int datalen = this.in_.read_ulong();
                sc.context_data = new byte[datalen];
                this.in_.read_octet_array(sc.context_data, 0, datalen);
            }
        }
    }

    private void readTargetAddress(TargetAddressHolder target) {
        target.value = new TargetAddress();
        short disc = this.in_.read_short();
        switch (disc) {
            case 0: {
                int len = this.in_.read_ulong();
                byte[] seq = new byte[len];
                this.in_.read_octet_array(seq, 0, len);
                target.value.object_key(seq);
                break;
            }
            case 1: {
                target.value.profile(TaggedProfileHelper.read(this.in_));
                break;
            }
            case 2: {
                target.value.ior(IORAddressingInfoHelper.read(this.in_));
                break;
            }
            default: {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577425) + ": invalid target address", 1330577425, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    GIOPIncomingMessage(ORBInstance orbInstance) {
        this.orbInstance_ = orbInstance;
        this.fragmentHead_ = null;
        this.lastFragment_ = null;
    }

    Version version() {
        return this.version_;
    }

    boolean swap() {
        return this.byteOrder_;
    }

    MsgType_1_1 type() {
        return this.type_;
    }

    int size() {
        return this.size_;
    }

    InputStream input() {
        InputStream result = this.in_;
        this.in_ = null;
        return result;
    }

    void extractHeader(Buffer buf) {
        this.in_ = null;
        byte[] pos = buf.data();
        if (pos[0] != 71 || pos[1] != 73 || pos[2] != 79 || pos[3] != 80) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577425) + ": missing GIOP magic key", 1330577425, CompletionStatus.COMPLETED_MAYBE);
        }
        this.version_.major = pos[4];
        this.version_.minor = pos[5];
        if (this.version_.major != 1 || this.version_.minor > 2) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577433), 1330577433, CompletionStatus.COMPLETED_MAYBE);
        }
        InputStream in = new InputStream(buf, 0, false);
        switch (this.version_.minor) {
            case 0: {
                in._OB_skip(6);
                this.byteOrder_ = in.read_boolean();
                in._OB_swap(this.byteOrder_);
                this.fragment_ = false;
                this.type_ = MsgType_1_1.from_int(in.read_octet());
                this.size_ = in.read_ulong();
                if (this.type_.value() <= 6) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577426) + ": invalid message type for GIOP 1.0", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: 
            case 2: {
                in._OB_skip(6);
                byte flags = in.read_octet();
                this.byteOrder_ = (flags & 1) == 1;
                this.fragment_ = (flags & 2) == 2;
                in._OB_swap(this.byteOrder_);
                this.type_ = MsgType_1_1.from_int(in.read_octet());
                this.size_ = in.read_ulong();
                if (this.type_.value() <= 7) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577426) + ": invalid message type for GIOP 1.1/1.2", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                Assert._OB_assert(false);
            }
        }
        if (maxMessageSize_ > 0 && this.size_ > maxMessageSize_) {
            String msg = "incoming message size (" + this.size_ + ") exceeds maximum (" + maxMessageSize_ + ")";
            this.orbInstance_.getLogger().warning(msg);
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577409), 1330577409, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.version_.minor == 2 && this.fragment_ && (this.size_ + 12) % 8 != 0) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430) + ": invalid GIOP 1.2 fragment size", 1330577430, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    boolean consumeBuffer(Buffer buf) {
        boolean result = false;
        if (this.fragment_ && this.type_ != MsgType_1_1.Fragment) {
            if (this.version_.minor < 1) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
            }
            if (this.version_.minor == 1) {
                if (this.type_ != MsgType_1_1.Request && this.type_ != MsgType_1_1.Reply) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
                }
                if (this.lastFragment_ != null) {
                    this.lastFragment_ = null;
                }
                int reqId = 0;
                boolean haveReqId = false;
                try {
                    InputStream in = new InputStream(buf, 12, this.swap());
                    this.skipServiceContextList(in);
                    reqId = in.read_ulong();
                    haveReqId = true;
                }
                catch (MARSHAL ex) {
                    // empty catch block
                }
                this.lastFragment_ = new Fragment();
                this.lastFragment_.version = new Version(this.version_.major, this.version_.minor);
                this.lastFragment_.byteOrder = this.byteOrder_;
                this.lastFragment_.reqId = reqId;
                this.lastFragment_.haveReqId = haveReqId;
                this.lastFragment_.type = this.type_;
                this.lastFragment_.buf = buf;
                this.lastFragment_.next = null;
            } else {
                if (this.type_ != MsgType_1_1.Request && this.type_ != MsgType_1_1.Reply && this.type_ != MsgType_1_1.LocateRequest && this.type_ != MsgType_1_1.LocateReply) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
                }
                int reqId = 0;
                boolean haveReqId = false;
                try {
                    InputStream in = new InputStream(buf, 12, this.swap());
                    reqId = in.read_ulong();
                    haveReqId = true;
                }
                catch (MARSHAL ex) {
                    // empty catch block
                }
                Assert._OB_assert(haveReqId);
                Fragment f = new Fragment();
                f.version = new Version(this.version_.major, this.version_.minor);
                f.byteOrder = this.byteOrder_;
                f.reqId = reqId;
                f.haveReqId = haveReqId;
                f.type = this.type_;
                f.buf = buf;
                f.next = this.fragmentHead_;
                this.fragmentHead_ = f;
            }
        } else if (this.type_ == MsgType_1_1.Fragment) {
            Fragment complete = null;
            if (this.version_.minor < 1) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
            }
            if (this.version_.minor == 1) {
                if (this.lastFragment_ == null) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577430), 1330577430, CompletionStatus.COMPLETED_MAYBE);
                }
                this.lastFragment_.add(this.orbInstance_, buf);
                if (!this.lastFragment_.haveReqId) {
                    InputStream reqIn = new InputStream(this.lastFragment_.buf, 12, this.swap());
                    try {
                        this.skipServiceContextList(reqIn);
                        this.lastFragment_.reqId = reqIn.read_ulong();
                        this.lastFragment_.haveReqId = true;
                    }
                    catch (MARSHAL ex) {
                        // empty catch block
                    }
                }
                if (!this.fragment_) {
                    complete = this.lastFragment_;
                    this.lastFragment_ = null;
                }
            } else {
                InputStream in = new InputStream(buf, 12, this.swap());
                int reqId = this.readFragmentHeader(in);
                Fragment frag = null;
                Fragment p = this.fragmentHead_;
                Fragment prev = null;
                while (p != null) {
                    Fragment f = p;
                    if (f.haveReqId && f.reqId == reqId) {
                        frag = f;
                        break;
                    }
                    prev = p;
                    p = f.next;
                }
                if (frag != null) {
                    frag.add(this.orbInstance_, in._OB_buffer());
                    if (!this.fragment_) {
                        if (prev == null) {
                            this.fragmentHead_ = frag.next;
                        } else {
                            prev.next = frag.next;
                        }
                        complete = frag;
                    }
                }
            }
            if (complete != null) {
                this.version_ = complete.version;
                this.byteOrder_ = complete.byteOrder;
                this.type_ = complete.type;
                this.fragment_ = false;
                this.size_ = complete.buf.length();
                this.in_ = new InputStream(complete.buf, 12, this.swap());
                complete = null;
                result = true;
            }
        } else if (this.type_ == MsgType_1_1.CancelRequest) {
            this.in_ = new InputStream(buf, 12, this.swap());
            int reqId = this.readCancelRequestHeader();
            if (this.version_.minor == 1) {
                if (this.lastFragment_ != null && this.lastFragment_.haveReqId && this.lastFragment_.reqId == reqId) {
                    this.lastFragment_ = null;
                }
            } else {
                Fragment p = this.fragmentHead_;
                while (p != null) {
                    Fragment f = p;
                    if (f.haveReqId && f.reqId == reqId) {
                        p = f.next;
                        f = null;
                        break;
                    }
                    p = f.next;
                }
            }
            this.in_._OB_reset();
            result = true;
        } else {
            this.in_ = new InputStream(buf, 12, this.swap());
            result = true;
        }
        return result;
    }

    int readRequestHeader(BooleanHolder response, TargetAddressHolder target, StringHolder op, ServiceContextListHolder scl) {
        Assert._OB_assert(this.type_ == MsgType_1_1.Request);
        int id = 0;
        switch (this.version_.minor) {
            case 0: {
                this.readServiceContextList(scl);
                id = this.in_.read_ulong();
                response.value = this.in_.read_boolean();
                int len = this.in_.read_ulong();
                byte[] key = new byte[len];
                this.in_.read_octet_array(key, 0, len);
                target.value = new TargetAddress();
                target.value.object_key(key);
                len = this.in_.read_ulong();
                byte[] s = new byte[len];
                this.in_.read_octet_array(s, 0, len);
                op.value = new String(s, 0, len - 1);
                len = this.in_.read_ulong();
                if (len <= 0) break;
                this.in_._OB_skip(len);
                break;
            }
            case 1: {
                this.readServiceContextList(scl);
                id = this.in_.read_ulong();
                response.value = this.in_.read_boolean();
                this.in_._OB_skip(3);
                int len = this.in_.read_ulong();
                byte[] key = new byte[len];
                this.in_.read_octet_array(key, 0, len);
                target.value = new TargetAddress();
                target.value.object_key(key);
                len = this.in_.read_ulong();
                byte[] s = new byte[len];
                this.in_.read_octet_array(s, 0, len);
                op.value = new String(s, 0, len - 1);
                len = this.in_.read_ulong();
                if (len <= 0) break;
                this.in_._OB_skip(len);
                break;
            }
            case 2: {
                id = this.in_.read_ulong();
                byte flags = this.in_.read_octet();
                response.value = (flags & 1) == 1;
                this.in_._OB_skip(3);
                this.readTargetAddress(target);
                int len = this.in_.read_ulong();
                byte[] s = new byte[len];
                this.in_.read_octet_array(s, 0, len);
                op.value = new String(s, 0, len - 1);
                this.readServiceContextList(scl);
                if (this.in_._OB_pos() >= this.size_ + 12) break;
                this.in_._OB_skipAlign(8);
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
        return id;
    }

    int readReplyHeader(ReplyStatusType_1_2Holder status, ServiceContextListHolder scl) {
        Assert._OB_assert(this.type_ == MsgType_1_1.Reply);
        int id = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                this.readServiceContextList(scl);
                id = this.in_.read_ulong();
                status.value = ReplyStatusType_1_2.from_int(this.in_.read_ulong());
                if (status.value.value() <= 3) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577426) + ": invalid reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                id = this.in_.read_ulong();
                status.value = ReplyStatusType_1_2.from_int(this.in_.read_ulong());
                if (status.value.value() > 5) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577426) + ": invalid reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
                }
                this.readServiceContextList(scl);
                if (this.in_._OB_pos() >= this.size_ + 12) break;
                this.in_._OB_skipAlign(8);
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
        return id;
    }

    int readCancelRequestHeader() {
        Assert._OB_assert(this.type_ == MsgType_1_1.CancelRequest);
        int id = this.in_.read_ulong();
        return id;
    }

    int readLocateRequestHeader(TargetAddressHolder target) {
        Assert._OB_assert(this.type_ == MsgType_1_1.LocateRequest);
        int id = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                id = this.in_.read_ulong();
                int keylen = this.in_.read_ulong();
                byte[] key = new byte[keylen];
                this.in_.read_octet_array(key, 0, keylen);
                target.value = new TargetAddress();
                target.value.object_key(key);
                break;
            }
            case 2: {
                id = this.in_.read_ulong();
                this.readTargetAddress(target);
                break;
            }
            default: {
                Assert._OB_assert(false);
            }
        }
        return id;
    }

    int readLocateReplyHeader(LocateStatusType_1_2Holder status) {
        Assert._OB_assert(this.type_ == MsgType_1_1.LocateReply);
        int id = 0;
        switch (this.version_.minor) {
            case 0: 
            case 1: {
                id = this.in_.read_ulong();
                status.value = LocateStatusType_1_2.from_int(this.in_.read_ulong());
                if (status.value.value() <= 2) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577426) + ": invalid locate reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                id = this.in_.read_ulong();
                status.value = LocateStatusType_1_2.from_int(this.in_.read_ulong());
                if (status.value.value() <= 5) break;
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577426) + ": invalid locate reply status", 1330577426, CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                Assert._OB_assert(false);
            }
        }
        return id;
    }

    public static void setMaxMessageSize(int max) {
        maxMessageSize_ = max;
    }

    private class Fragment {
        private Version version;
        private boolean byteOrder;
        private int reqId;
        private boolean haveReqId;
        private MsgType_1_1 type;
        private Buffer buf;
        Fragment next;

        private Fragment() {
        }

        void add(ORBInstance orbInstance, Buffer b) {
            int len = this.buf.length();
            if (maxMessageSize_ > 0 && len + b.rest_length() > maxMessageSize_) {
                String msg = "incoming fragment exceeds maximum message size (" + maxMessageSize_ + ")";
                GIOPIncomingMessage.this.orbInstance_.getLogger().warning(msg);
                throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
            }
            this.buf.realloc(len + b.rest_length());
            System.arraycopy(b.data(), b.pos(), this.buf.data(), len, b.rest_length());
        }
    }
}

