/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.CodeSetDatabase;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CONV_FRAME.CodeSetComponentInfoHolder;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CONV_FRAME.CodeSetContextHolder;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;

public final class CodeSetUtil {
    private static Vector supportedCharCodeSets_ = new Vector();
    private static Vector supportedWcharCodeSets_ = new Vector();

    static void addCharCodeSet(int id) {
        supportedCharCodeSets_.addElement(new Integer(id));
    }

    static void addWcharCodeSet(int id) {
        supportedWcharCodeSets_.addElement(new Integer(id));
    }

    static CodeSetComponent createCodeSetComponent(int id, boolean wChar) {
        Enumeration e;
        CodeSetDatabase.instance();
        CodeSetComponent codeSetComponent = new CodeSetComponent();
        codeSetComponent.native_code_set = id;
        Vector<Integer> conversion_code_sets = new Vector<Integer>();
        Enumeration enumeration = e = wChar ? supportedWcharCodeSets_.elements() : supportedCharCodeSets_.elements();
        while (e.hasMoreElements()) {
            Integer cs = (Integer)e.nextElement();
            if (cs == id) continue;
            conversion_code_sets.addElement(cs);
        }
        codeSetComponent.conversion_code_sets = new int[conversion_code_sets.size()];
        e = conversion_code_sets.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            codeSetComponent.conversion_code_sets[i++] = (Integer)e.nextElement();
        }
        return codeSetComponent;
    }

    static boolean getCodeSetInfoFromComponents(ORBInstance orbInstance, ProfileInfo profileInfo, CodeSetComponentInfoHolder info) {
        if (profileInfo.major == 1 && profileInfo.minor > 0) {
            for (int i = 0; i < profileInfo.components.length; ++i) {
                if (!CodeSetUtil.checkForCodeSetInfo(profileInfo.components[i], info)) continue;
                return true;
            }
        } else if (orbInstance.extendedWchar()) {
            info.value = new CodeSetComponentInfo(new CodeSetComponent(65537, new int[0]), new CodeSetComponent(65792, new int[0]));
            return true;
        }
        return false;
    }

    static CodeConverters getCodeConverters(ORBInstance orbInstance, ProfileInfo profileInfo) {
        CodeSetComponentInfoHolder serverInfo = new CodeSetComponentInfoHolder();
        serverInfo.value = new CodeSetComponentInfo();
        serverInfo.value.ForCharData = new CodeSetComponent();
        serverInfo.value.ForWcharData = new CodeSetComponent();
        serverInfo.value.ForCharData.native_code_set = 65537;
        serverInfo.value.ForCharData.conversion_code_sets = new int[0];
        serverInfo.value.ForWcharData.native_code_set = orbInstance.getDefaultWcs();
        serverInfo.value.ForWcharData.conversion_code_sets = new int[0];
        int nativeCs = orbInstance.getNativeCs();
        CodeSetComponent client_cs = CodeSetUtil.createCodeSetComponent(nativeCs, false);
        int tcs_c = 65537;
        int nativeWcs = orbInstance.getNativeWcs();
        CodeSetComponent client_wcs = CodeSetUtil.createCodeSetComponent(nativeWcs, true);
        int tcs_wc = orbInstance.getDefaultWcs();
        CodeSetDatabase db = CodeSetDatabase.instance();
        if (CodeSetUtil.getCodeSetInfoFromComponents(orbInstance, profileInfo, serverInfo)) {
            tcs_c = db.determineTCS(client_cs, serverInfo.value.ForCharData, 0x5010001);
            tcs_wc = db.determineTCS(client_wcs, serverInfo.value.ForWcharData, 65792);
        }
        CodeConverters conv = new CodeConverters();
        conv.inputCharConverter = db.getConverter(nativeCs, tcs_c);
        conv.outputCharConverter = db.getConverter(tcs_c, nativeCs);
        conv.inputWcharConverter = db.getConverter(nativeWcs, tcs_wc);
        conv.outputWcharConverter = db.getConverter(tcs_wc, nativeWcs);
        return conv;
    }

    static boolean checkForCodeSetInfo(TaggedComponent comp, CodeSetComponentInfoHolder info) {
        if (comp.tag == 1) {
            byte[] coct = comp.component_data;
            Buffer buf = new Buffer(coct, coct.length);
            InputStream in = new InputStream(buf, 0, false);
            in._OB_readEndian();
            info.value = CodeSetComponentInfoHelper.read(in);
            return true;
        }
        return false;
    }

    static void extractCodeSetContext(ServiceContext context, CodeSetContextHolder ctx) {
        byte[] coct = context.context_data;
        Buffer buf = new Buffer(coct, coct.length);
        InputStream in = new InputStream(buf, 0, false);
        in._OB_readEndian();
        ctx.value = CodeSetContextHelper.read(in);
    }
}

