/*
 * Decompiled with CFR 0.152.
 */
package test.retry;

import com.ooc.OB.RetryAttributes;
import com.ooc.OB.RetryAttributesHelper;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import test.common.TestBase;
import test.retry.Retry;
import test.retry.RetryHelper;
import test.retry.RetryServer;
import test.retry.RetryServerHelper;
import test.retry.Test;

public class Client
extends TestBase {
    static void testLocationForward(ORB orb, RetryServer server) {
        System.out.print("Testing forwarding loop detection... ");
        System.out.flush();
        Test test = server.get_location_forward_object();
        try {
            test.aMethod();
            Client.TEST(false);
        }
        catch (TRANSIENT ex) {
            Client.TEST(ex.minor == 1330577413);
        }
        System.out.println("Done!");
    }

    static Retry getRetry(ORB orb, Retry orig, short mode, int interval, int max, boolean remote) {
        try {
            RetryAttributes attrib = new RetryAttributes();
            attrib.mode = mode;
            attrib.interval = interval;
            attrib.max = max;
            attrib.remote = remote;
            Any a = orb.create_any();
            RetryAttributesHelper.insert((Any)a, (RetryAttributes)attrib);
            Policy[] policies = new Policy[]{orb.create_policy(0x4F4F0004, a)};
            Object obj = orig._set_policy_override(policies, SetOverrideType.SET_OVERRIDE);
            return RetryHelper.narrow(obj);
        }
        catch (UserException ex) {
            ex.printStackTrace();
            Client.TEST(false);
            return null;
        }
    }

    static void testRetry(ORB orb, RetryServer server) {
        Retry orig = server.get_retry_object();
        System.out.print("Testing retry for remote exceptions... ");
        System.out.flush();
        Retry retry = Client.getRetry(orb, orig, (short)1, 0, 0, false);
        retry.raise_exception(1, false);
        try {
            retry.aMethod();
            Client.TEST(false);
        }
        catch (TRANSIENT ex) {
            Client.TEST(retry.get_count() == 1);
        }
        retry = Client.getRetry(orb, orig, (short)1, 0, 0, true);
        retry.raise_exception(1, false);
        try {
            retry.aMethod();
            Client.TEST(retry.get_count() == 2);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        System.out.println("Done!");
        System.out.print("Testing RETRY_STRICT... ");
        System.out.flush();
        retry = Client.getRetry(orb, orig, (short)1, 0, 0, true);
        retry.raise_exception(1, true);
        try {
            retry.aMethod();
            Client.TEST(false);
        }
        catch (SystemException ex) {
            Client.TEST(retry.get_count() == 1);
        }
        System.out.println("Done!");
        System.out.print("Testing RETRY_NEVER... ");
        System.out.flush();
        retry = Client.getRetry(orb, orig, (short)0, 0, 0, true);
        retry.raise_exception(1, false);
        try {
            retry.aMethod();
            Client.TEST(false);
        }
        catch (TRANSIENT ex) {
            Client.TEST(retry.get_count() == 1);
        }
        System.out.println("Done!");
        System.out.print("Testing RETRY_ALWAYS... ");
        System.out.flush();
        retry = Client.getRetry(orb, orig, (short)2, 0, 0, true);
        retry.raise_exception(1, true);
        try {
            retry.aMethod();
            Client.TEST(retry.get_count() == 2);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        System.out.println("Done!");
        System.out.print("Testing multiple retries... ");
        System.out.flush();
        retry = Client.getRetry(orb, orig, (short)1, 0, 0, true);
        retry.raise_exception(5, false);
        try {
            retry.aMethod();
            Client.TEST(retry.get_count() == 6);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        retry = Client.getRetry(orb, orig, (short)1, 0, 5, true);
        retry.raise_exception(6, false);
        try {
            retry.aMethod();
            Client.TEST(false);
        }
        catch (TRANSIENT ex) {
            Client.TEST(retry.get_count() == 6);
        }
        System.out.println("Done!");
        System.out.print("Testing retry interval... ");
        System.out.flush();
        retry = Client.getRetry(orb, orig, (short)1, 100, 0, true);
        retry.raise_exception(12, false);
        try {
            long start = System.currentTimeMillis();
            retry.aMethod();
            long stop = System.currentTimeMillis();
            Client.TEST(stop - start > 1000L);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        System.out.println("Done!");
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            RetryServer server;
            orb = ORB.init((String[])args, (Properties)props);
            Object obj = orb.string_to_object("relfile:/Test.ref");
            if (obj == null) {
                System.err.println("cannot read IOR from Test.ref");
                System.exit(1);
            }
            Client.TEST((server = RetryServerHelper.narrow(obj)) != null);
            Client.testLocationForward(orb, server);
            Client.testRetry(orb, server);
            server.deactivate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

