/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import test.common.TestBase;
import test.poa.POAManagerProxy;
import test.poa.POAManagerProxyHelper;
import test.poa.POAManagerProxyPackage.AdapterInactive;
import test.poa.TestInfo;
import test.poa.TestPOAManagerCommon;
import test.poa.TestServer;
import test.poa.TestServerHelper;

final class TestPOAManagerClient
extends TestBase {
    TestPOAManagerClient() {
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            Object obj = orb.string_to_object("relfile:/Test.ref");
            if (obj == null) {
                System.err.println("cannot read IOR from Test.ref");
                System.exit(1);
            }
            TestServer server = TestServerHelper.narrow(obj);
            obj = orb.string_to_object("relfile:/POAManagerProxy.ref");
            if (obj == null) {
                System.err.println("cannot read IOR from POAManagerProxy.ref");
                System.exit(1);
            }
            POAManagerProxy manager = POAManagerProxyHelper.narrow(obj);
            try {
                manager.activate();
            }
            catch (AdapterInactive ex) {
                TestPOAManagerClient.TEST(false);
            }
            TestInfo[] info = server.get_info();
            new TestPOAManagerCommon(manager, info);
            server.deactivate();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

