/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import com.ooc.CORBA.ORB;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.Servant;
import test.common.TestBase;
import test.poa.Test;
import test.poa.TestHelper;
import test.poa.TestInfo;
import test.poa.TestPOA;
import test.poa.TestServer;
import test.poa.TestServer_impl;

final class TestMultipleOrbsThreadedServer
extends TestBase {
    static int NUM_ORBS = 5;

    TestMultipleOrbsThreadedServer() {
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        props.put("ooc.orb.id", "");
        org.omg.CORBA.ORB orb = null;
        try {
            int i;
            args = ORB.ParseArgs((String[])args, (Properties)props, null);
            props.put("ooc.orb.conc_model", "threaded");
            props.put("ooc.orb.oa.conc_model", "threaded");
            orb = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            Object poaObj = orb.resolve_initial_references("RootPOA");
            POA rootPOA = POAHelper.narrow((Object)poaObj);
            POAManager manager = rootPOA.the_POAManager();
            OrbTestThread[] orb_thread = new OrbTestThread[NUM_ORBS];
            for (i = 0; i < NUM_ORBS; ++i) {
                orb_thread[i] = new OrbTestThread("orb" + (i + 1));
            }
            for (i = 0; i < NUM_ORBS; ++i) {
                orb_thread[i].start();
            }
            TestInfo[] info = new TestInfo[NUM_ORBS];
            for (int i2 = 0; i2 < NUM_ORBS; ++i2) {
                info[i2] = new TestInfo();
                info[i2].obj = orb_thread[i2].getObjectReference();
                info[i2].except_id = "";
            }
            TestServer_impl serverImpl = new TestServer_impl(orb, info);
            TestServer server = serverImpl._this(orb);
            String refFile = "Test.ref";
            try {
                FileOutputStream file = new FileOutputStream(refFile);
                PrintWriter out = new PrintWriter(file);
                out.println(orb.object_to_string((Object)server));
                out.flush();
                file.close();
            }
            catch (IOException ex) {
                System.err.println("Can't write to `" + ex.getMessage() + "'");
                System.exit(1);
            }
            manager.activate();
            orb.run();
            for (int i3 = 0; i3 < NUM_ORBS; ++i3) {
                while (orb_thread[i3].isAlive()) {
                    try {
                        orb_thread[i3].join();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            File file = new File(refFile);
            file.delete();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }

    static final class OrbTestThread
    extends Thread {
        private org.omg.CORBA.ORB orb_;
        private POAManager manager_;
        private TestOrb_impl test_;
        private Test obj_;

        OrbTestThread(String orb_id) {
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
            props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
            props.put("ooc.orb.id", orb_id);
            try {
                String[] args = new String[]{};
                this.orb_ = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
                Object obj = this.orb_.resolve_initial_references("RootPOA");
                POA rootPOA = POAHelper.narrow((Object)obj);
                this.manager_ = rootPOA.the_POAManager();
                this.test_ = new TestOrb_impl(this.orb_);
                byte[] objId = rootPOA.activate_object((Servant)this.test_);
                obj = rootPOA.id_to_reference(objId);
                this.obj_ = TestHelper.narrow(obj);
            }
            catch (UserException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                System.exit(1);
            }
        }

        public Test getObjectReference() {
            return this.obj_;
        }

        public void run() {
            try {
                this.manager_.activate();
                this.orb_.run();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            catch (UserException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            if (this.orb_ != null) {
                try {
                    ((ORB)this.orb_).destroy();
                }
                catch (SystemException ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    static final class TestOrb_impl
    extends TestPOA {
        private int count_ = 0;
        private org.omg.CORBA.ORB orb_;

        TestOrb_impl(org.omg.CORBA.ORB orb) {
            this.orb_ = orb;
        }

        public void aMethod() {
            if (++this.count_ == 3) {
                this.orb_.shutdown(false);
            }
        }
    }
}

