/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import com.ooc.CORBA.ORB;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import test.common.TestBase;
import test.poa.Test;
import test.poa.TestInfo;
import test.poa.TestServer;
import test.poa.TestServer_impl;
import test.poa.Test_impl;

final class TestMultipleOrbsServer
extends TestBase {
    TestMultipleOrbsServer() {
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        org.omg.CORBA.ORB orb1 = null;
        org.omg.CORBA.ORB orb2 = null;
        try {
            orb1 = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            orb2 = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            Object poaObj = orb1.resolve_initial_references("RootPOA");
            POA rootPOA1 = POAHelper.narrow((Object)poaObj);
            POAManager manager1 = rootPOA1.the_POAManager();
            poaObj = orb2.resolve_initial_references("RootPOA");
            POA rootPOA2 = POAHelper.narrow((Object)poaObj);
            POAManager manager2 = rootPOA2.the_POAManager();
            Test_impl testImpl1 = new Test_impl(orb1, rootPOA1);
            Test test1 = testImpl1._this(orb1);
            Test_impl testImpl2 = new Test_impl(orb2, rootPOA2);
            Test test2 = testImpl2._this(orb2);
            TestInfo[] info = new TestInfo[]{new TestInfo()};
            info[0].obj = test1;
            info[0].except_id = "";
            TestServer_impl serverImpl1 = new TestServer_impl(orb1, info);
            TestServer server1 = serverImpl1._this(orb1);
            info[0].obj = test2;
            info[0].except_id = "";
            TestServer_impl serverImpl2 = new TestServer_impl(orb2, info);
            TestServer server2 = serverImpl2._this(orb2);
            String refFile = "Test.ref";
            try {
                FileOutputStream file = new FileOutputStream(refFile);
                PrintWriter out = new PrintWriter(file);
                out.println(orb1.object_to_string((Object)server1));
                out.println(orb2.object_to_string((Object)server2));
                out.flush();
                file.close();
            }
            catch (IOException ex) {
                System.err.println("Can't write to `" + ex.getMessage() + "'");
                System.exit(1);
            }
            manager1.activate();
            manager2.activate();
            boolean orb1_gone = false;
            boolean orb2_gone = false;
            do {
                try {
                    if (orb1.work_pending()) {
                        orb1.perform_work();
                    }
                }
                catch (BAD_INV_ORDER ex) {
                    orb1_gone = true;
                }
                try {
                    if (!orb2.work_pending()) continue;
                    orb2.perform_work();
                }
                catch (BAD_INV_ORDER ex) {
                    orb2_gone = true;
                }
            } while (!orb1_gone || !orb2_gone);
            File file = new File(refFile);
            file.delete();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        catch (UserException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb1 != null) {
            try {
                ((ORB)orb1).destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        if (orb2 != null) {
            try {
                ((ORB)orb2).destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

