/*
 * Decompiled with CFR 0.152.
 */
package test.local;

import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.Encoding;
import test.common.TestBase;
import test.local.LocalTest_impl;
import test.local.Test;
import test.local.TestHelper;

public class Client
extends TestBase {
    public static int run(ORB orb, String[] args) throws UserException {
        byte[] data;
        Any a;
        Object obj = orb.string_to_object("relfile:/Test.ref");
        if (obj == null) {
            System.err.println("cannot read IOR from Test.ref");
            return 1;
        }
        Test test = TestHelper.narrow(obj);
        Client.TEST(test != null);
        LocalTest_impl localTest = new LocalTest_impl();
        CodecFactory factory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
        Client.TEST(factory != null);
        Encoding how = new Encoding();
        how.major_version = 0;
        how.minor_version = 0;
        how.format = 0;
        Codec codec = factory.create_codec(how);
        Client.TEST(codec != null);
        System.out.print("Testing Codec... ");
        System.out.flush();
        try {
            a = orb.create_any();
            TestHelper.insert(a, test);
            data = codec.encode_value(a);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        try {
            a = orb.create_any();
            TestHelper.insert(a, localTest);
            data = codec.encode_value(a);
            Client.TEST(false);
        }
        catch (MARSHAL ex) {
            // empty catch block
        }
        System.out.println("Done!");
        System.out.print("Testing simple RPC call... ");
        System.out.flush();
        test.say("Hi");
        System.out.println("Done!");
        System.out.print("Testing passing non-local object... ");
        System.out.flush();
        try {
            test.intest(test);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        System.out.println("Done!");
        System.out.print("Testing passing local object... ");
        System.out.flush();
        try {
            test.intest(localTest);
            Client.TEST(false);
        }
        catch (MARSHAL ex) {
            // empty catch block
        }
        System.out.println("Done!");
        System.out.print("Testing passing non-local object in any... ");
        System.out.flush();
        try {
            a = orb.create_any();
            TestHelper.insert(a, test);
            test.inany(a);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        System.out.println("Done!");
        System.out.print("Testing insertion of local object in any... ");
        System.out.flush();
        try {
            a = orb.create_any();
            TestHelper.insert(a, localTest);
            Test t = TestHelper.extract(a);
            Client.TEST(t == localTest);
        }
        catch (SystemException ex) {
            Client.TEST(false);
        }
        System.out.println("Done!");
        System.out.print("Testing passing local object in any... ");
        System.out.flush();
        try {
            a = orb.create_any();
            TestHelper.insert(a, localTest);
            test.inany(a);
            Client.TEST(false);
        }
        catch (MARSHAL ex) {
            // empty catch block
        }
        System.out.println("Done!");
        System.out.print("Testing returning local object... ");
        System.out.flush();
        try {
            Test t = test.returntest();
            Client.TEST(false);
        }
        catch (MARSHAL ex) {
            // empty catch block
        }
        System.out.println("Done!");
        System.out.print("Testing returning local object in any... ");
        System.out.flush();
        try {
            a = new AnyHolder();
            test.outany((AnyHolder)a);
            Client.TEST(false);
        }
        catch (MARSHAL ex) {
            // empty catch block
        }
        System.out.println("Done!");
        test.shutdown();
        return 0;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            status = Client.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

