/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OCI.IIOP;

import com.ooc.OB.MinorCodes;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.Connector;
import com.ooc.OCI.IIOP.InternalError;
import com.ooc.OCI.IIOP.TransportInfo_impl;
import com.ooc.OCI.SendReceiveMode;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;

final class Transport_impl
extends LocalObject
implements Transport {
    Socket socket_;
    private InputStream in_;
    private OutputStream out_;
    private boolean shutdown_;
    private int soTimeout_ = 0;
    private TransportInfo_impl info_;

    private void setSoTimeout(int t) {
        if (this.soTimeout_ != t) {
            this.soTimeout_ = t;
            try {
                this.socket_.setSoTimeout(this.soTimeout_);
            }
            catch (SocketException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577434) + ": socket error during setSoTimeout: " + ex.toString(), 1330577434, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577434) + ": NullPointerException error during setSoTimeout: " + ex.toString(), 1330577434, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    private void setBlock(boolean block) {
        if (block) {
            this.setSoTimeout(0);
        } else {
            this.setSoTimeout(1);
        }
    }

    private static void shutdownSocket(Socket socket, int how) {
        block7: {
            if (socket == null) {
                return;
            }
            if (how == 2) {
                Transport_impl.shutdownSocket(socket, 0);
                Transport_impl.shutdownSocket(socket, 1);
                return;
            }
            try {
                if (how == 0) {
                    socket.shutdownInput();
                    break block7;
                }
                if (how == 1) {
                    socket.shutdownOutput();
                    break block7;
                }
                throw new InternalError();
            }
            catch (SocketException ex) {
            }
            catch (IOException ex) {
                throw new InternalError();
            }
        }
    }

    public String id() {
        return "iiop";
    }

    public int tag() {
        return 0;
    }

    public SendReceiveMode mode() {
        return SendReceiveMode.SendReceive;
    }

    public int handle() {
        throw new NO_IMPLEMENT();
    }

    public void close() {
        if (this.socket_ == null) {
            return;
        }
        this.info_._OB_callCloseCB(this.info_);
        this.info_._OB_destroy();
        Socket saveSocket = this.socket_;
        this.socket_ = null;
        Transport_impl.shutdownSocket(saveSocket, 2);
        try {
            saveSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutdown() {
        Transport_impl.shutdownSocket(this.socket_, 1);
    }

    public void receive(Buffer buf, boolean block) {
        this.setBlock(block);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577411), 1330577411, CompletionStatus.COMPLETED_NO);
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                if (block) continue;
                return;
            }
            catch (IOException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577409) + ": I/O error during read: " + ex.toString(), 1330577409, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577409) + ": NullPointerException during read", 1330577409, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public boolean receive_detect(Buffer buf, boolean block) {
        this.setBlock(block);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    return false;
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                if (block) continue;
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    public void receive_timeout(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            this.receive(buf, false);
            return;
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577411), 1330577411, CompletionStatus.COMPLETED_NO);
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return;
            }
            catch (IOException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577409) + ": I/O error during read: " + ex.toString(), 1330577409, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577409) + ": NullPointerException during read", 1330577409, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public boolean receive_timeout_detect(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            return this.receive_detect(buf, false);
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                int result = this.in_.read(buf.data(), buf.pos(), buf.rest_length());
                if (result <= 0) {
                    return false;
                }
                buf.advance(result);
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    public void send(Buffer buf, boolean block) {
        this.setBlock(block);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                if (block) continue;
                return;
            }
            catch (IOException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577410) + ": I/O error during write: " + ex.toString(), 1330577410, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577410) + ": NullPointerException during write", 1330577410, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public boolean send_detect(Buffer buf, boolean block) {
        this.setBlock(block);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                if (block) continue;
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    public void send_timeout(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            this.send(buf, false);
            return;
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return;
            }
            catch (IOException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577410) + ": I/O error during write: " + ex.toString(), 1330577410, CompletionStatus.COMPLETED_NO);
            }
            catch (NullPointerException ex) {
                throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577410) + ": NullPointerException during write", 1330577410, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public boolean send_timeout_detect(Buffer buf, int t) {
        if (t < 0) {
            throw new InternalError();
        }
        if (t == 0) {
            return this.send_detect(buf, false);
        }
        this.setSoTimeout(t);
        while (!buf.is_full()) {
            try {
                this.out_.write(buf.data(), buf.pos(), buf.rest_length());
                this.out_.flush();
                buf.pos(buf.length());
            }
            catch (InterruptedIOException ex) {
                buf.advance(ex.bytesTransferred);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
            catch (NullPointerException ex) {
                return false;
            }
        }
        return true;
    }

    public TransportInfo get_info() {
        return this.info_;
    }

    public Transport_impl(Connector connector, Socket socket) {
        this.socket_ = socket;
        this.shutdown_ = false;
        try {
            this.in_ = this.socket_.getInputStream();
            this.out_ = this.socket_.getOutputStream();
        }
        catch (IOException ex) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577413) + ": unable to obtain socket InputStream: " + ex.toString(), 1330577413, CompletionStatus.COMPLETED_NO);
        }
        this.info_ = new TransportInfo_impl(this, connector);
    }

    public Transport_impl(Acceptor acceptor, Socket socket) {
        this.socket_ = socket;
        this.shutdown_ = false;
        try {
            this.in_ = this.socket_.getInputStream();
            this.out_ = this.socket_.getOutputStream();
        }
        catch (IOException ex) {
            throw new COMM_FAILURE(MinorCodes.describeCommFailure(1330577413) + ": unable to obtain socket InputStream: " + ex.toString(), 1330577413, CompletionStatus.COMPLETED_NO);
        }
        this.info_ = new TransportInfo_impl(this, acceptor);
    }

    public void finalize() throws Throwable {
        if (this.socket_ != null) {
            this.close();
        }
        super.finalize();
    }
}

