/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Unsigned;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.omg.CORBA.BAD_PARAM;
import org.omg.TimeBase.IntervalT;
import org.omg.TimeBase.UtcT;

public class TimeHelper {
    private static final long HNanosPerMilli = 10000L;
    private static final long DCEToPosix = 122192928000000000L;
    public static final long MaxTimeT = -1L;
    public static final long MaxInaccuracyT = 0xFFFFFFFFFFFFL;

    public static UtcT utcNow(long inaccuracy) {
        if (Unsigned.gt(inaccuracy, 0xFFFFFFFFFFFFL)) {
            throw new BAD_PARAM();
        }
        long time = Unsigned.add(Unsigned.multiply(System.currentTimeMillis(), 10000L), 122192928000000000L);
        Calendar cal = Calendar.getInstance();
        int offset = cal.get(15) + cal.get(16);
        return TimeHelper.toUtcT(time, inaccuracy, (short)(offset / 60000));
    }

    public static UtcT utcMin() {
        Calendar cal = Calendar.getInstance();
        int offset = cal.get(15) + cal.get(16);
        return TimeHelper.toUtcT(0L, 0L, (short)(offset / 60000));
    }

    public static UtcT utcMax() {
        Calendar cal = Calendar.getInstance();
        int offset = cal.get(15) + cal.get(16);
        return TimeHelper.toUtcT(-1L, 0L, (short)(offset / 60000));
    }

    public static long toJavaMillis(UtcT utc) {
        return TimeHelper.toJavaMillis(utc.time);
    }

    public static long toJavaMillis(long time) {
        if (Unsigned.lt(time, 122192928000000000L)) {
            return 0L;
        }
        return Unsigned.divide(Unsigned.subtract(time, 122192928000000000L), 10000L);
    }

    public static IntervalT toIntervalT(long time, long inaccuracy) {
        IntervalT inter = new IntervalT();
        inter.lower_bound = Unsigned.lt(time, inaccuracy) ? 0L : Unsigned.subtract(time, inaccuracy);
        inter.upper_bound = Unsigned.lt(Unsigned.subtract(-1L, time), inaccuracy) ? -1L : Unsigned.add(time, inaccuracy);
        return inter;
    }

    public static UtcT toUtcT(long time, long inaccuracy, short tdf) {
        UtcT utc = new UtcT();
        utc.time = time;
        utc.tdf = tdf;
        utc.inacclo = (int)(inaccuracy & 0xFFFFFFFFL);
        utc.inacchi = (short)(inaccuracy >> 32 & 0xFFFFL);
        return utc;
    }

    public static UtcT toUtcT(long time, long inaccuracy) {
        return TimeHelper.toUtcT(time, inaccuracy, (short)0);
    }

    public static UtcT toUtcT(IntervalT inter) {
        long inaccuracy = Unsigned.divide(Unsigned.subtract(inter.upper_bound, inter.lower_bound), 2L);
        long time = Unsigned.add(inter.lower_bound, inaccuracy);
        return TimeHelper.toUtcT(time, inaccuracy);
    }

    public static String toString(UtcT time) {
        if (Unsigned.lt(time.time, 122192928000000000L)) {
            return "Time less than 1 January 1970 00:00:00";
        }
        long milliTime = Unsigned.add(TimeHelper.toJavaMillis(time), time.tdf * 60000);
        SimpleDateFormat date = new SimpleDateFormat("MM/dd/yy HH:mm:ss:SSS");
        date.setTimeZone(TimeZone.getTimeZone("GMT"));
        return date.format(new Date(milliTime));
    }

    public static String toTimeString(UtcT time) {
        if (Unsigned.lt(time.time, 122192928000000000L)) {
            return "Time less than 1 January 1970 00:00:00";
        }
        long milliTime = Unsigned.add(TimeHelper.toJavaMillis(time), time.tdf * 60000);
        SimpleDateFormat date = new SimpleDateFormat("HH:mm:ss:SSS");
        date.setTimeZone(TimeZone.getTimeZone("GMT"));
        return date.format(new Date(milliTime));
    }

    public static String toString(long time) {
        long milliTime = Unsigned.divide(time, 10000L);
        long sec = Unsigned.divide(milliTime, 1000L);
        long msec = Unsigned.mod(milliTime, 1000L);
        String ret = Long.toString(sec) + ":";
        if (msec < 10L) {
            ret = ret + "00";
        } else if (msec < 100L) {
            ret = ret + "0";
        }
        ret = ret + Long.toString(msec);
        return ret;
    }

    public static boolean lessThan(UtcT a, UtcT b) {
        return Unsigned.lt(a.time, b.time);
    }

    public static boolean lessThanEqual(UtcT a, UtcT b) {
        return Unsigned.lteq(a.time, b.time);
    }

    public static boolean greaterThan(UtcT a, UtcT b) {
        return Unsigned.gt(a.time, b.time);
    }

    public static boolean greaterThanEqual(UtcT a, UtcT b) {
        return Unsigned.gteq(a.time, b.time);
    }

    public static boolean equal(UtcT a, UtcT b) {
        return a.time == b.time;
    }

    public static boolean notEqual(UtcT a, UtcT b) {
        return a.time != b.time;
    }

    public static UtcT add(UtcT a, long t) {
        UtcT b = new UtcT(a.time, a.inacclo, a.inacchi, a.tdf);
        b.time = Unsigned.lt(Unsigned.subtract(-1L, b.time), t) ? -1L : Unsigned.add(b.time, t);
        return b;
    }

    public static UtcT add(long t, UtcT a) {
        return TimeHelper.add(a, t);
    }

    public static UtcT subtract(UtcT a, long t) {
        UtcT b = new UtcT(a.time, a.inacclo, a.inacchi, a.tdf);
        b.time = Unsigned.lt(b.time, t) ? 0L : Unsigned.subtract(b.time, t);
        return b;
    }
}

