/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.OB.CodeSetDatabase;
import com.ooc.OB.CodeSetInfo;
import com.ooc.OCI.Buffer;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.IOP.TaggedComponent;

public final class IORUtil {
    private static String describeCodeSets(TaggedComponent component) {
        int i;
        String result = "";
        byte[] coct = component.component_data;
        int len = component.component_data.length;
        Buffer buf = new Buffer(coct, len);
        InputStream in = new InputStream(buf, 0, false);
        in._OB_readEndian();
        CodeSetComponentInfo info = CodeSetComponentInfoHelper.read(in);
        CodeSetDatabase db = CodeSetDatabase.instance();
        result = result + "Native char codeset: \n";
        CodeSetInfo charInfo = db.getCodeSetInfo(info.ForCharData.native_code_set);
        if (charInfo != null) {
            result = result + "  \"";
            result = result + charInfo.description;
            result = result + "\"\n";
        } else if (info.ForCharData.native_code_set == 0) {
            result = result + "  [No codeset information]\n";
        } else {
            result = result + "  [Unknown codeset id: ";
            result = result + info.ForCharData.native_code_set;
            result = result + "]\n";
        }
        for (i = 0; i < info.ForCharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                result = result + "Char conversion codesets:\n";
            }
            if ((charInfo = db.getCodeSetInfo(info.ForCharData.conversion_code_sets[i])) != null) {
                result = result + "  \"";
                result = result + charInfo.description;
                result = result + "\"\n";
                continue;
            }
            result = result + "  [Unknown codeset id: ";
            result = result + info.ForCharData.conversion_code_sets[i];
            result = result + "]\n";
        }
        result = result + "Native wchar codeset: \n";
        charInfo = db.getCodeSetInfo(info.ForWcharData.native_code_set);
        if (charInfo != null) {
            result = result + "  \"";
            result = result + charInfo.description;
            result = result + "\"\n";
        } else if (info.ForWcharData.native_code_set == 0) {
            result = result + "  [No codeset information]\n";
        } else {
            result = result + "  [Unknown codeset id: ";
            result = result + info.ForWcharData.native_code_set;
            result = result + "]\n";
        }
        for (i = 0; i < info.ForWcharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                result = result + "Wchar conversion codesets:\n";
            }
            if ((charInfo = db.getCodeSetInfo(info.ForWcharData.conversion_code_sets[i])) != null) {
                result = result + "  \"";
                result = result + charInfo.description;
                result = result + "\"\n";
                continue;
            }
            result = result + "  [Unknown codeset id: ";
            result = result + info.ForWcharData.conversion_code_sets[i];
            result = result + "]\n";
        }
        return result;
    }

    private static String describeGenericComponent(TaggedComponent component, String name) {
        String result = "Component: ";
        result = result + name;
        result = result + '\n';
        result = result + "Component data: (";
        result = result + component.component_data.length;
        result = result + ")\n";
        String data = IORUtil.dump_octets(component.component_data, 0, component.component_data.length);
        result = result + data;
        return result;
    }

    public static String dump_octets(byte[] oct, int offset, int count) {
        int inc = 8;
        StringBuffer result = new StringBuffer((count - offset) * 8);
        for (int i = offset; i < offset + count; i += 8) {
            int j = i;
            while (j - i < 8) {
                if (j < offset + count) {
                    int n = oct[j];
                    if (n < 0) {
                        n += 256;
                    }
                    if (n < 10) {
                        result.append("  ");
                    } else if (n < 100) {
                        result.append(' ');
                    }
                    result.append(n);
                    result.append(' ');
                } else {
                    result.append("    ");
                }
                ++j;
            }
            result.append('\"');
            for (j = i; j < offset + count && j - i < 8; ++j) {
                if (oct[j] >= 32 && oct[j] < 127) {
                    result.append((char)oct[j]);
                    continue;
                }
                result.append('.');
            }
            result.append('\"');
            result.append('\n');
        }
        return result.toString();
    }

    public static String describe_component(TaggedComponent component) {
        String result;
        switch (component.tag) {
            case 0: {
                byte[] coct = component.component_data;
                int len = component.component_data.length;
                Buffer buf = new Buffer(coct, len);
                InputStream in = new InputStream(buf, 0, false);
                in._OB_readEndian();
                int id = in.read_ulong();
                result = "Component: TAG_ORB_TYPE = ";
                result = result + "0x";
                result = result + Integer.toHexString(id);
                result = result + '\n';
                break;
            }
            case 1: {
                result = IORUtil.describeCodeSets(component);
                break;
            }
            case 2: {
                result = IORUtil.describeGenericComponent(component, "TAG_POLICIES");
                break;
            }
            case 3: {
                byte[] coct = component.component_data;
                int len = component.component_data.length;
                Buffer buf = new Buffer(coct, len);
                InputStream in = new InputStream(buf, 0, false);
                in._OB_readEndian();
                String host = in.read_string();
                int port = in.read_ushort();
                result = "Alternate IIOP address:\n";
                result = result + "  host: ";
                result = result + host;
                result = result + '\n';
                result = result + "  port: ";
                result = result + (port < 0 ? 65535 + port + 1 : port);
                result = result + '\n';
                break;
            }
            case 13: {
                result = IORUtil.describeGenericComponent(component, "TAG_ASSOCIATION_OPTIONS");
                break;
            }
            case 14: {
                result = IORUtil.describeGenericComponent(component, "TAG_SEC_NAME");
                break;
            }
            case 15: {
                result = IORUtil.describeGenericComponent(component, "TAG_SPKM_1_SEC_MECH");
                break;
            }
            case 16: {
                result = IORUtil.describeGenericComponent(component, "TAG_SPKM_2_SEC_MECH");
                break;
            }
            case 17: {
                result = IORUtil.describeGenericComponent(component, "TAG_KerberosV5_SEC_MECH");
                break;
            }
            case 18: {
                result = IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Secret_SEC_MECH");
                break;
            }
            case 19: {
                result = IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Hybrid_SEC_MECH");
                break;
            }
            case 20: {
                result = IORUtil.describeGenericComponent(component, "TAG_SSL_SEC_TRANS");
                break;
            }
            case 21: {
                result = IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Public_SEC_MECH");
                break;
            }
            case 22: {
                result = IORUtil.describeGenericComponent(component, "TAG_GENERIC_SEC_MECH");
                break;
            }
            case 25: {
                byte[] coct = component.component_data;
                int len = component.component_data.length;
                Buffer buf = new Buffer(coct, len);
                InputStream in = new InputStream(buf, 0, false);
                in._OB_readEndian();
                String codebase = in.read_string();
                result = "Component: TAG_JAVA_CODEBASE = `";
                result = result + codebase;
                result = result + "'\n";
                break;
            }
            case 5: {
                result = IORUtil.describeGenericComponent(component, "TAG_COMPLETE_OBJECT_KEY");
                break;
            }
            case 6: {
                result = IORUtil.describeGenericComponent(component, "TAG_ENDPOINT_ID_POSITION");
                break;
            }
            case 12: {
                result = IORUtil.describeGenericComponent(component, "TAG_LOCATION_POLICY");
                break;
            }
            case 100: {
                result = IORUtil.describeGenericComponent(component, "TAG_DCE_STRING_BINDING");
                break;
            }
            case 101: {
                result = IORUtil.describeGenericComponent(component, "TAG_DCE_BINDING_NAME");
                break;
            }
            case 102: {
                result = IORUtil.describeGenericComponent(component, "TAG_DCE_NO_PIPES");
                break;
            }
            case 103: {
                result = IORUtil.describeGenericComponent(component, "TAG_DCE_SEC_MECH");
                break;
            }
            default: {
                String name = "unknown (tag = ";
                name = name + component.tag;
                name = name + ")";
                result = IORUtil.describeGenericComponent(component, name);
                break;
            }
        }
        return result;
    }
}

