/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.Downcall;
import com.ooc.OB.DowncallEmitter;
import com.ooc.OB.GIOPClient;
import com.ooc.OB.GIOPIncomingMessage;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.Logger;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Util;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.SystemExceptionHelper;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.LocateStatusType_1_2Holder;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2Holder;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContextListHolder;

abstract class GIOPClientWorker
implements DowncallEmitter {
    protected ORBInstance orbInstance_;
    protected GIOPClient client_;
    protected Transport transport_;
    protected Buffer buf_;
    protected GIOPIncomingMessage incoming_;
    protected boolean messageSent_;
    protected byte minor_;
    protected boolean closeLogged_;
    protected int shutdownTimeout_;
    protected Vector unsent_ = new Vector();
    protected Vector pending_ = new Vector();
    public static final int StateActive = 0;
    public static final int StateClosing = 1;
    public static final int StateError = 2;
    public static final int StateClosed = 4;
    protected int state_;
    protected SystemException exception_;

    protected void logCloseConnection() {
        if (!this.closeLogged_) {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                TransportInfo info = this.transport_.get_info();
                String msg = "closing connection\n";
                msg = msg + info.describe();
                this.orbInstance_.getLogger().trace("outgoing", msg);
            }
            this.closeLogged_ = true;
        }
    }

    protected void addMessageHeader(Downcall down) {
        OutputStream out = down.output();
        int pos = out._OB_pos();
        out._OB_pos(0);
        ProfileInfo profileInfo = down.profileInfo();
        GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
        outgoing.writeMessageHeader(MsgType_1_1.Request, false, pos - 12);
        out._OB_pos(pos);
    }

    protected void add(Buffer buf) {
        if (this.state_ == 2 || this.state_ == 4) {
            return;
        }
        this.unsent_.addElement(new UnsentMessage(buf));
    }

    protected void add(Downcall down) {
        if (this.exception_ != null) {
            down.setFailureException(this.exception_);
            return;
        }
        Assert._OB_assert(this.state_ != 1 && this.state_ != 2 && this.state_ != 4);
        try {
            OutputStream out = down.output();
            int pos = out._OB_pos();
            out._OB_pos(0);
            ProfileInfo profileInfo = down.profileInfo();
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
            String op = down.operation();
            if (op.charAt(0) == '_' && op.equals("_locate")) {
                outgoing.writeMessageHeader(MsgType_1_1.LocateRequest, false, pos - 12);
            } else {
                outgoing.writeMessageHeader(MsgType_1_1.Request, false, pos - 12);
            }
            out._OB_pos(pos);
        }
        catch (SystemException ex) {
            Assert._OB_assert(ex.completed == CompletionStatus.COMPLETED_NO);
            down.setFailureException(ex);
            return;
        }
        byte minor = down.profileInfo().minor;
        if (minor > this.minor_) {
            this.minor_ = minor;
        }
        this.unsent_.addElement(new UnsentMessage(down));
    }

    protected Downcall moveFirstUnsentToPending() {
        if (this.unsent_.isEmpty()) {
            Assert._OB_assert(this.exception_ != null);
            return null;
        }
        UnsentMessage m = (UnsentMessage)this.unsent_.firstElement();
        Downcall down = m.down;
        this.unsent_.removeElementAt(0);
        if (down != null) {
            if (down.responseExpected()) {
                down.setPending();
                this.pending_.addElement(down);
            } else {
                down.setNoException(null);
            }
        }
        if (!this.messageSent_ && !down.operation().equals("_locate")) {
            this.messageSent_ = true;
        }
        return down;
    }

    protected void movePendingToUnsent(Downcall down) {
        if (down.responseExpected()) {
            Downcall d = this.findAndRemovePending(down.requestId());
            Assert._OB_assert(d == null || d == down);
            this.unsent_.addElement(new UnsentMessage(down));
        }
    }

    protected Downcall findAndRemovePending(int reqId) {
        for (int i = 0; i < this.pending_.size(); ++i) {
            Downcall d = (Downcall)this.pending_.elementAt(i);
            if (d.requestId() != reqId) continue;
            this.pending_.removeElementAt(i);
            return d;
        }
        return null;
    }

    protected boolean exception(int state, SystemException ex, boolean notCompleted) {
        if (this.state_ == state) {
            return false;
        }
        if (state < this.state_) {
            return false;
        }
        if (this.exception_ == null) {
            this.exception_ = Util.copySystemException(ex);
            this.exception_.completed = CompletionStatus.COMPLETED_NO;
            while (!this.unsent_.isEmpty()) {
                UnsentMessage m = (UnsentMessage)this.unsent_.firstElement();
                if (m.down != null) {
                    m.down.setFailureException(this.exception_);
                }
                this.unsent_.removeElementAt(0);
            }
            SystemException except = Util.copySystemException(this.exception_);
            if (!notCompleted) {
                except.completed = CompletionStatus.COMPLETED_MAYBE;
            }
            while (!this.pending_.isEmpty()) {
                Downcall down = (Downcall)this.pending_.firstElement();
                down.setFailureException(except);
                this.pending_.removeElementAt(0);
            }
        }
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                this.client_.removeWorker(this);
                break;
            }
            case 2: {
                this.client_.removeWorker(this);
                this.abortiveShutdown();
                break;
            }
            case 4: {
                this.client_.removeWorker(this);
                this.logCloseConnection();
                this.transport_.close();
            }
        }
        this.state_ = state;
        if (this.state_ == 1) {
            this.gracefulShutdown();
        }
        return true;
    }

    protected final void exception(int state, SystemException ex) {
        this.exception(state, ex, false);
    }

    protected abstract void gracefulShutdown();

    protected abstract void abortiveShutdown();

    protected void execute() {
        boolean complete;
        Assert._OB_assert(this.state_ == 0 || this.state_ == 1);
        try {
            Buffer buf = this.buf_;
            this.buf_ = null;
            complete = this.incoming_.consumeBuffer(buf);
        }
        catch (SystemException ex) {
            this.exception(2, ex);
            return;
        }
        byte minor = this.incoming_.version().minor;
        if (minor > this.minor_) {
            this.minor_ = minor;
        }
        if (!complete) {
            return;
        }
        block9 : switch (this.incoming_.type().value()) {
            case 1: {
                int reqId = 0;
                ReplyStatusType_1_2Holder status = new ReplyStatusType_1_2Holder();
                ServiceContextListHolder scl = new ServiceContextListHolder();
                try {
                    reqId = this.incoming_.readReplyHeader(status, scl);
                }
                catch (SystemException ex) {
                    this.exception(2, ex);
                    return;
                }
                Downcall down = this.findAndRemovePending(reqId);
                if (down == null) {
                    this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577432) + ": " + reqId, 1330577432, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                down.setReplySCL(scl.value);
                InputStream in = this.incoming_.input();
                switch (status.value.value()) {
                    case 0: {
                        down.setNoException(in);
                        break block9;
                    }
                    case 1: {
                        down.setUserException(in);
                        break block9;
                    }
                    case 2: {
                        try {
                            SystemException ex = Util.unmarshalSystemException(in);
                            down.setSystemException(ex);
                        }
                        catch (SystemException ex) {
                            this.exception(2, ex);
                        }
                        break block9;
                    }
                    case 3: {
                        try {
                            IOR ior = IORHelper.read(in);
                            down.setLocationForward(ior, false);
                        }
                        catch (SystemException ex) {
                            this.exception(2, ex);
                        }
                        break block9;
                    }
                    case 4: {
                        try {
                            IOR ior = IORHelper.read(in);
                            down.setLocationForward(ior, true);
                            break block9;
                        }
                        catch (SystemException ex) {
                            this.exception(2, ex);
                        }
                    }
                    case 5: {
                        this.exception(2, new NO_IMPLEMENT(MinorCodes.describeNoImplement(1330446339), 1330446339, CompletionStatus.COMPLETED_NO));
                        break block9;
                    }
                }
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577437), 1330577437, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 4: {
                int reqId;
                LocateStatusType_1_2Holder status = new LocateStatusType_1_2Holder();
                try {
                    reqId = this.incoming_.readLocateReplyHeader(status);
                }
                catch (SystemException ex) {
                    this.exception(2, ex);
                    return;
                }
                Downcall down = this.findAndRemovePending(reqId);
                if (down == null) {
                    this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577432), 1330577432, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                String op = down.operation();
                if (!op.equals("_locate")) {
                    this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577427), 1330577427, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                InputStream in = this.incoming_.input();
                switch (status.value.value()) {
                    case 0: {
                        down.setSystemException(new OBJECT_NOT_EXIST());
                        break;
                    }
                    case 1: {
                        down.setNoException(in);
                        break;
                    }
                    case 2: {
                        try {
                            IOR ior = IORHelper.read(in);
                            down.setLocationForward(ior, false);
                        }
                        catch (SystemException ex) {
                            Logger logger = this.orbInstance_.getLogger();
                            logger.warning("An error occurred while reading a locate reply, possibly indicating\nan interoperability problem. You may need to set the LocateRequestPolicy\nto false.");
                            down.setSystemException(ex);
                            this.exception(2, ex);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            IOR ior = IORHelper.read(in);
                            down.setLocationForward(ior, true);
                        }
                        catch (SystemException ex) {
                            Logger logger = this.orbInstance_.getLogger();
                            logger.warning("An error occurred while reading a locate reply, possibly indicating\nan interoperability problem. You may need to set the LocateRequestPolicy\nto false.");
                            down.setSystemException(ex);
                            this.exception(2, ex);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            SystemException ex = SystemExceptionHelper.read(in);
                            down.setSystemException(ex);
                        }
                        catch (SystemException ex) {
                            down.setSystemException(ex);
                            this.exception(2, ex);
                        }
                        break;
                    }
                    case 5: {
                        this.exception(2, new NO_IMPLEMENT());
                    }
                }
                break;
            }
            case 5: {
                this.exception(4, new TRANSIENT(MinorCodes.describeTransient(1330577410), 1330577410, CompletionStatus.COMPLETED_NO), true);
                break;
            }
            case 6: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577429), 1330577429, CompletionStatus.COMPLETED_NO));
                break;
            }
            case 7: {
                Assert._OB_assert(false);
                break;
            }
            default: {
                this.exception(2, new COMM_FAILURE(MinorCodes.describeCommFailure(1330577426), 1330577426, CompletionStatus.COMPLETED_MAYBE));
            }
        }
    }

    protected void finalize() throws Throwable {
        Assert._OB_assert(this.state_ == 4);
        super.finalize();
    }

    GIOPClientWorker(ORBInstance orbInstance, GIOPClient client, Transport transport) {
        this.orbInstance_ = orbInstance;
        this.client_ = client;
        this.transport_ = transport;
        this.incoming_ = new GIOPIncomingMessage(this.orbInstance_);
        this.messageSent_ = false;
        this.minor_ = 0;
        this.closeLogged_ = false;
        this.state_ = 0;
        Properties properties = this.orbInstance_.getProperties();
        String value = properties.getProperty("ooc.orb.client_shutdown_timeout");
        this.shutdownTimeout_ = value != null ? Integer.parseInt(value) : 2;
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            TransportInfo info = this.transport_.get_info();
            String msg = "new connection\n";
            msg = msg + info.describe();
            this.orbInstance_.getLogger().trace("outgoing", msg);
        }
    }

    abstract void destroy();

    final Transport transport() {
        return this.transport_;
    }

    final boolean messageSent() {
        return this.messageSent_;
    }

    protected class UnsentMessage {
        Buffer buf;
        Downcall down;

        UnsentMessage(Buffer buf) {
            this.buf = buf;
            this.buf.pos(0);
        }

        UnsentMessage(Downcall down) {
            this.down = down;
            this.buf = down.output()._OB_buffer();
            this.buf.pos(0);
        }
    }
}

