/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.CORBANameParser;
import com.ooc.OB.CorbalocURLScheme;
import com.ooc.OB.CorbalocURLSchemeHelper;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.TypeCodeFactory;
import com.ooc.OB.URLRegistry;
import com.ooc.OB.URLScheme;
import com.ooc.OB.URLUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;

public class CorbanameURLScheme_impl
extends LocalObject
implements URLScheme {
    private ORB orb_;
    private CorbalocURLScheme corbaloc_;

    public CorbanameURLScheme_impl(ORB orb, URLRegistry registry) {
        this.orb_ = orb;
        URLScheme scheme = registry.find_scheme("corbaloc");
        Assert._OB_assert(scheme != null);
        this.corbaloc_ = CorbalocURLSchemeHelper.narrow(scheme);
        Assert._OB_assert(this.corbaloc_ != null);
    }

    public String name() {
        return "corbaname";
    }

    public Object parse_url(String url) {
        int slash = url.indexOf(47);
        int fragmentStart = url.indexOf(35);
        String keyStr = slash != -1 && fragmentStart == -1 ? url.substring(slash + 1) : (slash == -1 || fragmentStart - 1 == slash || fragmentStart < slash ? "NameService" : url.substring(slash + 1, fragmentStart));
        int addrStart = 10;
        if (addrStart == slash) {
            throw new BAD_PARAM(MinorCodes.describeBadParam(1330446344) + ": no protocol address", 1330446344, CompletionStatus.COMPLETED_NO);
        }
        int addrEnd = slash == -1 && fragmentStart == -1 ? url.length() - 1 : (slash != -1 && fragmentStart == -1 || slash != -1 && fragmentStart != -1 && slash < fragmentStart ? slash - 1 : fragmentStart - 1);
        String corbaloc = "corbaloc:" + url.substring(addrStart, addrEnd + 1) + "/" + keyStr;
        Object nc = this.corbaloc_.parse_url(corbaloc);
        if (fragmentStart == -1 || url.substring(fragmentStart).length() == 0) {
            return nc;
        }
        try {
            StructMember[] contents = new StructMember[2];
            contents[0] = new StructMember();
            contents[0].name = "id";
            contents[0].type = TypeCodeFactory.createStringTC(0);
            contents[1] = new StructMember();
            contents[1].name = "kind";
            contents[1].type = TypeCodeFactory.createStringTC(0);
            TypeCode tcNameComponent = TypeCodeFactory.createStructTC("IDL:omg.org/CosNaming/NameComponent:1.0", "NameComponent", contents);
            TypeCode tcName = TypeCodeFactory.createSequenceTC(0, tcNameComponent);
            String fragment = URLUtil.unescapeURL(url.substring(fragmentStart + 1));
            CORBANameParser parser = new CORBANameParser(fragment);
            if (!parser.isValid()) {
                throw new BAD_PARAM(MinorCodes.describeBadParam(1330446345) + ": invalid stringified name", 1330446345, CompletionStatus.COMPLETED_NO);
            }
            String[] content = parser.getContents();
            Assert._OB_assert(content.length % 2 == 0);
            Object factoryObj = this.orb_.resolve_initial_references("DynAnyFactory");
            DynAnyFactory dynAnyFactory = DynAnyFactoryHelper.narrow(factoryObj);
            Any[] as = new Any[content.length / 2];
            for (int i = 0; i < content.length; i += 2) {
                DynAny dynAny = dynAnyFactory.create_dyn_any_from_type_code(tcNameComponent);
                DynStruct name = DynStructHelper.narrow(dynAny);
                name.insert_string(content[i]);
                name.next();
                name.insert_string(content[i + 1]);
                Any nany = name.to_any();
                name.destroy();
                as[i / 2] = nany;
            }
            DynAny dynAny = dynAnyFactory.create_dyn_any_from_type_code(tcName);
            DynSequence seq = DynSequenceHelper.narrow(dynAny);
            seq.set_length(as.length);
            seq.set_elements(as);
            Any any = seq.to_any();
            seq.destroy();
            Request request = nc._request("resolve");
            Any arg = request.add_in_arg();
            arg.read_value(any.create_input_stream(), any.type());
            request.set_return_type(TypeCodeFactory.createPrimitiveTC(TCKind.tk_objref));
            request.invoke();
            if (request.env().exception() == null) {
                return request.return_value().extract_Object();
            }
        }
        catch (SystemException ex) {
        }
        catch (UserException ex) {
            // empty catch block
        }
        throw new BAD_PARAM(MinorCodes.describeBadParam(1330446346) + ": corbaname evaluation error", 1330446346, CompletionStatus.COMPLETED_NO);
    }

    public void destroy() {
        this.orb_ = null;
    }
}

