/*
 * Decompiled with CFR 0.152.
 */
package test.poa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.AdapterActivatorPOA;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantActivatorPOA;
import org.omg.PortableServer.ServantManager;
import test.common.TestBase;
import test.poa.TestHelper;
import test.poa.TestInfo;
import test.poa.TestServer;
import test.poa.TestServer_impl;
import test.poa.TestUtil;
import test.poa.Test_impl;

final class TestAdapterActivatorServer
extends TestBase {
    TestAdapterActivatorServer() {
    }

    static POA createTestPOA(POA parent, String name) {
        POAManager mgr = parent.the_POAManager();
        Policy[] policies = new Policy[]{parent.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), parent.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), parent.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
        try {
            return parent.create_POA(name, mgr, policies);
        }
        catch (AdapterAlreadyExists ex) {
            TestAdapterActivatorServer.TEST(false);
        }
        catch (InvalidPolicy ex) {
            TestAdapterActivatorServer.TEST(false);
        }
        return null;
    }

    static void TestAdapterActivator(ORB orb, POA root) {
        POAManager rootMgr = root.the_POAManager();
        TestAdapterActivatorServer.TEST(rootMgr != null);
        TestAdapterActivator_impl activatorImpl = new TestAdapterActivator_impl();
        AdapterActivator activator = activatorImpl._this(orb);
        root.the_activator(activator);
        activatorImpl.reset("poa1", true);
        POA poa = null;
        try {
            poa = root.find_POA("poa1", true);
        }
        catch (AdapterNonExistent ex) {
            TestAdapterActivatorServer.TEST(false);
        }
        TestAdapterActivatorServer.TEST(poa != null);
        TestAdapterActivatorServer.TEST(activatorImpl.invoked());
        String str = poa.the_name();
        TestAdapterActivatorServer.TEST(str.equals("poa1"));
        POA parent = poa.the_parent();
        TestAdapterActivatorServer.TEST(parent != null);
        TestAdapterActivatorServer.TEST(parent._is_equivalent((Object)root));
        activatorImpl.reset("poa2", false);
        try {
            root.find_POA("poa2", true);
        }
        catch (AdapterNonExistent ex) {
            // empty catch block
        }
        TestAdapterActivatorServer.TEST(activatorImpl.invoked());
        activatorImpl.reset("poa1", true);
        try {
            poa = root.find_POA("poa1", true);
        }
        catch (AdapterNonExistent ex) {
            TestAdapterActivatorServer.TEST(false);
        }
        TestAdapterActivatorServer.TEST(!activatorImpl.invoked());
        root.the_activator(null);
        activatorImpl.reset("poa2", false);
        try {
            root.find_POA("poa2", true);
        }
        catch (AdapterNonExistent ex) {
            // empty catch block
        }
        TestAdapterActivatorServer.TEST(!activatorImpl.invoked());
        poa.destroy(true, true);
        try {
            byte[] id = root.servant_to_id((Servant)activatorImpl);
            root.deactivate_object(id);
        }
        catch (ServantNotActive ex) {
            TestAdapterActivatorServer.TEST(false);
        }
        catch (ObjectNotActive ex) {
            TestAdapterActivatorServer.TEST(false);
        }
        catch (WrongPolicy ex) {
            TestAdapterActivatorServer.TEST(false);
        }
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            POA root = TestUtil.GetRootPOA(orb);
            POAManager manager = root.the_POAManager();
            TestAdapterActivatorServer.TEST(manager != null);
            try {
                manager.activate();
            }
            catch (AdapterInactive ex) {
                TestAdapterActivatorServer.TEST(false);
            }
            TestAdapterActivatorServer.TestAdapterActivator(orb, root);
            POA poa3 = TestAdapterActivatorServer.createTestPOA(root, "poa3");
            POA poa4 = TestAdapterActivatorServer.createTestPOA(poa3, "poa4");
            byte[] oid = "test".getBytes();
            Object reference1 = null;
            reference1 = poa4.create_reference_with_id(oid, "IDL:Test:1.0");
            poa4.destroy(true, true);
            poa4 = null;
            poa3.destroy(true, true);
            poa3 = null;
            TestInfo[] info = new TestInfo[]{new TestInfo()};
            info[0].obj = TestHelper.narrow(reference1);
            info[0].except_id = "";
            TestServer_impl serverImpl = new TestServer_impl(orb, info);
            TestServer server = serverImpl._this(orb);
            String refFile = "Test.ref";
            try {
                FileOutputStream file = new FileOutputStream(refFile);
                PrintWriter out = new PrintWriter(file);
                out.println(orb.object_to_string((Object)server));
                out.flush();
                file.close();
            }
            catch (IOException ex) {
                System.err.println("Can't write to `" + ex.getMessage() + "'");
                System.exit(1);
            }
            TestRemoteAdapterActivator_impl activatorImpl = new TestRemoteAdapterActivator_impl(orb, root);
            AdapterActivator activator = activatorImpl._this(orb);
            root.the_activator(activator);
            orb.run();
            File file = new File(refFile);
            file.delete();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }

    static final class TestRemoteAdapterActivator_impl
    extends AdapterActivatorPOA {
        private ORB orb_;
        private POA root_;
        private TestServantActivator_impl activator_;

        TestRemoteAdapterActivator_impl(ORB orb, POA root) {
            this.orb_ = orb;
            this.root_ = root;
            this.activator_ = new TestServantActivator_impl(this.orb_);
            this.activator_._this(this.orb_);
        }

        public boolean unknown_adapter(POA parent, String name) {
            if (name.equals("poa3") || name.equals("poa4")) {
                POA poa = TestAdapterActivatorServer.createTestPOA(parent, name);
                ServantActivator activator = this.activator_._this();
                if (name.equals("poa3")) {
                    AdapterActivator me = this._this(this.orb_);
                    poa.the_activator(me);
                } else {
                    try {
                        poa.set_servant_manager((ServantManager)activator);
                    }
                    catch (WrongPolicy ex) {
                        TestBase.TEST(false);
                    }
                }
                return true;
            }
            return false;
        }
    }

    static final class TestServantActivator_impl
    extends ServantActivatorPOA {
        private ORB orb_;

        TestServantActivator_impl(ORB orb) {
            this.orb_ = orb;
        }

        public Servant incarnate(byte[] oid, POA poa) throws ForwardRequest {
            String oidString = new String(oid);
            Test_impl servant = null;
            if (oidString.equals("test")) {
                servant = new Test_impl(this.orb_, "test", false);
            }
            if (servant != null) {
                try {
                    poa.activate_object_with_id(oid, servant);
                    return servant;
                }
                catch (ObjectAlreadyActive ex) {
                    TestBase.TEST(false);
                }
                catch (ServantAlreadyActive ex) {
                    TestBase.TEST(false);
                }
                catch (WrongPolicy ex) {
                    TestBase.TEST(false);
                }
            }
            throw new OBJECT_NOT_EXIST();
        }

        public void etherealize(byte[] oid, POA poa, Servant servant, boolean cleanup, boolean remaining) {
            String oidString;
            if (!remaining && (oidString = new String(oid)).equals("test")) {
                servant = null;
            }
        }
    }

    static final class TestAdapterActivator_impl
    extends AdapterActivatorPOA {
        private String expectedName_;
        private boolean create_ = false;
        private boolean invoked_ = false;

        TestAdapterActivator_impl() {
        }

        void reset(String name, boolean create) {
            this.expectedName_ = name;
            this.create_ = create;
            this.invoked_ = false;
        }

        boolean invoked() {
            return this.invoked_;
        }

        public boolean unknown_adapter(POA parent, String name) {
            TestBase.TEST(name.equals(this.expectedName_));
            this.invoked_ = true;
            if (this.create_) {
                Policy[] policies = new Policy[]{};
                POAManager mgr = parent.the_POAManager();
                try {
                    POA poa = parent.create_POA(name, mgr, policies);
                }
                catch (AdapterAlreadyExists ex) {
                    TestBase.TEST(false);
                }
                catch (InvalidPolicy ex) {
                    TestBase.TEST(false);
                }
                return true;
            }
            return false;
        }
    }
}

