/*
 * Decompiled with CFR 0.152.
 */
package test.ins;

import com.ooc.OB.BootManager;
import com.ooc.OB.BootManagerHelper;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POAManagerHelper;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.IIOP.AcceptorInfo;
import com.ooc.OCI.IIOP.AcceptorInfoHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import test.ins.URLTest.IIOPAddress;
import test.ins.URLTest.IIOPAddress_impl;

public final class Server {
    static int getPort(AcceptorInfo iiopInfo) {
        int portShort = iiopInfo.port();
        int port = portShort < 0 ? 65535 + portShort + 1 : portShort;
        return port;
    }

    public static int run(ORB orb, String[] args) throws UserException {
        TempIORFile iorRef;
        com.ooc.OCI.AcceptorInfo info;
        if (args.length != 2) {
            System.out.println("usage: test.ins.Server key_string ior_file");
            return 1;
        }
        String keyStr = args[0];
        String iorFile = args[1];
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        org.omg.PortableServer.POAManager manager = poa.the_POAManager();
        manager.activate();
        Policy[] policies = new Policy[]{poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
        POA testPOA = poa.create_POA("testPOA", manager, policies);
        BootManager bootManager = BootManagerHelper.narrow((Object)orb.resolve_initial_references("BootManager"));
        POAManager obManager = POAManagerHelper.narrow((Object)manager);
        Acceptor[] acceptors = obManager.get_acceptors();
        AcceptorInfo iiopInfo = null;
        for (int i = 0; i < acceptors.length && (iiopInfo = AcceptorInfoHelper.narrow((Object)(info = acceptors[i].get_info()))) == null; ++i) {
        }
        String[] hosts = iiopInfo.hosts();
        int port = Server.getPort(iiopInfo);
        IIOPAddress_impl urlServant = new IIOPAddress_impl(orb, hosts[0], port, keyStr, "corbaloc");
        byte[] oid = urlServant.getKey().getBytes();
        testPOA.activate_object_with_id(oid, (Servant)urlServant);
        IIOPAddress corbaURLObj = urlServant._this(orb);
        bootManager.add_binding(oid, (Object)corbaURLObj);
        try {
            iorRef = new TempIORFile(orb, corbaURLObj, iorFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0;
        }
        orb.run();
        iorRef.release();
        return 0;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            status = Server.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }

    public static class TempIORFile {
        private String iorFile;

        public TempIORFile(ORB orb, Object obj, String fileName) throws IOException {
            this.iorFile = fileName;
            try {
                String ref = orb.object_to_string(obj);
                FileOutputStream file = new FileOutputStream(this.iorFile);
                PrintWriter out = new PrintWriter(file);
                out.println(ref);
                out.flush();
                file.close();
            }
            catch (IOException ex) {
                System.err.println("Can't write to `" + ex.getMessage() + "'");
                throw ex;
            }
        }

        public void release() {
            if (this.iorFile != null) {
                new File(this.iorFile).delete();
            }
            this.iorFile = null;
        }

        protected void finalize() throws Throwable {
            this.release();
            super.finalize();
        }
    }
}

