/*
 * Decompiled with CFR 0.152.
 */
package test.ins;

import com.ooc.OB.ObjectKey;
import com.ooc.OB.ObjectKeyData;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import test.ins.URLTest.IIOPAddress;
import test.ins.URLTest.IIOPAddressHelper;

public final class Client {
    public static int run(ORB orb, String[] args) throws UserException {
        if (args.length < 2) {
            System.out.println("usage: test.ins.Client loop_count ior_url1 [ior_url2]");
            return 1;
        }
        int count = Integer.parseInt(args[0]);
        if (count <= 0) {
            System.err.println("bad test count: " + args[0]);
            return 1;
        }
        ClientTest test = new ClientTest();
        test.init(orb, count);
        int status = 0;
        try {
            test.ior[0] = test.stringToIIOPAddress(args[1]);
            test.ior[1] = args.length != 3 ? test.ior[0] : test.stringToIIOPAddress(args[2]);
            test.run();
        }
        catch (TestFailure ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (test.ior[0] != null) {
            test.ior[0].deactivate();
        }
        return status;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        ORB orb = null;
        try {
            orb = ORB.init((String[])args, (Properties)props);
            status = Client.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }

    private static class ClientTest {
        ORB orb;
        int count;
        IIOPAddress[] ior = new IIOPAddress[2];
        private final boolean multiProfileTest = false;
        private final boolean imrTest = true;

        ClientTest() {
        }

        void init(ORB aOrb, int aCount) {
            this.orb = aOrb;
            this.count = aCount;
        }

        IIOPAddress stringToIIOPAddress(String objStr) throws TestFailure {
            Object obj = null;
            IIOPAddress nObj = null;
            boolean stringToObjOK = false;
            try {
                obj = this.orb.string_to_object(objStr);
                stringToObjOK = true;
                nObj = IIOPAddressHelper.narrow(obj);
                if (obj == null) {
                    System.err.println("Error stringToIIOPAddress:");
                    System.err.println("object `" + objStr + "; is nil " + "reference.");
                    throw new TestFailure();
                }
            }
            catch (SystemException se) {
                System.err.println("Error stringToIIOPAddress:");
                se.printStackTrace();
                System.err.println("Original URL: " + objStr);
                System.err.print("Resultant URL: ");
                if (!stringToObjOK) {
                    System.err.println("NONE, string_to_object raised the exception");
                } else {
                    String iorStr = this.orb.object_to_string(obj);
                    System.err.println(iorStr);
                }
                throw new TestFailure();
            }
            return nObj;
        }

        void declare_test(String msg) {
            System.out.print("Testing " + msg + "... ");
            System.out.flush();
        }

        void finish_test(boolean isOk) throws TestFailure {
            System.out.println(isOk ? "Done!" : "Failed!");
            if (!isOk) {
                throw new TestFailure();
            }
        }

        int getIntPort(IIOPAddress obj) {
            int iPort = obj.getPort();
            if (iPort < 0) {
                iPort += 65536;
            }
            return iPort;
        }

        boolean compareObjs(IIOPAddress iop1, IIOPAddress iop2) {
            String[] cKey = new String[2];
            String[] cHost = new String[2];
            int[] cPort = new int[2];
            IIOPAddress activeIOR = null;
            try {
                activeIOR = iop1;
                cKey[0] = iop1.getKey();
                cHost[0] = iop1.getHost();
                cPort[0] = this.getIntPort(iop1);
                activeIOR = iop2;
                cKey[1] = iop2.getKey();
                cHost[1] = iop2.getHost();
                cPort[1] = this.getIntPort(iop2);
            }
            catch (SystemException se) {
                System.out.print("Error compareObj, invoking:");
                se.printStackTrace();
                String iorStr = this.orb.object_to_string((Object)activeIOR);
                System.out.println(iorStr);
                throw se;
            }
            return cKey[0].equals(cKey[1]) && cHost[0].equals(cHost[1]) && cPort[0] == cPort[1];
        }

        String escape(byte[] arr) {
            StringBuffer result = new StringBuffer(arr.length * 3);
            for (int i = 0; i < arr.length; ++i) {
                result.append('%');
                result.append(Character.toUpperCase(Character.forDigit(arr[i] >> 4 & 0xF, 16)));
                result.append(Character.toUpperCase(Character.forDigit(arr[i] & 0xF, 16)));
            }
            return result.toString();
        }

        String getURLAddressComponent(IIOPAddress nObj, String prefix) {
            String url = prefix != null ? prefix : ":";
            url = url + nObj.getHost();
            url = url + ":";
            url = url + Integer.toString(this.getIntPort(nObj));
            return url;
        }

        void runPass(int passNumber) throws TestFailure {
            String addr;
            IIOPAddress nObj;
            int i;
            String[] host = new String[2];
            String[] key = new String[2];
            int[] port = new int[2];
            this.declare_test("string_to_object");
            for (i = 0; i < 2; ++i) {
                key[i] = this.ior[i].getKey();
                host[i] = this.ior[i].getHost();
                port[i] = this.getIntPort(this.ior[i]);
            }
            this.finish_test(true);
            this.declare_test("object_to_string");
            for (i = 0; i < 2; ++i) {
                String iorStr = this.orb.object_to_string((Object)this.ior[i]);
                IIOPAddress nAddr = this.stringToIIOPAddress(iorStr);
                if (this.compareObjs(this.ior[i], nAddr)) continue;
                this.finish_test(false);
            }
            this.finish_test(true);
            this.declare_test("null URL string exception");
            boolean correctException = false;
            try {
                Object obj = this.orb.string_to_object(null);
            }
            catch (BAD_PARAM bp) {
                correctException = true;
            }
            this.finish_test(correctException);
            this.declare_test("bad corbaloc port and scheme exceptions");
            int exceptionCount = 0;
            String[] urlStr = new String[]{"corbaloc:iiop:localhost:2809/a/b/c", "corbaloc:iiop:localhost:0/a/b/c", "corbaloc:iiop:localhost:65536/a/b/c", "corbaloc:iiop:localhost:-90/a/b/c", "corbaloc:iiop:localhost:not_a_number/a/b/c", "corbaloc:corbaloc-bad-scheme:localhost:not_a_number/a/b/c"};
            for (int i2 = 0; i2 < 6; ++i2) {
                try {
                    Object obj = this.orb.string_to_object(urlStr[i2]);
                    continue;
                }
                catch (BAD_PARAM bp) {
                    if (i2 == 0) {
                        this.finish_test(false);
                    }
                    ++exceptionCount;
                }
            }
            this.finish_test(exceptionCount == 5);
            this.declare_test("iiop default version 1.0 corbaloc URL");
            for (i = 0; i < 2; ++i) {
                String str;
                String url = this.ior[i].getCorbalocURL();
                IIOPAddress nObj2 = this.stringToIIOPAddress(url);
                if (!this.compareObjs(this.ior[i], nObj2)) {
                    this.finish_test(false);
                }
                if ((str = nObj2.getString()).equals("corbaloc")) continue;
                this.finish_test(false);
            }
            this.finish_test(true);
            this.declare_test("iiop version 1.0 - 1.9 corbaloc URL");
            for (i = 0; i < 2; ++i) {
                for (int iv = 0; iv < 10; ++iv) {
                    String addr2 = this.getURLAddressComponent(this.ior[i], ":1." + iv + "@");
                    String url = "corbaloc:" + addr2 + "/" + this.ior[i].getKey();
                    nObj = this.stringToIIOPAddress(url);
                    if (this.compareObjs(this.ior[i], nObj)) continue;
                    this.finish_test(false);
                }
            }
            this.finish_test(true);
            this.declare_test("unsupported iiop version corbaloc URL");
            for (i = 0; i < 2; ++i) {
                String iiopMajor = i == 0 ? ":0." : ":2.";
                for (int iv = 0; iv < 10; ++iv) {
                    addr = this.getURLAddressComponent(this.ior[i], iiopMajor + iv + "@");
                    String url = "corbaloc:" + addr + "/" + this.ior[i].getKey();
                    try {
                        this.orb.string_to_object(url);
                        System.err.println("\nIncorrectly accepted '" + url + "'");
                        this.finish_test(false);
                        continue;
                    }
                    catch (BAD_PARAM ex) {
                        // empty catch block
                    }
                }
            }
            this.finish_test(true);
            this.declare_test("IMR corbaloc");
            for (i = 0; i < 2; ++i) {
                String str;
                String iorKey = this.ior[i].getKey();
                byte[] oid = iorKey.getBytes();
                ObjectKeyData data = new ObjectKeyData();
                data.persistent = true;
                data.createTime = 0;
                data.oid = oid;
                data.serverId = "_RootPOA";
                data.poaId = new String[1];
                data.poaId[0] = "testPOA";
                byte[] oct = ObjectKey.CreateObjectKey((ObjectKeyData)data);
                String keyStr = this.escape(oct);
                String addr3 = this.getURLAddressComponent(this.ior[i], (i & 1) != 0 ? ":1.1@" : ":1.2@");
                String url = "corbaloc:" + addr3 + '/' + keyStr;
                IIOPAddress nObj3 = this.stringToIIOPAddress(url);
                if (!this.compareObjs(this.ior[i], nObj3)) {
                    this.finish_test(false);
                }
                if ((str = nObj3.getString()).equals("corbaloc")) continue;
                this.finish_test(false);
            }
            this.finish_test(true);
            this.declare_test("active profile 1 in a multi-profile IOR");
            for (i = 0; i < 2; ++i) {
                String str;
                String url = "corbaloc:";
                String addr4 = this.getURLAddressComponent(this.ior[i], null);
                url = url + addr4;
                url = url + ",:localhost:2809";
                url = url + ",:localhost:2809";
                IIOPAddress nObj4 = this.stringToIIOPAddress(url = url + "/" + this.ior[i].getKey());
                if (!this.compareObjs(this.ior[i], nObj4)) {
                    this.finish_test(false);
                }
                if ((str = nObj4.getString()).equals("corbaloc")) continue;
                this.finish_test(false);
            }
            this.finish_test(true);
            boolean multi_3_test = false;
            if (multi_3_test) {
                this.declare_test("active profile 3 in a multi-profile IOR");
                for (int i3 = 0; i3 < 2; ++i3) {
                    String url = "corbaloc:";
                    url = url + ":localhost:2809";
                    url = url + ",:localhost:2809,";
                    addr = this.getURLAddressComponent(this.ior[i3], null);
                    url = url + addr;
                    nObj = this.stringToIIOPAddress(url = url + "/" + this.ior[i3].getKey());
                    if (this.compareObjs(this.ior[i3], nObj)) continue;
                    this.finish_test(false);
                }
                this.finish_test(true);
            }
        }

        void run() throws TestFailure {
            for (int c = 0; c < this.count; ++c) {
                if (this.count != 1) {
                    System.out.println("Test Pass: " + (c + 1));
                }
                try {
                    this.runPass(c);
                    continue;
                }
                catch (TestFailure tfe) {
                    if (this.count != 1) continue;
                    throw tfe;
                }
            }
        }
    }

    private static class TestFailure
    extends Exception {
        TestFailure() {
        }

        TestFailure(String msg) {
            System.err.println(msg);
        }
    }
}

