/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util;

public class MessageQueue {
    private boolean deactivated_ = false;
    private Element head_ = null;
    private Element tail_ = null;

    public synchronized void deactivate() {
        this.deactivated_ = true;
        this.notifyAll();
    }

    public synchronized boolean getDeactivated() {
        return this.deactivated_;
    }

    public synchronized boolean getEmpty() {
        return this.head_ == null;
    }

    public synchronized void enqueue(Object value) {
        Element elem = new Element(value);
        if (this.tail_ == null) {
            this.head_ = this.tail_ = elem;
        } else {
            this.tail_.next = elem;
            this.tail_ = elem;
        }
        this.notifyAll();
    }

    public synchronized Object dequeue() {
        Object result = null;
        while (result == null && !this.deactivated_) {
            if (this.head_ == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            result = this.head_.value;
            this.head_ = this.head_.next;
            if (this.head_ != null) continue;
            this.tail_ = null;
        }
        return result;
    }

    private static class Element {
        public Object value;
        public Element next;

        public Element(Object val) {
            this.value = val;
            this.next = null;
        }
    }
}

