/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.GUI;

import com.ooc.Util.Status;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StatusBar
extends JPanel
implements Status {
    private boolean beveled_;
    private JLabel label_;
    private String defaultText_ = "";

    public StatusBar() {
        this(true);
    }

    public StatusBar(boolean beveled) {
        Border border;
        this.setLayout(new GridBagLayout());
        this.beveled_ = beveled;
        this.label_ = new JLabel("");
        if (beveled) {
            Border bevel = BorderFactory.createLoweredBevelBorder();
            Border empty = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            border = BorderFactory.createCompoundBorder(bevel, empty);
        } else {
            border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        }
        this.label_.setBorder(border);
        this.label_.setPreferredSize(new Dimension(0, 25));
        this.constrain(this.label_, 0, 0, 1, 1, 1, 17, 1.0, 1.0);
    }

    public void add(JComponent component) {
        int xPos = this.getComponents().length;
        if (this.beveled_) {
            component.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        this.constrain(component, xPos, 0, 1, 1, 3, 17, 0.0, 1.0);
    }

    public void setText(String text) {
        this.label_.setText(text);
    }

    public void setDefaultText(String text) {
        this.defaultText_ = text;
        this.clear();
    }

    public String getDefaultText() {
        return this.defaultText_;
    }

    public void clear() {
        this.label_.setText(this.defaultText_);
    }

    protected void constrain(Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        ((GridBagLayout)this.getLayout()).setConstraints(component, c);
        this.add(component);
    }
}

