/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.GUI;

import com.ooc.Util.BinarySearch;
import com.ooc.Util.QuickSort;
import com.ooc.Util.Sortable;
import javax.swing.AbstractListModel;

public class SortedListModel
extends AbstractListModel {
    private Sortable[] items_;

    public SortedListModel() {
        this.items_ = new Sortable[0];
    }

    public SortedListModel(Sortable[] items) {
        this.items_ = items;
        QuickSort.sort(this.items_, null);
    }

    public synchronized int getSize() {
        return this.items_.length;
    }

    public synchronized Object getElementAt(int index) {
        return this.items_[index];
    }

    public synchronized Sortable[] getItems() {
        return this.items_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemChanged(Sortable item) {
        int pos = -1;
        SortedListModel sortedListModel = this;
        synchronized (sortedListModel) {
            pos = BinarySearch.find(this.items_, item, null);
        }
        if (pos >= 0) {
            this.fireContentsChanged(this, pos, pos);
        }
    }

    public synchronized Sortable findItem(Sortable template) {
        Sortable result = null;
        int pos = BinarySearch.find(this.items_, template, null);
        if (pos >= 0) {
            result = this.items_[pos];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItems(Sortable[] items) {
        int length = 0;
        if (this.items_.length > 0) {
            this.fireIntervalRemoved(this, 0, this.items_.length - 1);
        }
        SortedListModel sortedListModel = this;
        synchronized (sortedListModel) {
            this.items_ = items;
            QuickSort.sort(this.items_, null);
            length = this.items_.length;
        }
        if (length > 0) {
            this.fireIntervalAdded(this, 0, length - 1);
        }
    }

    public void removeAll() {
        if (this.items_.length > 0) {
            this.fireIntervalRemoved(this, 0, this.items_.length - 1);
        }
        this.items_ = new Sortable[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Sortable item) {
        int pos = 0;
        SortedListModel sortedListModel = this;
        synchronized (sortedListModel) {
            pos = BinarySearch.getInsertPosition(this.items_, item, null);
            Sortable[] arr = new Sortable[this.items_.length + 1];
            System.arraycopy(this.items_, 0, arr, 0, pos);
            arr[pos] = item;
            System.arraycopy(this.items_, pos, arr, pos + 1, this.items_.length - pos);
            this.items_ = arr;
        }
        this.fireIntervalAdded(this, pos, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(Sortable item) {
        int pos = -1;
        SortedListModel sortedListModel = this;
        synchronized (sortedListModel) {
            pos = BinarySearch.find(this.items_, item, null);
            if (pos >= 0) {
                Sortable[] arr = new Sortable[this.items_.length - 1];
                System.arraycopy(this.items_, 0, arr, 0, pos);
                System.arraycopy(this.items_, pos + 1, arr, pos, this.items_.length - (pos + 1));
                this.items_ = arr;
            }
        }
        if (pos >= 0) {
            this.fireIntervalRemoved(this, pos, pos);
        }
    }
}

