/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.CORBA;

import com.ooc.Util.CORBA.ORBManager;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynArrayHelper;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynEnumHelper;
import org.omg.DynamicAny.DynFixed;
import org.omg.DynamicAny.DynFixedHelper;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.DynUnionHelper;
import org.omg.DynamicAny.DynValue;
import org.omg.DynamicAny.DynValueHelper;

public class AnyWriter {
    private int level_ = 0;
    private String spacing_ = "  ";
    private PrintWriter out_;
    private DynAnyFactory factory_;
    private static Hashtable typeNames_ = new Hashtable();

    private static TypeCode getOriginalType(TypeCode tc) {
        TypeCode result = tc;
        try {
            while (result.kind() == TCKind.tk_alias) {
                result = result.content_type();
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        return result;
    }

    public AnyWriter() {
        this(new PrintWriter(System.out, true));
    }

    public AnyWriter(PrintWriter out) {
        this.out_ = out;
        ORB orb = ORBManager.ORB();
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("DynAnyFactory");
        }
        catch (InvalidName ex) {
            throw new RuntimeException();
        }
        this.factory_ = DynAnyFactoryHelper.narrow((Object)obj);
    }

    public void setWriter(PrintWriter out) {
        this.out_ = out;
    }

    public PrintWriter getWriter() {
        return this.out_;
    }

    public void flush() {
        this.out_.flush();
    }

    public void setSpacing(String spacing) {
        this.spacing_ = spacing;
    }

    public String getSpacing() {
        return this.spacing_;
    }

    public void up() {
        --this.level_;
    }

    public void down() {
        ++this.level_;
    }

    public PrintWriter skip() {
        for (int i = 0; i < this.level_; ++i) {
            this.out_.print(this.spacing_);
        }
        return this.out_;
    }

    public void print(TypeCode tc) {
        TCKind kind = tc.kind();
        try {
            switch (kind.value()) {
                case 14: {
                    this.skip().print("interface " + tc.name() + ";");
                    break;
                }
                case 15: 
                case 22: {
                    this.skip().println("" + typeNames_.get(kind) + " " + tc.name() + " {");
                    this.down();
                    for (int i = 0; i < tc.member_count(); ++i) {
                        this.skip();
                        TypeCode memberType = tc.member_type(i);
                        this.printName(memberType);
                        this.out_.println(" " + tc.member_name(i) + ";");
                    }
                    this.up();
                    this.skip().print("};");
                    break;
                }
                case 16: {
                    this.skip().print("union " + tc.name() + " switch(");
                    TypeCode discrType = tc.discriminator_type();
                    this.printName(discrType);
                    this.out_.println(") {");
                    this.down();
                    for (int i = 0; i < tc.member_count(); ++i) {
                        Any label = tc.member_label(i);
                        TypeCode type = label.type();
                        if (type.kind() == TCKind.tk_octet) {
                            this.skip().print("default");
                        } else {
                            this.skip().print("case ");
                            DynAny dynAny = null;
                            try {
                                dynAny = this.factory_.create_dyn_any(label);
                            }
                            catch (InconsistentTypeCode e) {
                                throw new RuntimeException();
                            }
                            this.printDynAny(dynAny, false);
                        }
                        this.out_.print(": ");
                        TypeCode memberType = tc.member_type(i);
                        this.printName(memberType);
                        this.out_.println(" " + tc.member_name(i) + ";");
                    }
                    this.up();
                    this.skip().print("};");
                    break;
                }
                case 17: {
                    this.skip().print("enum " + tc.name() + " {");
                    for (int i = 0; i < tc.member_count(); ++i) {
                        if (i != 0) {
                            this.out_.print(", ");
                        }
                        this.out_.print(tc.member_name(i));
                    }
                    this.out_.print("};");
                    break;
                }
                case 18: {
                    this.skip().print("string");
                    int length = tc.length();
                    if (length == 0) break;
                    this.out_.print("<" + length + ">");
                    break;
                }
                case 27: {
                    this.skip().print("wstring");
                    int length = tc.length();
                    if (length == 0) break;
                    this.out_.print("<" + length + ">");
                    break;
                }
                case 28: {
                    this.skip().print("fixed<" + tc.fixed_digits() + "," + tc.fixed_scale() + ">");
                    break;
                }
                case 19: {
                    this.skip().print("sequence<");
                    TypeCode contentType = tc.content_type();
                    this.printName(contentType);
                    int length = tc.length();
                    if (length != 0) {
                        this.out_.print(", " + length);
                    }
                    this.out_.print(">");
                    break;
                }
                case 20: {
                    this.skip();
                    TypeCode contentType = tc.content_type();
                    this.printName(contentType);
                    int length = tc.length();
                    this.out_.print("[" + length + "]");
                    break;
                }
                case 21: {
                    this.skip().print("typedef ");
                    TypeCode contentType = tc.content_type();
                    this.printName(contentType);
                    this.out_.print(" " + tc.name() + ";");
                    break;
                }
                case 29: {
                    this.skip().println("valuetype " + tc.name() + " {");
                    this.down();
                    Vector<TypeCode> vec = new Vector<TypeCode>();
                    vec.addElement(tc);
                    for (TypeCode base = tc.concrete_base_type(); base != null; base = base.concrete_base_type()) {
                        vec.insertElementAt(base, 0);
                    }
                    Enumeration e = vec.elements();
                    while (e.hasMoreElements()) {
                        TypeCode p = (TypeCode)e.nextElement();
                        for (int i = 0; i < p.member_count(); ++i) {
                            this.skip();
                            TypeCode memberType = p.member_type(i);
                            this.printName(memberType);
                            this.out_.println(" " + p.member_name(i) + ";");
                        }
                    }
                    this.up();
                    this.skip().print("};");
                    break;
                }
                case 30: {
                    this.skip().print("valuetype " + tc.name() + " ");
                    TypeCode contentType = tc.content_type();
                    this.printName(contentType);
                    this.out_.print(";");
                    break;
                }
                case 32: {
                    this.skip().print("abstract interface " + tc.name() + ";");
                    break;
                }
                case 31: {
                    this.skip().print("native " + tc.name() + ";");
                    break;
                }
                default: {
                    this.skip().print("" + typeNames_.get(kind));
                }
            }
            this.out_.println();
        }
        catch (BadKind e) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
    }

    public void printName(TypeCode tc) {
        TCKind kind = tc.kind();
        try {
            switch (kind.value()) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    this.out_.print(tc.name());
                    break;
                }
                case 28: {
                    this.out_.print("fixed<" + tc.fixed_digits() + "," + tc.fixed_scale() + ">");
                    break;
                }
                case 18: {
                    this.out_.print("string");
                    int length = tc.length();
                    if (length != 0) {
                        this.out_.print("<" + length + ">");
                    }
                    break;
                }
                case 27: {
                    this.out_.print("wstring");
                    int length = tc.length();
                    if (length != 0) {
                        this.out_.print("<" + length + ">");
                    }
                    break;
                }
                case 19: {
                    this.out_.print("sequence<");
                    TypeCode contentType = tc.content_type();
                    this.printName(contentType);
                    int length = tc.length();
                    if (length != 0) {
                        this.out_.print(", " + length);
                    }
                    this.out_.print(">");
                    break;
                }
                case 20: {
                    TypeCode contentType = tc.content_type();
                    this.printName(contentType);
                    int length = tc.length();
                    this.out_.print("[" + length + "]");
                    break;
                }
                default: {
                    this.out_.print("" + typeNames_.get(kind));
                    break;
                }
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
    }

    public void print(DynAny dynAny) {
        this.skip();
        this.printDynAny(dynAny);
        this.out_.println();
    }

    public void printDynAny(DynAny dynAny) {
        this.printDynAny(dynAny, true);
    }

    public void printDynAny(DynAny dynAny, boolean showType) {
        if (showType) {
            TypeCode tc = dynAny.type();
            this.printName(tc);
            this.out_.print("(");
        }
        dynAny.rewind();
        TypeCode type = dynAny.type();
        TypeCode tc = AnyWriter.getOriginalType(type);
        TCKind kind = tc.kind();
        try {
            switch (kind.value()) {
                case 0: {
                    this.out_.print("<null>");
                    break;
                }
                case 1: {
                    this.out_.print("<void>");
                    break;
                }
                case 2: {
                    this.out_.print(dynAny.get_short());
                    break;
                }
                case 4: {
                    int i = dynAny.get_ushort();
                    if (i < 0) {
                        i += 65536;
                    }
                    this.out_.print(i);
                    break;
                }
                case 3: {
                    this.out_.print(dynAny.get_long());
                    break;
                }
                case 5: {
                    long l = dynAny.get_ulong();
                    if (l < 0L) {
                        l += 0x100000000L;
                    }
                    this.out_.print(l);
                    break;
                }
                case 23: {
                    this.out_.print(dynAny.get_longlong());
                    break;
                }
                case 24: {
                    long l = dynAny.get_ulonglong();
                    if (l < 0L) {
                        l += 0L;
                    }
                    this.out_.print(l);
                    break;
                }
                case 6: {
                    this.out_.print(dynAny.get_float());
                    break;
                }
                case 7: {
                    this.out_.print(dynAny.get_double());
                    break;
                }
                case 8: {
                    this.out_.print(dynAny.get_boolean() ? "TRUE" : "FALSE");
                    break;
                }
                case 9: {
                    this.out_.print(dynAny.get_char());
                    break;
                }
                case 26: {
                    this.out_.print(dynAny.get_wchar());
                    break;
                }
                case 10: {
                    short s = dynAny.get_octet();
                    if (s < 0) {
                        s = (short)(s + 256);
                    }
                    this.out_.print(s);
                    break;
                }
                case 18: {
                    this.out_.print(dynAny.get_string());
                    break;
                }
                case 27: {
                    this.out_.print(dynAny.get_wstring());
                    break;
                }
                case 14: {
                    Object obj = dynAny.get_reference();
                    if (obj == null) {
                        this.out_.print("nil");
                        break;
                    }
                    this.out_.print("<object>");
                    break;
                }
                case 11: {
                    Any any = dynAny.get_any();
                    this.printAny(any, showType);
                    break;
                }
                case 12: {
                    TypeCode typeCode = dynAny.get_typecode();
                    this.printName(typeCode);
                    break;
                }
                case 28: {
                    DynFixed dynFixed = DynFixedHelper.narrow((Object)dynAny);
                    this.out_.print(dynFixed.get_value());
                    break;
                }
                case 15: 
                case 22: {
                    DynStruct dynStruct = DynStructHelper.narrow((Object)dynAny);
                    this.out_.println();
                    this.down();
                    int count = tc.member_count();
                    for (int i = 0; i < count; ++i) {
                        String name = dynStruct.current_member_name();
                        this.skip().print(name + " = ");
                        DynAny component = dynStruct.current_component();
                        this.printDynAny(component, showType);
                        this.out_.println();
                        dynStruct.next();
                    }
                    this.up();
                    this.skip();
                    break;
                }
                case 29: {
                    DynValue dynValue = DynValueHelper.narrow((Object)dynAny);
                    this.out_.println();
                    this.down();
                    int count = dynValue.component_count();
                    for (int i = 0; i < count; ++i) {
                        String name = dynValue.current_member_name();
                        this.skip().print(name + " = ");
                        DynAny component = dynValue.current_component();
                        this.printDynAny(component, showType);
                        this.out_.println();
                        dynValue.next();
                    }
                    this.up();
                    this.skip();
                    break;
                }
                case 30: {
                    DynValue dynValue = DynValueHelper.narrow((Object)dynAny);
                    this.out_.println();
                    this.down();
                    this.skip();
                    DynAny component = dynValue.current_component();
                    this.printDynAny(component, showType);
                    this.out_.println();
                    this.up();
                    this.skip();
                    break;
                }
                case 16: {
                    DynUnion dynUnion = DynUnionHelper.narrow((Object)dynAny);
                    this.out_.println();
                    this.down();
                    DynAny component = dynUnion.current_component();
                    this.skip().print("discriminator = ");
                    this.printDynAny(component, showType);
                    this.out_.println();
                    dynUnion.next();
                    component = dynUnion.current_component();
                    String member = dynUnion.member_name();
                    this.skip().print(member + " = ");
                    if (component != null) {
                        this.printDynAny(component, showType);
                    } else {
                        this.out_.println("not initialized");
                    }
                    this.out_.println();
                    this.up();
                    this.skip();
                    break;
                }
                case 17: {
                    DynEnum dynEnum = DynEnumHelper.narrow((Object)dynAny);
                    this.out_.print(dynEnum.get_as_string());
                    break;
                }
                case 19: {
                    DynSequence dynSequence = DynSequenceHelper.narrow((Object)dynAny);
                    for (int i = 0; i < dynSequence.get_length(); ++i) {
                        if (i != 0) {
                            this.out_.print(", ");
                        }
                        DynAny component = dynSequence.current_component();
                        this.printDynAny(component, showType);
                        dynSequence.next();
                    }
                    break;
                }
                case 20: {
                    DynArray dynArray = DynArrayHelper.narrow((Object)dynAny);
                    for (int i = 0; i < tc.length(); ++i) {
                        if (i != 0) {
                            this.out_.print(", ");
                        }
                        DynAny component = dynArray.current_component();
                        this.printDynAny(component, showType);
                        dynArray.next();
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported type kind");
                }
            }
        }
        catch (InvalidValue e) {
        }
        catch (TypeMismatch e) {
        }
        catch (BadKind e) {
            // empty catch block
        }
        dynAny.rewind();
        if (showType) {
            this.out_.print(")");
        }
    }

    public void print(Any any) {
        this.printAny(any, true);
    }

    public void printAny(Any any, boolean showType) {
        DynAny dynAny = null;
        try {
            dynAny = this.factory_.create_dyn_any(any);
        }
        catch (InconsistentTypeCode ex) {
            this.out_.print("<unsupported type>");
            return;
        }
        this.printDynAny(dynAny, showType);
    }

    public void print(Any[] anySeq, boolean showType) {
        for (int i = 0; i < anySeq.length; ++i) {
            this.out_.print("  ");
            this.printAny(anySeq[i], showType);
        }
        this.out_.println();
    }

    static {
        typeNames_.put(TCKind.tk_null, "null");
        typeNames_.put(TCKind.tk_void, "void");
        typeNames_.put(TCKind.tk_short, "short");
        typeNames_.put(TCKind.tk_ushort, "unsigned short");
        typeNames_.put(TCKind.tk_long, "long");
        typeNames_.put(TCKind.tk_ulong, "unsigned long");
        typeNames_.put(TCKind.tk_float, "float");
        typeNames_.put(TCKind.tk_double, "double");
        typeNames_.put(TCKind.tk_boolean, "boolean");
        typeNames_.put(TCKind.tk_char, "char");
        typeNames_.put(TCKind.tk_octet, "octet");
        typeNames_.put(TCKind.tk_any, "any");
        typeNames_.put(TCKind.tk_TypeCode, "TypeCode");
        typeNames_.put(TCKind.tk_Principal, "Principal");
        typeNames_.put(TCKind.tk_objref, "objref");
        typeNames_.put(TCKind.tk_struct, "struct");
        typeNames_.put(TCKind.tk_union, "union");
        typeNames_.put(TCKind.tk_enum, "enum");
        typeNames_.put(TCKind.tk_string, "string");
        typeNames_.put(TCKind.tk_sequence, "sequence");
        typeNames_.put(TCKind.tk_array, "array");
        typeNames_.put(TCKind.tk_alias, "alias");
        typeNames_.put(TCKind.tk_except, "exception");
        typeNames_.put(TCKind.tk_longlong, "long long");
        typeNames_.put(TCKind.tk_ulonglong, "unsigned long long");
        typeNames_.put(TCKind.tk_longdouble, "long double");
        typeNames_.put(TCKind.tk_wchar, "wchar");
        typeNames_.put(TCKind.tk_wstring, "wstring");
        typeNames_.put(TCKind.tk_fixed, "fixed");
        typeNames_.put(TCKind.tk_value, "valuetype");
        typeNames_.put(TCKind.tk_value_box, "valuebox");
        typeNames_.put(TCKind.tk_native, "native");
        typeNames_.put(TCKind.tk_abstract_interface, "abstract interface");
    }
}

