/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosNaming;

import com.ooc.CORBA.ORB;
import com.ooc.CosNaming.NamingService;
import com.ooc.CosNaming.NamingServiceOptions;
import com.ooc.CosNaming.ShutdownHook;
import com.ooc.OB.Assert;
import com.ooc.OB.BootManager;
import com.ooc.OB.BootManagerHelper;
import com.ooc.OB.BootManagerPackage.AlreadyExists;
import java.util.Enumeration;
import java.util.Properties;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.StringSeqHolder;
import org.omg.CosNaming.NamingContext;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public final class Server {
    static void usage(String progName) {
        System.err.println("Usage:");
        System.err.println(progName + " [options]\n" + "\n" + "Options:\n" + "-h, --help                   " + "Show this message.\n" + "-v, --version                " + "Show Naming Service version.\n" + "-i, --ior                    " + "Print IOR on standard output.\n" + "-n, --no-updates             " + "No automatic updates with ORBacus Names.\n" + "-s, --start                  " + "Run for the first time.\n" + "-d, --database FILE          " + "Use FILE as the database.\n" + "-l, --limit COUNT            " + "Limit bindings returned by list operation.\n" + "-t, --timeout MINS           " + "Purge the database every MINS minutes.\n" + "                             " + "(The default is 5 minutes.)\n" + "-c, --callback-timeout SECS  " + "Timeout for callbacks in seconds.\n" + "                             " + "(The default is 5 seconds.)");
    }

    static int run(org.omg.CORBA.ORB orb, String progName, String[] args, Properties props) {
        boolean ior = false;
        NamingServiceOptions options = new NamingServiceOptions();
        String propRoot = "ooc.naming.";
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(propRoot)) continue;
            String value = props.getProperty(key);
            if (key.equals("ooc.naming.database")) {
                options.databaseName = value;
                continue;
            }
            if (key.equals("ooc.naming.limit")) {
                try {
                    options.maxBindings = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid value for ooc.naming.limit");
                    return 1;
                }
            }
            if (key.equals("ooc.naming.timeout")) {
                try {
                    options.databaseTimeout = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid value for ooc.naming.timeout");
                    return 1;
                }
            }
            if (key.equals("ooc.naming.callback_timeout")) {
                try {
                    options.callbackTimeout = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid value for ooc.naming.callback_timeout");
                    return 1;
                }
            }
            if (key.equals("ooc.naming.no_updates")) {
                options.noUpdates = value.equals("true") || value.equals("TRUE") || value.equals("1");
                continue;
            }
            if (key.equals("ooc.naming.trace_level")) {
                options.traceLevel = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ooc.naming.endpoint")) {
                String oaEndpoint = props.getProperty("ooc.orb.oa.endpoint");
                if (oaEndpoint != null) continue;
                props.put("ooc.orb.oa.endpoint", value);
                continue;
            }
            System.err.println(progName + ": `" + key + "': " + "unknown property");
        }
        Object poaObj = null;
        try {
            poaObj = orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName ex) {
            throw new RuntimeException();
        }
        POA rootPOA = POAHelper.narrow((Object)poaObj);
        POAManager manager = rootPOA.the_POAManager();
        POA rootContextPOA = null;
        POA contextPOA = null;
        try {
            Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            rootContextPOA = rootPOA.create_POA("RootContextPOA", manager, policies);
            policies[1] = rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
            contextPOA = rootPOA.create_POA("ContextPOA", manager, policies);
        }
        catch (AdapterAlreadyExists ex) {
        }
        catch (InvalidPolicy ex) {
            // empty catch block
        }
        Assert._OB_assert((rootContextPOA != null ? 1 : 0) != 0);
        Assert._OB_assert((contextPOA != null ? 1 : 0) != 0);
        for (int i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if (args[i].equals("--help") || args[i].equals("-h")) {
                Server.usage(progName);
                return 0;
            }
            if (args[i].equals("--version") || args[i].equals("-v")) {
                System.err.println("ORBacus Names4.1.3");
                return 0;
            }
            if (args[i].equals("--ior") || args[i].equals("-i")) {
                ior = true;
                continue;
            }
            if (args[i].equals("--no-updates") || args[i].equals("-n")) {
                options.noUpdates = true;
                continue;
            }
            if (args[i].equals("--limit") || args[i].equals("-l")) {
                if (++i >= args.length) {
                    System.err.println(progName + ": " + args[i - 1] + "expects argument");
                    Server.usage(progName);
                    return 1;
                }
                options.maxBindings = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("--timeout") || args[i].equals("-t")) {
                if (++i >= args.length) {
                    System.err.println(progName + ": " + args[i - 1] + "expects argument");
                    Server.usage(progName);
                    return 1;
                }
                options.databaseTimeout = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("--callback-timeout") || args[i].equals("-c")) {
                if (++i >= args.length) {
                    System.err.println(progName + ": " + args[i - 1] + "expects argument");
                    Server.usage(progName);
                    return 1;
                }
                options.callbackTimeout = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("--database") || args[i].equals("-d")) {
                if (++i >= args.length) {
                    System.err.println(progName + ": " + args[i - 1] + "expects argument");
                    Server.usage(progName);
                    return 1;
                }
                options.databaseName = args[i];
                continue;
            }
            if (args[i].equals("--start") || args[i].equals("-s")) {
                options.databaseExists = false;
                continue;
            }
            System.err.println(progName + ": unknown option `" + args[i] + "'\n");
            Server.usage(progName);
            return 1;
        }
        if (options.databaseTimeout <= 0) {
            System.err.println(progName + ": timeout value must be > 0");
            return 1;
        }
        if (options.maxBindings < 0) {
            System.err.println(progName + ": binding limit must be >= 0");
            return 1;
        }
        if (!options.databaseExists && options.databaseName == null) {
            System.err.println(progName + ": --start (-s) requires the " + "--database (-d) option");
            return 1;
        }
        NamingService namingService = new NamingService(orb, rootContextPOA, contextPOA, options);
        namingService.initialize();
        NamingContext root = namingService.rootNamingContext();
        try {
            byte[] oid = "NameService".getBytes();
            BootManager bootManager = BootManagerHelper.narrow((Object)orb.resolve_initial_references("BootManager"));
            bootManager.add_binding(oid, (Object)root);
        }
        catch (InvalidName ex) {
            throw new RuntimeException();
        }
        catch (AlreadyExists ex) {
            throw new RuntimeException();
        }
        if (ior) {
            System.out.println(orb.object_to_string((Object)root));
        }
        try {
            manager.activate();
        }
        catch (AdapterInactive ex) {
            throw new RuntimeException();
        }
        orb.run();
        return 0;
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        props.put("org.omg.CORBA.ORBClass", "com.ooc.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "com.ooc.CORBA.ORBSingleton");
        int status = 0;
        org.omg.CORBA.ORB orb = null;
        ShutdownHook shutdownHook_ = null;
        String progName = "com.ooc.CosNaming.Server";
        try {
            args = ORB.ParseArgs((String[])args, (Properties)props, null);
            String oaModel = props.getProperty("ooc.orb.oa.conc_model");
            String orbModel = props.getProperty("ooc.orb.conc_model");
            boolean valid = oaModel != null && orbModel != null ? orbModel.equals("threaded") && (oaModel.equals("thread_per_request") || oaModel.equals("thread_pool")) : false;
            if (!valid) {
                props.put("ooc.orb.conc_model", "threaded");
                props.put("ooc.orb.oa.conc_model", "thread_per_request");
            }
            StringSeqHolder argsH = new StringSeqHolder(args);
            orb = ORB.init((StringSeqHolder)argsH, (Properties)props, null);
            shutdownHook_ = new ShutdownHook(orb);
            shutdownHook_.register();
            status = Server.run(orb, progName, argsH.value, props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

