/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.CORBA.IOP;

import com.ooc.CORBA.InputStream;
import com.ooc.OB.HexConverter;
import com.ooc.OCI.Buffer;
import com.ooc.Util.CORBA.IOP.ProfileTagAnalyzer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;

public final class IORAnalyzer {
    private IORAnalyzer() {
    }

    public static IOR getIOR(ORB orb, Object obj) {
        if (obj == null) {
            return null;
        }
        String s = orb.object_to_string(obj);
        if (!s.startsWith("IOR:")) {
            return null;
        }
        byte[] buf = HexConverter.asciiToOctets((String)s, (int)4);
        if (buf == null) {
            return null;
        }
        InputStream in = new InputStream(new Buffer(buf, buf.length), 0, false);
        in._OB_readEndian();
        return IORHelper.read((org.omg.CORBA.portable.InputStream)in);
    }

    public static String dumpIOR(ORB orb, Object obj) {
        IOR ior = IORAnalyzer.getIOR(orb, obj);
        if (ior == null) {
            return "Illegal object type\n";
        }
        String result = "  type_id: " + ior.type_id + "\n";
        for (int i = 0; i < ior.profiles.length; ++i) {
            ProfileTagAnalyzer a = ProfileTagAnalyzer.getAnalyzer(ior.profiles[i]);
            result = a != null ? result + a.analyze() : result + "  Unknown profile tag\n";
        }
        return result;
    }
}

