/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.Util.CORBA.GUI.IntRep;

import com.ooc.Util.CORBA.GUI.IntRep.IRFilter;
import com.ooc.Util.CORBA.GUI.IntRep.IRTreeNode;
import com.ooc.Util.CORBA.IntRep.IRRepository;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Repository;

public class IRTreeModel
implements TreeModel {
    private ORB orb_;
    private Repository repository_;
    private IRTreeNode root_;
    private Vector listeners_ = new Vector();

    public IRTreeModel(ORB orb, Repository repository, String repositoryName, IRFilter filter) {
        this.orb_ = orb;
        this.repository_ = repository;
        IRRepository r = new IRRepository(repositoryName, this.repository_);
        this.root_ = new IRTreeNode(null, r, filter);
    }

    public Object getRoot() {
        return this.root_;
    }

    public Object getChild(Object parent, int index) {
        IRTreeNode ent = (IRTreeNode)parent;
        return ent.getChildAt(index);
    }

    public int getChildCount(Object parent) {
        IRTreeNode node = (IRTreeNode)parent;
        return node.getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        IRTreeNode ent = (IRTreeNode)parent;
        return ent.getIndex((TreeNode)child);
    }

    public boolean isLeaf(Object node) {
        IRTreeNode ent = (IRTreeNode)node;
        return ent.isLeaf();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners_.addElement(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners_.removeElement(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected void nodeChanged(IRTreeNode parent, int index) {
        int[] indices = new int[]{index};
        Object[] children = new Object[]{parent.getChildAt(index)};
        Object[] path = parent.getPath();
        this.fireTreeNodesChanged(this, path, indices, children);
    }

    protected void nodeInserted(IRTreeNode parent, int index) {
        int[] indices = new int[]{index};
        Object[] children = new Object[]{parent.getChildAt(index)};
        Object[] path = parent.getPath();
        this.fireTreeNodesInserted(this, path, indices, children);
    }

    protected void nodeRemoved(IRTreeNode parent, int index, IRTreeNode child) {
        int[] indices = new int[]{index};
        Object[] children = new Object[]{child};
        Object[] path = parent.getPath();
        this.fireTreeNodesRemoved(this, path, indices, children);
    }

    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        Enumeration e = this.listeners_.elements();
        while (e.hasMoreElements()) {
            TreeModelListener l = (TreeModelListener)e.nextElement();
            l.treeNodesChanged(event);
        }
    }

    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        Enumeration e = this.listeners_.elements();
        while (e.hasMoreElements()) {
            TreeModelListener l = (TreeModelListener)e.nextElement();
            l.treeNodesInserted(event);
        }
    }

    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        Enumeration e = this.listeners_.elements();
        while (e.hasMoreElements()) {
            TreeModelListener l = (TreeModelListener)e.nextElement();
            l.treeNodesRemoved(event);
        }
    }

    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        TreeModelEvent event = new TreeModelEvent(source, path, childIndices, children);
        Enumeration e = this.listeners_.elements();
        while (e.hasMoreElements()) {
            TreeModelListener l = (TreeModelListener)e.nextElement();
            l.treeStructureChanged(event);
        }
    }
}

