/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBTypedEventChannelFactory;

import com.ooc.CosEvent.EventLogger;
import com.ooc.CosEvent.Reaper;
import com.ooc.CosTypedEventChannelAdmin.TypedEventChannel_impl;
import com.ooc.OB.Assert;
import com.ooc.OBEventChannelFactory.ChannelAlreadyExists;
import com.ooc.OBEventChannelFactory.ChannelNotAvailable;
import com.ooc.OBTypedEventChannelFactory.TypedEventChannelFactoryPOA;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CosTypedEventChannelAdmin.TypedEventChannel;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public final class TypedEventChannelFactory_impl
extends TypedEventChannelFactoryPOA {
    private ORB orb_;
    private POA poa_;
    private EventLogger logger_;
    private Reaper reaper_;
    private Hashtable channels_;

    private synchronized void reap() {
        Enumeration keys = this.channels_.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            TypedEventChannel_impl c = (TypedEventChannel_impl)this.channels_.get(key);
            if (c == null || !c.destroyed()) continue;
            this.channels_.remove(key);
        }
    }

    public TypedEventChannelFactory_impl(ORB orb, POA poa, EventLogger logger, Reaper reaper) {
        this.orb_ = orb;
        this.poa_ = poa;
        this.logger_ = logger;
        this.reaper_ = reaper;
        this.channels_ = new Hashtable(63);
        if (this.logger_.traceLifecycle() >= 1) {
            this.logger_.trace("event", "creating TypedEventChannelFactory");
        }
    }

    protected void finalize() throws Throwable {
        if (this.logger_.traceLifecycle() >= 1) {
            this.logger_.trace("event", "destroying TypedEventChannelFactory");
        }
        Assert._OB_assert((this.channels_ == null ? 1 : 0) != 0);
    }

    public TypedEventChannel create_channel(String id) throws ChannelAlreadyExists {
        this.reap();
        TypedEventChannel_impl c = new TypedEventChannel_impl(this.orb_, this.poa_, this.logger_, this.reaper_, id);
        byte[] oid = id.getBytes();
        try {
            this.poa_.activate_object_with_id(oid, (Servant)c);
        }
        catch (ObjectAlreadyActive ex) {
            throw new ChannelAlreadyExists();
        }
        catch (ServantAlreadyActive ex) {
            throw new ChannelAlreadyExists();
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException();
        }
        this.channels_.put(id, c);
        return c._this(this.orb_);
    }

    public synchronized TypedEventChannel get_channel_by_id(String id) throws ChannelNotAvailable {
        this.reap();
        TypedEventChannel_impl c = (TypedEventChannel_impl)this.channels_.get(id);
        if (c == null) {
            throw new ChannelNotAvailable();
        }
        try {
            return c._this();
        }
        catch (OBJ_ADAPTER ex) {
            throw new ChannelNotAvailable();
        }
    }

    public String[] get_channels() {
        this.reap();
        Vector<String> v = new Vector<String>();
        Enumeration keys = this.channels_.keys();
        while (keys.hasMoreElements()) {
            v.addElement((String)keys.nextElement());
        }
        Object[] channelIds = new String[v.size()];
        v.copyInto(channelIds);
        return channelIds;
    }

    public synchronized void shutdown() {
        if (this.orb_ == null) {
            return;
        }
        POAManager manager = this.poa_.the_POAManager();
        try {
            manager.discard_requests(false);
        }
        catch (AdapterInactive ex) {
            throw new RuntimeException();
        }
        Enumeration elements = this.channels_.elements();
        while (elements.hasMoreElements()) {
            TypedEventChannel_impl c = (TypedEventChannel_impl)elements.nextElement();
            if (c == null) continue;
            c.discardRequests();
            if (c.destroyed()) continue;
            c.destroy();
        }
        this.channels_.clear();
        this.channels_ = null;
        this.orb_.shutdown(false);
        this.orb_ = null;
    }

    public POA _default_POA() {
        return this.poa_;
    }
}

