/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.CORBA.ORB;
import com.ooc.CosEvent.EventLogger;
import com.ooc.CosEvent.ProxyBase;
import java.util.Properties;
import java.util.Vector;

public class Reaper
extends Thread {
    private EventLogger logger_;
    private boolean done_;
    private long sleepTime_;
    private long reapTime_;
    private Vector proxies_ = new Vector();

    private void reap() {
        if (this.logger_.traceLifecycle() >= 2) {
            this.logger_.trace("event", "Reaping");
        }
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < this.proxies_.size()) {
            long last;
            ProxyBase proxy = (ProxyBase)this.proxies_.elementAt(i);
            if (proxy.destroyed()) {
                this.proxies_.removeElementAt(i);
                continue;
            }
            if (proxy.canReap() && now - (last = proxy.lastRequestTime()) >= this.reapTime_ * 1000L) {
                if (this.logger_.traceLifecycle() >= 2) {
                    this.logger_.trace("event", "Reaping: " + proxy.getName());
                }
                proxy.disconnect();
                this.proxies_.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    public Reaper(org.omg.CORBA.ORB orb, EventLogger logger) {
        this.logger_ = logger;
        this.done_ = false;
        this.sleepTime_ = 1800L;
        this.reapTime_ = 14400L;
        ORB oborb = (ORB)orb;
        Properties props = oborb.properties();
        String val = props.getProperty("ooc.event.reap_frequency");
        if (val != null) {
            try {
                this.sleepTime_ = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((val = props.getProperty("ooc.event.inactivity_timeout")) != null) {
            try {
                this.reapTime_ = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public synchronized void add(ProxyBase proxy) {
        if (proxy.canReap()) {
            this.proxies_.addElement(proxy);
        }
    }

    public synchronized void destroy() {
        this.done_ = true;
        this.notify();
    }

    public synchronized void run() {
        if (this.sleepTime_ == 0L) {
            if (this.logger_.traceLifecycle() >= 2) {
                this.logger_.trace("event", "Reaping disabled");
            }
            return;
        }
        while (!this.done_) {
            try {
                this.wait(this.sleepTime_ * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.done_) continue;
            this.reap();
        }
    }
}

