/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CosEvent;

import com.ooc.CosEvent.EventLogger;

public class PropagatorBaseThread
extends Thread {
    protected EventLogger logger_;
    private long maxRetries_;
    private long retryTimeout_;
    private double retryMultiplier_;
    private long retry_;
    private long retries_;
    public boolean done_;
    public long id_;

    public synchronized boolean retry() {
        if (++this.retries_ > this.maxRetries_) {
            return false;
        }
        if (this.logger_.traceEvents() >= 1) {
            this.logger_.trace("event", "retry(" + this.id_ + ") " + this.retries_ + "/" + this.maxRetries_ + " in " + this.retry_ + " ms");
        }
        this.delay(this.retry_);
        this.retry_ = (long)((double)this.retry_ * this.retryMultiplier_);
        return !this.done_;
    }

    public synchronized void delay(long msec) {
        long now;
        long timeDone = System.currentTimeMillis() + msec;
        while (!this.done_ && timeDone > (now = System.currentTimeMillis())) {
            long interval = timeDone - now;
            try {
                this.wait(interval);
            }
            catch (InterruptedException e) {}
        }
    }

    public void resetRetry() {
        this.retries_ = 0L;
        this.retry_ = this.retryTimeout_;
    }

    public PropagatorBaseThread(EventLogger logger, String name, long id, long maxRetries, long retryTimeout, double retryMultiplier) {
        super("ORBACUS:EventService:" + name + "-" + id);
        this.logger_ = logger;
        this.maxRetries_ = maxRetries;
        this.retryTimeout_ = retryTimeout;
        this.retryMultiplier_ = retryMultiplier;
        this.retry_ = retryTimeout;
        this.retries_ = 0L;
        this.done_ = false;
        this.id_ = id;
    }

    public synchronized void halt() {
        this.done_ = true;
        this.notify();
    }
}

